# This file is generated by numpy's build process
# It contains system_info results at the time of building this package.
from enum import Enum
from numpy._core._multiarray_umath import (
    __cpu_features__,
    __cpu_baseline__,
    __cpu_dispatch__,
)

__all__ = ["show_config"]
_built_with_meson = True


class DisplayModes(Enum):
    stdout = "stdout"
    dicts = "dicts"


def _cleanup(d):
    """
    Removes empty values in a `dict` recursively
    This ensures we remove values that Meson could not provide to CONFIG
    """
    if isinstance(d, dict):
        return {k: _cleanup(v) for k, v in d.items() if v and _cleanup(v)}
    else:
        return d


CONFIG = _cleanup(
    {
        "Compilers": {
            "c": {
                "name": "clang",
                "linker": r"ld64",
                "version": "19.1.7",
                "commands": r"x86_64-apple-darwin13.4.0-clang",
                "args": r"-march=core2, -mtune=haswell, -mssse3, -ftree-vectorize, -fPIC, -fstack-protector-strong, -O2, -pipe, -isystem, /Users/dlshudson/jenkins_slave/workspace/dials_installer_macos/build_dials/conda_base/include, -fdebug-prefix-map=/Users/runner/miniforge3/conda-bld/bld/rattler-build_numpy_1770098377/work=/usr/local/src/conda/numpy-2.4.2, -fdebug-prefix-map=/Users/dlshudson/jenkins_slave/workspace/dials_installer_macos/build_dials/conda_base=/usr/local/src/conda-prefix, -D_FORTIFY_SOURCE=2, -isystem, /Users/dlshudson/jenkins_slave/workspace/dials_installer_macos/build_dials/conda_base/include, -mmacosx-version-min=10.13, -mmacosx-version-min=10.13",
                "linker args": r"-Wl,-headerpad_max_install_names, -Wl,-dead_strip_dylibs, -Wl,-rpath,/Users/dlshudson/jenkins_slave/workspace/dials_installer_macos/build_dials/conda_base/lib, -L/Users/dlshudson/jenkins_slave/workspace/dials_installer_macos/build_dials/conda_base/lib, -march=core2, -mtune=haswell, -mssse3, -ftree-vectorize, -fPIC, -fstack-protector-strong, -O2, -pipe, -isystem, /Users/dlshudson/jenkins_slave/workspace/dials_installer_macos/build_dials/conda_base/include, -fdebug-prefix-map=/Users/runner/miniforge3/conda-bld/bld/rattler-build_numpy_1770098377/work=/usr/local/src/conda/numpy-2.4.2, -fdebug-prefix-map=/Users/dlshudson/jenkins_slave/workspace/dials_installer_macos/build_dials/conda_base=/usr/local/src/conda-prefix, -D_FORTIFY_SOURCE=2, -isystem, /Users/dlshudson/jenkins_slave/workspace/dials_installer_macos/build_dials/conda_base/include, -mmacosx-version-min=10.13, -mmacosx-version-min=10.13",
            },
            "cython": {
                "name": "cython",
                "linker": r"cython",
                "version": "3.2.4",
                "commands": r"cython",
                "args": r"",
                "linker args": r"",
            },
            "c++": {
                "name": "clang",
                "linker": r"ld64",
                "version": "19.1.7",
                "commands": r"x86_64-apple-darwin13.4.0-clang++",
                "args": r"-march=core2, -mtune=haswell, -mssse3, -ftree-vectorize, -fPIC, -fstack-protector-strong, -O2, -pipe, -stdlib=libc++, -fvisibility-inlines-hidden, -fmessage-length=0, -isystem, /Users/dlshudson/jenkins_slave/workspace/dials_installer_macos/build_dials/conda_base/include, -fdebug-prefix-map=/Users/runner/miniforge3/conda-bld/bld/rattler-build_numpy_1770098377/work=/usr/local/src/conda/numpy-2.4.2, -fdebug-prefix-map=/Users/dlshudson/jenkins_slave/workspace/dials_installer_macos/build_dials/conda_base=/usr/local/src/conda-prefix, -D_FORTIFY_SOURCE=2, -isystem, /Users/dlshudson/jenkins_slave/workspace/dials_installer_macos/build_dials/conda_base/include, -mmacosx-version-min=10.13, -mmacosx-version-min=10.13",
                "linker args": r"-Wl,-headerpad_max_install_names, -Wl,-dead_strip_dylibs, -Wl,-rpath,/Users/dlshudson/jenkins_slave/workspace/dials_installer_macos/build_dials/conda_base/lib, -L/Users/dlshudson/jenkins_slave/workspace/dials_installer_macos/build_dials/conda_base/lib, -march=core2, -mtune=haswell, -mssse3, -ftree-vectorize, -fPIC, -fstack-protector-strong, -O2, -pipe, -stdlib=libc++, -fvisibility-inlines-hidden, -fmessage-length=0, -isystem, /Users/dlshudson/jenkins_slave/workspace/dials_installer_macos/build_dials/conda_base/include, -fdebug-prefix-map=/Users/runner/miniforge3/conda-bld/bld/rattler-build_numpy_1770098377/work=/usr/local/src/conda/numpy-2.4.2, -fdebug-prefix-map=/Users/dlshudson/jenkins_slave/workspace/dials_installer_macos/build_dials/conda_base=/usr/local/src/conda-prefix, -D_FORTIFY_SOURCE=2, -isystem, /Users/dlshudson/jenkins_slave/workspace/dials_installer_macos/build_dials/conda_base/include, -mmacosx-version-min=10.13, -mmacosx-version-min=10.13",
            },
        },
        "Machine Information": {
            "host": {
                "cpu": "x86_64",
                "family": "x86_64",
                "endian": "little",
                "system": "darwin",
            },
            "build": {
                "cpu": "x86_64",
                "family": "x86_64",
                "endian": "little",
                "system": "darwin",
            },
            "cross-compiled": bool("False".lower().replace("false", "")),
        },
        "Build Dependencies": {
            "blas": {
                "name": "blas",
                "found": bool("True".lower().replace("false", "")),
                "version": "3.9.0",
                "detection method": "pkgconfig",
                "include directory": r"/Users/dlshudson/jenkins_slave/workspace/dials_installer_macos/build_dials/conda_base/include",
                "lib directory": r"/Users/dlshudson/jenkins_slave/workspace/dials_installer_macos/build_dials/conda_base/lib",
                "openblas configuration": r"unknown",
                "pc file directory": r"/Users/dlshudson/jenkins_slave/workspace/dials_installer_macos/build_dials/conda_base/lib/pkgconfig",
            },
            "lapack": {
                "name": "lapack",
                "found": bool("True".lower().replace("false", "")),
                "version": "3.9.0",
                "detection method": "pkgconfig",
                "include directory": r"/Users/dlshudson/jenkins_slave/workspace/dials_installer_macos/build_dials/conda_base/include",
                "lib directory": r"/Users/dlshudson/jenkins_slave/workspace/dials_installer_macos/build_dials/conda_base/lib",
                "openblas configuration": r"unknown",
                "pc file directory": r"/Users/dlshudson/jenkins_slave/workspace/dials_installer_macos/build_dials/conda_base/lib/pkgconfig",
            },
        },
        "Python Information": {
            "path": r"/Users/dlshudson/jenkins_slave/workspace/dials_installer_macos/build_dials/conda_base/bin/python",
            "version": "3.12",
        },
        "SIMD Extensions": {
            "baseline": __cpu_baseline__,
            "found": [
                feature for feature in __cpu_dispatch__ if __cpu_features__[feature]
            ],
            "not found": [
                feature for feature in __cpu_dispatch__ if not __cpu_features__[feature]
            ],
        },
    }
)


def _check_pyyaml():
    import yaml

    return yaml


def show(mode=DisplayModes.stdout.value):
    """
    Show libraries and system information on which NumPy was built
    and is being used

    Parameters
    ----------
    mode : {`'stdout'`, `'dicts'`}, optional.
        Indicates how to display the config information.
        `'stdout'` prints to console, `'dicts'` returns a dictionary
        of the configuration.

    Returns
    -------
    out : {`dict`, `None`}
        If mode is `'dicts'`, a dict is returned, else None

    See Also
    --------
    get_include : Returns the directory containing NumPy C
                  header files.

    Notes
    -----
    1. The `'stdout'` mode will give more readable
       output if ``pyyaml`` is installed

    """
    if mode == DisplayModes.stdout.value:
        try:  # Non-standard library, check import
            yaml = _check_pyyaml()

            print(yaml.dump(CONFIG))
        except ModuleNotFoundError:
            import warnings
            import json

            warnings.warn("Install `pyyaml` for better output", stacklevel=1)
            print(json.dumps(CONFIG, indent=2))
    elif mode == DisplayModes.dicts.value:
        return CONFIG
    else:
        raise AttributeError(
            f"Invalid `mode`, use one of: {', '.join([e.value for e in DisplayModes])}"
        )


def show_config(mode=DisplayModes.stdout.value):
    return show(mode)


show_config.__doc__ = show.__doc__
show_config.__module__ = "numpy"
