# This file is generated by SciPy's build process
# It contains system_info results at the time of building this package.
from enum import Enum

__all__ = ["show"]
_built_with_meson = True


class DisplayModes(Enum):
    stdout = "stdout"
    dicts = "dicts"


def _cleanup(d):
    """
    Removes empty values in a `dict` recursively
    This ensures we remove values that Meson could not provide to CONFIG
    """
    if isinstance(d, dict):
        return { k: _cleanup(v) for k, v in d.items() if v != '' and _cleanup(v) != '' }
    else:
        return d


CONFIG = _cleanup(
    {
        "Compilers": {
            "c": {
                "name": "gcc",
                "linker": r"ld.bfd",
                "version": "14.3.0",
                "commands": r"/home/conda/feedstock_root/build_artifacts/scipy-split_1771879141535/_build_env/bin/x86_64-conda-linux-gnu-cc",
                "args": r"-march=nocona, -mtune=haswell, -ftree-vectorize, -fPIC, -fstack-protector-strong, -fno-plt, -O2, -ffunction-sections, -pipe, -isystem, /home/conda/feedstock_root/build_artifacts/scipy-split_1771879141535/_h_env_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold/include, -fdebug-prefix-map=/home/conda/feedstock_root/build_artifacts/scipy-split_1771879141535/work=/usr/local/src/conda/scipy-split-1.17.1, -fdebug-prefix-map=/home/conda/feedstock_root/build_artifacts/scipy-split_1771879141535/_h_env_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold=/usr/local/src/conda-prefix, -DNDEBUG, -D_FORTIFY_SOURCE=2, -O2, -isystem, /home/conda/feedstock_root/build_artifacts/scipy-split_1771879141535/_h_env_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold/include",
                "linker args": r"-Wl,-O2, -Wl,--sort-common, -Wl,--as-needed, -Wl,-z,relro, -Wl,-z,now, -Wl,--disable-new-dtags, -Wl,--gc-sections, -Wl,--allow-shlib-undefined, -Wl,-rpath,/home/conda/feedstock_root/build_artifacts/scipy-split_1771879141535/_h_env_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold/lib, -Wl,-rpath-link,/home/conda/feedstock_root/build_artifacts/scipy-split_1771879141535/_h_env_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold/lib, -L/home/conda/feedstock_root/build_artifacts/scipy-split_1771879141535/_h_env_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold/lib, -march=nocona, -mtune=haswell, -ftree-vectorize, -fPIC, -fstack-protector-strong, -fno-plt, -O2, -ffunction-sections, -pipe, -isystem, /home/conda/feedstock_root/build_artifacts/scipy-split_1771879141535/_h_env_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold/include, -fdebug-prefix-map=/home/conda/feedstock_root/build_artifacts/scipy-split_1771879141535/work=/usr/local/src/conda/scipy-split-1.17.1, -fdebug-prefix-map=/home/conda/feedstock_root/build_artifacts/scipy-split_1771879141535/_h_env_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold=/usr/local/src/conda-prefix, -DNDEBUG, -D_FORTIFY_SOURCE=2, -O2, -isystem, /home/conda/feedstock_root/build_artifacts/scipy-split_1771879141535/_h_env_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold/include",
            },
            "cython": {
                "name": r"cython",
                "linker": r"cython",
                "version": r"3.2.4",
                "commands": r"cython",
                "args": r"",
                "linker args": r"",
            },
            "c++": {
                "name": "gcc",
                "linker": r"ld.bfd",
                "version": "14.3.0",
                "commands": r"/home/conda/feedstock_root/build_artifacts/scipy-split_1771879141535/_build_env/bin/x86_64-conda-linux-gnu-c++",
                "args": r"-fvisibility-inlines-hidden, -fmessage-length=0, -march=nocona, -mtune=haswell, -ftree-vectorize, -fPIC, -fstack-protector-strong, -fno-plt, -O2, -ffunction-sections, -pipe, -isystem, /home/conda/feedstock_root/build_artifacts/scipy-split_1771879141535/_h_env_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold/include, -fdebug-prefix-map=/home/conda/feedstock_root/build_artifacts/scipy-split_1771879141535/work=/usr/local/src/conda/scipy-split-1.17.1, -fdebug-prefix-map=/home/conda/feedstock_root/build_artifacts/scipy-split_1771879141535/_h_env_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold=/usr/local/src/conda-prefix, -DNDEBUG, -D_FORTIFY_SOURCE=2, -O2, -isystem, /home/conda/feedstock_root/build_artifacts/scipy-split_1771879141535/_h_env_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold/include",
                "linker args": r"-Wl,-O2, -Wl,--sort-common, -Wl,--as-needed, -Wl,-z,relro, -Wl,-z,now, -Wl,--disable-new-dtags, -Wl,--gc-sections, -Wl,--allow-shlib-undefined, -Wl,-rpath,/home/conda/feedstock_root/build_artifacts/scipy-split_1771879141535/_h_env_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold/lib, -Wl,-rpath-link,/home/conda/feedstock_root/build_artifacts/scipy-split_1771879141535/_h_env_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold/lib, -L/home/conda/feedstock_root/build_artifacts/scipy-split_1771879141535/_h_env_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold/lib, -fvisibility-inlines-hidden, -fmessage-length=0, -march=nocona, -mtune=haswell, -ftree-vectorize, -fPIC, -fstack-protector-strong, -fno-plt, -O2, -ffunction-sections, -pipe, -isystem, /home/conda/feedstock_root/build_artifacts/scipy-split_1771879141535/_h_env_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold/include, -fdebug-prefix-map=/home/conda/feedstock_root/build_artifacts/scipy-split_1771879141535/work=/usr/local/src/conda/scipy-split-1.17.1, -fdebug-prefix-map=/home/conda/feedstock_root/build_artifacts/scipy-split_1771879141535/_h_env_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold=/usr/local/src/conda-prefix, -DNDEBUG, -D_FORTIFY_SOURCE=2, -O2, -isystem, /home/conda/feedstock_root/build_artifacts/scipy-split_1771879141535/_h_env_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold/include",
            },
            "fortran": {
                "name": "gcc",
                "linker": r"ld.bfd",
                "version": "14.3.0",
                "commands": r"/home/conda/feedstock_root/build_artifacts/scipy-split_1771879141535/_build_env/bin/x86_64-conda-linux-gnu-gfortran",
                "args": r"-march=nocona, -mtune=haswell, -ftree-vectorize, -fPIC, -fstack-protector-strong, -fno-plt, -O2, -ffunction-sections, -pipe, -isystem, /home/conda/feedstock_root/build_artifacts/scipy-split_1771879141535/_h_env_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold/include, -I/home/conda/feedstock_root/build_artifacts/scipy-split_1771879141535/_build_env/include, -fdebug-prefix-map=/home/conda/feedstock_root/build_artifacts/scipy-split_1771879141535/work=/usr/local/src/conda/scipy-split-1.17.1, -fdebug-prefix-map=/home/conda/feedstock_root/build_artifacts/scipy-split_1771879141535/_h_env_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold=/usr/local/src/conda-prefix",
                "linker args": r"-Wl,-O2, -Wl,--sort-common, -Wl,--as-needed, -Wl,-z,relro, -Wl,-z,now, -Wl,--disable-new-dtags, -Wl,--gc-sections, -Wl,--allow-shlib-undefined, -Wl,-rpath,/home/conda/feedstock_root/build_artifacts/scipy-split_1771879141535/_h_env_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold/lib, -Wl,-rpath-link,/home/conda/feedstock_root/build_artifacts/scipy-split_1771879141535/_h_env_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold/lib, -L/home/conda/feedstock_root/build_artifacts/scipy-split_1771879141535/_h_env_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold/lib, -march=nocona, -mtune=haswell, -ftree-vectorize, -fPIC, -fstack-protector-strong, -fno-plt, -O2, -ffunction-sections, -pipe, -isystem, /home/conda/feedstock_root/build_artifacts/scipy-split_1771879141535/_h_env_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold/include, -I/home/conda/feedstock_root/build_artifacts/scipy-split_1771879141535/_build_env/include, -fdebug-prefix-map=/home/conda/feedstock_root/build_artifacts/scipy-split_1771879141535/work=/usr/local/src/conda/scipy-split-1.17.1, -fdebug-prefix-map=/home/conda/feedstock_root/build_artifacts/scipy-split_1771879141535/_h_env_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold=/usr/local/src/conda-prefix",
            },
            "pythran": {
                "version": r"0.18.1",
                "include directory": r"../../_h_env_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold/lib/python3.13/site-packages/pythran"
            },
        },
        "Machine Information": {
            "host": {
                "cpu": r"x86_64",
                "family": r"x86_64",
                "endian": r"little",
                "system": r"linux",
            },
            "build": {
                "cpu": r"x86_64",
                "family": r"x86_64",
                "endian": r"little",
                "system": r"linux",
            },
            "cross-compiled": bool("False".lower().replace('false', '')),
        },
        "Build Dependencies": {
            "blas": {
                "name": "blas",
                "found": bool("True".lower().replace('false', '')),
                "version": "3.9.0",
                "detection method": "pkgconfig",
                "include directory": r"/home/conda/feedstock_root/build_artifacts/scipy-split_1771879141535/_h_env_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold/include",
                "lib directory": r"/home/conda/feedstock_root/build_artifacts/scipy-split_1771879141535/_h_env_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold/lib",
                "openblas configuration": r"unknown",
                "pc file directory": r"/home/conda/feedstock_root/build_artifacts/scipy-split_1771879141535/_h_env_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold/lib/pkgconfig",
                "has ilp64": bool(r"False".lower().replace('false', '')),
            },
            "lapack": {
                "name": "lapack",
                "found": bool("True".lower().replace('false', '')),
                "version": "3.9.0",
                "detection method": "pkgconfig",
                "include directory": r"/home/conda/feedstock_root/build_artifacts/scipy-split_1771879141535/_h_env_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold/include",
                "lib directory": r"/home/conda/feedstock_root/build_artifacts/scipy-split_1771879141535/_h_env_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold/lib",
                "openblas configuration": r"unknown",
                "pc file directory": r"/home/conda/feedstock_root/build_artifacts/scipy-split_1771879141535/_h_env_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold/lib/pkgconfig",
                "has ilp64": bool(r"False".lower().replace('false', '')),
            },
            "pybind11": {
                "name": "pybind11",
                "version": "3.0.2",
                "detection method": "pkgconfig",
                "include directory": r"/home/conda/feedstock_root/build_artifacts/scipy-split_1771879141535/_h_env_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold/include",
            },
        },
        "Python Information": {
            "path": r"/home/conda/feedstock_root/build_artifacts/scipy-split_1771879141535/_h_env_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold/bin/python",
            "version": "3.13",
        },
    }
)


def _check_pyyaml():
    import yaml

    return yaml


def show(mode=DisplayModes.stdout.value):
    """
    Show libraries and system information on which SciPy was built
    and is being used

    Parameters
    ----------
    mode : {`'stdout'`, `'dicts'`}, optional.
        Indicates how to display the config information.
        `'stdout'` prints to console, `'dicts'` returns a dictionary
        of the configuration.

    Returns
    -------
    out : {`dict`, `None`}
        If mode is `'dicts'`, a dict is returned, else None

    Examples
    --------
    >>> import scipy
    >>> scipy.show_config()
    ... # formatted output is printed to the console

    >>> config_dict = scipy.show_config(mode='dicts')
    >>> list(config_dict.keys())
    ['Compilers', 'Machine Information', 'Build Dependencies', 'Python Information']

    Notes
    -----
    1. The `'stdout'` mode will give more readable
       output if ``pyyaml`` is installed

    """
    if mode == DisplayModes.stdout.value:
        try:  # Non-standard library, check import
            yaml = _check_pyyaml()

            print(yaml.dump(CONFIG))
        except ModuleNotFoundError:
            import warnings
            import json

            warnings.warn("Install `pyyaml` for better output", stacklevel=1)
            print(json.dumps(CONFIG, indent=2))
    elif mode == DisplayModes.dicts.value:
        return CONFIG
    else:
        raise AttributeError(
            f"Invalid `mode`, use one of: {', '.join([e.value for e in DisplayModes])}"
        )
