# Safety Checks and Validations

This document is auto-generated by `agent/generate_safety_docs.py`.

## Overview

The PHENIX AI Agent includes multiple layers of safety checks:

| Category | Count |
|----------|-------|
| Sanity Checks (Pre-Execution) | 20 |
| Directive Validation (Post-LLM) | 7 |
| File Validation | 4 |
| Workflow State Validation | 8 |
| Command Building Validation | 3 |
| Input Validation | 29 |
| Post-Processing Corrections | 4 |

## Sanity Check Issues

These are the specific issues that can be detected by the SanityChecker:

| Code | Severity | Message |
|------|----------|---------|
| `no_data_for_workflow` | critical | No reflection data file found for X-ray workflow |
| `no_data_for_workflow` | critical | No map file found for cryo-EM workflow |
| `no_model_for_refine` | critical | Refinement requested but no model file available |
| `search_model_not_positioned` | critical | Cannot refine: search model found but not yet positioned |
| `resolution_unknown` | warning | Entering refinement phase without established resolution |

## Sanity Check Functions

### `agent/directive_validator.py`

| Name | Line | Type | Description |
|------|------|------|-------------|
| `ValidationResult` | 58 | class | Result of directive validation. |

### `agent/sanity_checker.py`

| Name | Line | Type | Description |
|------|------|------|-------------|
| `SanityChecker` | 67 | class | Checks for impossible or nonsensical agent states.  Loads check definitions from... |
| `SanityIssue` | 32 | class | A single sanity check failure. |
| `SanityResult` | 46 | class | Result of sanity checking. |
| `_check_data_exists` | 286 | function | Check that required experimental data exists for the workflow. |
| `_check_experiment_type_stable` | 185 | function | Check that experiment type hasn't changed unexpectedly. |
| `_check_metric_anomalies` | 392 | function | Check for dramatic metric changes that indicate problems. |
| `_check_model_for_refine` | 203 | function | Check that a POSITIONED model exists when entering refine state.  With semantic ... |
| `_check_repeated_failures` | 315 | function | Check for repeated identical failures. |
| `_check_resolution_established` | 377 | function | Warn if entering refinement without established resolution. |
| `check` | 99 | function | (No docstring) |
| `experiment_type_changed` | 192 | sanity_issue | Severity: critical |
| `map_cc_drop` | 425 | sanity_issue | Severity: warning |
| `no_data_for_workflow` | 296 | sanity_issue | Severity: critical |
| `no_data_for_workflow` | 305 | sanity_issue | Severity: critical |
| `no_model_for_refine` | 274 | sanity_issue | Severity: critical |
| `r_free_spike` | 409 | sanity_issue | Severity: warning |
| `repeated_failures` | 345 | sanity_issue | Severity: critical |
| `resolution_unknown` | 383 | sanity_issue | Severity: warning |
| `search_model_not_positioned` | 260 | sanity_issue | Severity: critical |

## Directive Validation (Post-LLM)

### `agent/directive_extractor.py`

| Name | Line | Type | Description |
|------|------|------|-------------|
| `check_stop_conditions` | 939 | function | Check if any stop conditions are met.  Args: directives: Directives dict cycle_n... |
| `validate_directives` | 547 | function | Validate and clean extracted directives.  Removes invalid entries, converts type... |

### `agent/directive_validator.py`

| Name | Line | Type | Description |
|------|------|------|-------------|
| `_check_max_program_cycles` | 1023 | function | Check if max cycles for a specific program have been reached.  Args: directives:... |
| `_check_stop_conditions` | 955 | function | Check all stop conditions from directives.  Args: directives: Directives dict cy... |
| `check_program_available` | 708 | function | Quick check if a specific program is available. |
| `validate_directives` | 505 | function | (No docstring) |
| `validate_intent` | 757 | function | Validate and modify an LLM intent against user directives.  This applies program... |

## File Validation

### `agent/best_files_tracker.py`

| Name | Line | Type | Description |
|------|------|------|-------------|
| `_is_intermediate_file` | 1120 | function | Check if a file is an intermediate that shouldn't be tracked.  Args: path: File ... |

### `agent/yaml_tools.py`

| Name | Line | Type | Description |
|------|------|------|-------------|
| `_validate_file_categories` | 293 | function | Validate file_categories.yaml structure. |
| `validate_files` | 1295 | function | Validate YAML files and report issues. |

### `knowledge/yaml_loader.py`

| Name | Line | Type | Description |
|------|------|------|-------------|
| `validate_yaml_files` | 673 | function | Validate that all YAML files are present and well-formed.  Returns: tuple: (is_v... |

## Workflow State Validation

### `agent/program_validator.py`

| Name | Line | Type | Description |
|------|------|------|-------------|
| `check_workflow_engine` | 208 | function | Check if program is in workflow engine context (if needed). |
| `check_workflow_state` | 180 | function | Check if program has history tracking. |
| `check_workflows_yaml` | 99 | function | Check if program is included in workflows.yaml. |

### `agent/workflow_engine.py`

| Name | Line | Type | Description |
|------|------|------|-------------|
| `_check_conditions` | 852 | function | Check if program conditions are met. |
| `_check_metric_condition` | 878 | function | Check a metric condition like "> 0.35" or "< target_r_free". |
| `_check_priority_condition` | 1047 | function | Check if a priority_when condition is satisfied.  Args: condition: Condition str... |

### `agent/workflow_state.py`

| Name | Line | Type | Description |
|------|------|------|-------------|
| `validate_program_choice` | 683 | function | Validate that a program choice is allowed in the current state.  Args: chosen_pr... |

### `agent/yaml_tools.py`

| Name | Line | Type | Description |
|------|------|------|-------------|
| `_validate_workflows` | 594 | function | Validate workflows.yaml structure. |

## Command Building Validation

### `agent/template_builder.py`

| Name | Line | Type | Description |
|------|------|------|-------------|
| `_check_invariant` | 708 | function | Check if an invariant condition is satisfied.  Supports: - has_file: [list of fi... |
| `validate_and_fix` | 649 | function | Validate program invariants and apply fixes if needed.  This is the single place... |
| `validate_intent` | 532 | function | Validate that an intent's files exist in the available files list.  Args: progra... |

## Input Validation

### `agent/error_analyzer.py`

| Name | Line | Type | Description |
|------|------|------|-------------|
| `_check_retry_limits` | 531 | function | Check if we've exceeded retry limits for this error type.  Returns (can_retry, r... |

### `agent/event_log.py`

| Name | Line | Type | Description |
|------|------|------|-------------|
| `has_errors` | 268 | function | Check if any error events were recorded. |

### `agent/graph_nodes.py`

| Name | Line | Type | Description |
|------|------|------|-------------|
| `validate` | 1984 | function | Node D: Validate command before execution.  Checks: 1. Command is not empty 2. P... |
| `validate_provider` | 152 | function | Validate that the provider is supported and properly configured.  Returns: tuple... |

### `agent/pattern_manager.py`

| Name | Line | Type | Description |
|------|------|------|-------------|
| `validate_all` | 454 | function | Validate all patterns against their test cases.  Returns: dict: {pattern_name: (... |
| `validate_pattern` | 389 | function | Validate a pattern against its test cases.  Args: name: Pattern name  Returns: t... |

### `agent/program_validator.py`

| Name | Line | Type | Description |
|------|------|------|-------------|
| `check_directive_extractor` | 261 | function | Check if program has tutorial/directive patterns. |
| `check_log_parsers` | 134 | function | Check if program has log parsing support. |
| `check_programs_yaml` | 55 | function | Check if program is defined in programs.yaml. |
| `check_session_summary` | 236 | function | Check if program metrics appear in session summary. |
| `validate_all` | 360 | function | Validate all programs. |
| `validate_program` | 286 | function | Validate that a program is fully configured. |

### `agent/rate_limit_handler.py`

| Name | Line | Type | Description |
|------|------|------|-------------|
| `_check_decay` | 101 | function | Check if enough time has passed to decay the delay. |

### `agent/session.py`

| Name | Line | Type | Description |
|------|------|------|-------------|
| `_validate_directives` | 302 | function | Validate directives against available capabilities.  Checks if the user is reque... |
| `check_directive_stop_conditions` | 393 | function | Check if any directive stop conditions are met.  Args: cycle_number: Current cyc... |
| `check_max_program_cycles` | 504 | function | Check if max cycles for a program have been reached per directives.  Args: progr... |

### `agent/transport.py`

| Name | Line | Type | Description |
|------|------|------|-------------|
| `verify_roundtrip` | 865 | function | Verify that a request survives the encode/decode roundtrip.  This is useful for ... |

### `agent/yaml_tools.py`

| Name | Line | Type | Description |
|------|------|------|-------------|
| `_validate_check_recursive` | 578 | function | Recursively validate check structure (handles any_of, all_of). |
| `_validate_metrics` | 703 | function | Validate metrics.yaml structure. |
| `_validate_programs` | 359 | function | Validate programs.yaml structure. |
| `validate_yaml_structure` | 260 | function | Validate the structure of a YAML file based on its type.  Returns: list: List of... |

### `knowledge/api_schema.py`

| Name | Line | Type | Description |
|------|------|------|-------------|
| `validate_request` | 304 | function | Validate a v2 request.  Args: request: Dict containing request data strict: If T... |
| `validate_response` | 350 | function | Validate a v2 response.  Args: response: Dict containing response data strict: I... |

### `programs/ai_agent.py`

| Name | Line | Type | Description |
|------|------|------|-------------|
| `_check_benign_error` | 2164 | function | Check if error is benign. |
| `_check_for_fatal_error` | 1902 | function | Check if error text contains fatal error markers. |
| `_validate_command` | 1814 | function | Validate that a command is safe to execute.  Only allows commands that start wit... |
| `_validate_directives` | 2645 | function | Validate directives against available capabilities.  If validation fails (user r... |
| `validate` | 610 | function | (No docstring) |

### `programs/ai_analysis.py`

| Name | Line | Type | Description |
|------|------|------|-------------|
| `validate` | 321 | function | (No docstring) |

## Post-Processing Corrections

### `agent/directive_extractor.py`

| Name | Line | Type | Description |
|------|------|------|-------------|
| `_fix_ligand_workflow_conflict` | 700 | function | Fix conflicting directives when ligand fitting workflow is detected.  If user wa... |
| `_fix_ligand_workflow_conflict` | 700 | function | Fix conflicting directives when ligand fitting workflow is detected.  If user wa... |
| `_fix_program_name` | 738 | function | Try to fix common variations in program names.  Args: name: Potentially incorrec... |
| `_fix_program_name` | 738 | function | Try to fix common variations in program names.  Args: name: Potentially incorrec... |

