'''OpenGL extension NV.alpha_to_coverage_dither_control

This module customises the behaviour of the 
OpenGL.raw.GL.NV.alpha_to_coverage_dither_control to provide a more 
Python-friendly API

Overview (from the spec)
	
	NV_alpha_to_coverage_dither_control_triangles provides a new mechanism
	to control whether dithering is applied when the existing alpha to coverage
	functionality is used.
	

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/NV/alpha_to_coverage_dither_control.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GL import _types, _glgets
from OpenGL.raw.GL.NV.alpha_to_coverage_dither_control import *
from OpenGL.raw.GL.NV.alpha_to_coverage_dither_control import _EXTENSION_NAME

def glInitAlphaToCoverageDitherControlNV():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )


### END AUTOGENERATED SECTION