



/*!
@file
Defines the `BOOST_HANA_DEFINE_STRUCT`, `BOOST_HANA_ADAPT_STRUCT`, and
`BOOST_HANA_ADAPT_ADT` macros.

Copyright Louis Dionne 2013-2022
Distributed under the Boost Software License, Version 1.0.
(See accompanying file LICENSE.md or copy at http://boost.org/LICENSE_1_0.txt)
 */

//////////////////////////////////////////////////////////////////////////////
// THIS FILE IS GENERATED FROM THE <boost/hana/detail/struct_macros.erb.hpp>
// ERB TEMPLATE. DO NOT EDIT THIS FILE DIRECTLY.
//
// THE ERB TEMPLATE CONTAINS INFORMATION ABOUT HOW TO REGENERATE THIS FILE.
//////////////////////////////////////////////////////////////////////////////

#ifndef BOOST_HANA_DETAIL_STRUCT_MACROS_HPP
#define BOOST_HANA_DETAIL_STRUCT_MACROS_HPP

#include <boost/hana/config.hpp>
#include <boost/hana/detail/preprocessor.hpp>
#include <boost/hana/pair.hpp>
#include <boost/hana/string.hpp>
#include <boost/hana/tuple.hpp>

#include <cstddef>
#include <utility>


namespace boost { namespace hana { namespace struct_detail {
    template <typename Memptr, Memptr ptr>
    struct member_ptr {
        template <typename T>
        constexpr decltype(auto) operator()(T&& t) const
        { return static_cast<T&&>(t).*ptr; }
    };

    constexpr std::size_t strlen(char const* s) {
        std::size_t n = 0;
        while (*s++ != '\0')
            ++n;
        return n;
    }

    template <std::size_t n, typename Names, std::size_t ...i>
    constexpr auto prepare_member_name_impl(std::index_sequence<i...>) {
        return hana::string_c<hana::at_c<n>(Names::get())[i]...>;
    }

    template <std::size_t n, typename Names>
    constexpr auto prepare_member_name() {
        constexpr std::size_t len = strlen(hana::at_c<n>(Names::get()));
        return prepare_member_name_impl<n, Names>(std::make_index_sequence<len>{});
    }
} }} // end namespace boost::hana

//////////////////////////////////////////////////////////////////////////////
// BOOST_HANA_PP_NARG
//////////////////////////////////////////////////////////////////////////////
//! @ingroup group-details
//! Macro expanding to the number of arguments it is passed.
//!
//! Specifically, `BOOST_HANA_PP_NARG(x1, ..., xn)` expands to `n`. It is
//! an error to call this macro with 0 arguments.

#ifdef BOOST_HANA_WORKAROUND_MSVC_PREPROCESSOR_616033
#   define BOOST_HANA_PP_NARG(...) \
        BOOST_HANA_PP_CONCAT(BOOST_HANA_PP_NARG_IMPL(__VA_ARGS__, 200,199,198,197,196,195,194,193,192,191,190,189,188,187,186,185,184,183,182,181,180,179,178,177,176,175,174,173,172,171,170,169,168,167,166,165,164,163,162,161,160,159,158,157,156,155,154,153,152,151,150,149,148,147,146,145,144,143,142,141,140,139,138,137,136,135,134,133,132,131,130,129,128,127,126,125,124,123,122,121,120,119,118,117,116,115,114,113,112,111,110,109,108,107,106,105,104,103,102,101,100,99,98,97,96,95,94,93,92,91,90,89,88,87,86,85,84,83,82,81,80,79,78,77,76,75,74,73,72,71,70,69,68,67,66,65,64,63,62,61,60,59,58,57,56,55,54,53,52,51,50,49,48,47,46,45,44,43,42,41,40,39,38,37,36,35,34,33,32,31,30,29,28,27,26,25,24,23,22,21,20,19,18,17,16,15,14,13,12,11,10,9,8,7,6,5,4,3,2,1,),)
#else
#   define BOOST_HANA_PP_NARG(...) \
        BOOST_HANA_PP_NARG_IMPL(__VA_ARGS__, 200,199,198,197,196,195,194,193,192,191,190,189,188,187,186,185,184,183,182,181,180,179,178,177,176,175,174,173,172,171,170,169,168,167,166,165,164,163,162,161,160,159,158,157,156,155,154,153,152,151,150,149,148,147,146,145,144,143,142,141,140,139,138,137,136,135,134,133,132,131,130,129,128,127,126,125,124,123,122,121,120,119,118,117,116,115,114,113,112,111,110,109,108,107,106,105,104,103,102,101,100,99,98,97,96,95,94,93,92,91,90,89,88,87,86,85,84,83,82,81,80,79,78,77,76,75,74,73,72,71,70,69,68,67,66,65,64,63,62,61,60,59,58,57,56,55,54,53,52,51,50,49,48,47,46,45,44,43,42,41,40,39,38,37,36,35,34,33,32,31,30,29,28,27,26,25,24,23,22,21,20,19,18,17,16,15,14,13,12,11,10,9,8,7,6,5,4,3,2,1,)
#endif

#define BOOST_HANA_PP_NARG_IMPL(e1,e2,e3,e4,e5,e6,e7,e8,e9,e10,e11,e12,e13,e14,e15,e16,e17,e18,e19,e20,e21,e22,e23,e24,e25,e26,e27,e28,e29,e30,e31,e32,e33,e34,e35,e36,e37,e38,e39,e40,e41,e42,e43,e44,e45,e46,e47,e48,e49,e50,e51,e52,e53,e54,e55,e56,e57,e58,e59,e60,e61,e62,e63,e64,e65,e66,e67,e68,e69,e70,e71,e72,e73,e74,e75,e76,e77,e78,e79,e80,e81,e82,e83,e84,e85,e86,e87,e88,e89,e90,e91,e92,e93,e94,e95,e96,e97,e98,e99,e100,e101,e102,e103,e104,e105,e106,e107,e108,e109,e110,e111,e112,e113,e114,e115,e116,e117,e118,e119,e120,e121,e122,e123,e124,e125,e126,e127,e128,e129,e130,e131,e132,e133,e134,e135,e136,e137,e138,e139,e140,e141,e142,e143,e144,e145,e146,e147,e148,e149,e150,e151,e152,e153,e154,e155,e156,e157,e158,e159,e160,e161,e162,e163,e164,e165,e166,e167,e168,e169,e170,e171,e172,e173,e174,e175,e176,e177,e178,e179,e180,e181,e182,e183,e184,e185,e186,e187,e188,e189,e190,e191,e192,e193,e194,e195,e196,e197,e198,e199,e200, N, ...) N

//////////////////////////////////////////////////////////////////////////////
// BOOST_HANA_PP_BACK
//////////////////////////////////////////////////////////////////////////////
//! @ingroup group-details
//! Expands to its last argument.
#define BOOST_HANA_PP_BACK(...) \
    BOOST_HANA_PP_BACK_IMPL(BOOST_HANA_PP_NARG(__VA_ARGS__), __VA_ARGS__)

#ifdef BOOST_HANA_WORKAROUND_MSVC_PREPROCESSOR_616033
#   define BOOST_HANA_PP_BACK_IMPL(N, ...) BOOST_HANA_PP_BACK_IMPL_I(N, __VA_ARGS__)
#   define BOOST_HANA_PP_BACK_IMPL_I(N, ...) \
        BOOST_HANA_PP_CONCAT(BOOST_HANA_PP_CONCAT(BOOST_HANA_PP_BACK_IMPL_, N)(__VA_ARGS__),)
#else
#   define BOOST_HANA_PP_BACK_IMPL(N, ...) \
        BOOST_HANA_PP_CONCAT(BOOST_HANA_PP_BACK_IMPL_, N)(__VA_ARGS__)
#endif


#define BOOST_HANA_PP_BACK_IMPL_1(e1) e1

#define BOOST_HANA_PP_BACK_IMPL_2(e1, e2) e2

#define BOOST_HANA_PP_BACK_IMPL_3(e1, e2, e3) e3

#define BOOST_HANA_PP_BACK_IMPL_4(e1, e2, e3, e4) e4

#define BOOST_HANA_PP_BACK_IMPL_5(e1, e2, e3, e4, e5) e5

#define BOOST_HANA_PP_BACK_IMPL_6(e1, e2, e3, e4, e5, e6) e6

#define BOOST_HANA_PP_BACK_IMPL_7(e1, e2, e3, e4, e5, e6, e7) e7

#define BOOST_HANA_PP_BACK_IMPL_8(e1, e2, e3, e4, e5, e6, e7, e8) e8

#define BOOST_HANA_PP_BACK_IMPL_9(e1, e2, e3, e4, e5, e6, e7, e8, e9) e9

#define BOOST_HANA_PP_BACK_IMPL_10(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10) e10

#define BOOST_HANA_PP_BACK_IMPL_11(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11) e11

#define BOOST_HANA_PP_BACK_IMPL_12(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12) e12

#define BOOST_HANA_PP_BACK_IMPL_13(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13) e13

#define BOOST_HANA_PP_BACK_IMPL_14(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14) e14

#define BOOST_HANA_PP_BACK_IMPL_15(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15) e15

#define BOOST_HANA_PP_BACK_IMPL_16(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16) e16

#define BOOST_HANA_PP_BACK_IMPL_17(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17) e17

#define BOOST_HANA_PP_BACK_IMPL_18(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18) e18

#define BOOST_HANA_PP_BACK_IMPL_19(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19) e19

#define BOOST_HANA_PP_BACK_IMPL_20(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20) e20

#define BOOST_HANA_PP_BACK_IMPL_21(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21) e21

#define BOOST_HANA_PP_BACK_IMPL_22(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22) e22

#define BOOST_HANA_PP_BACK_IMPL_23(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23) e23

#define BOOST_HANA_PP_BACK_IMPL_24(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24) e24

#define BOOST_HANA_PP_BACK_IMPL_25(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25) e25

#define BOOST_HANA_PP_BACK_IMPL_26(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26) e26

#define BOOST_HANA_PP_BACK_IMPL_27(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27) e27

#define BOOST_HANA_PP_BACK_IMPL_28(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28) e28

#define BOOST_HANA_PP_BACK_IMPL_29(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29) e29

#define BOOST_HANA_PP_BACK_IMPL_30(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30) e30

#define BOOST_HANA_PP_BACK_IMPL_31(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31) e31

#define BOOST_HANA_PP_BACK_IMPL_32(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32) e32

#define BOOST_HANA_PP_BACK_IMPL_33(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33) e33

#define BOOST_HANA_PP_BACK_IMPL_34(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34) e34

#define BOOST_HANA_PP_BACK_IMPL_35(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35) e35

#define BOOST_HANA_PP_BACK_IMPL_36(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36) e36

#define BOOST_HANA_PP_BACK_IMPL_37(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37) e37

#define BOOST_HANA_PP_BACK_IMPL_38(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38) e38

#define BOOST_HANA_PP_BACK_IMPL_39(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39) e39

#define BOOST_HANA_PP_BACK_IMPL_40(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40) e40

#define BOOST_HANA_PP_BACK_IMPL_41(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41) e41

#define BOOST_HANA_PP_BACK_IMPL_42(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42) e42

#define BOOST_HANA_PP_BACK_IMPL_43(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43) e43

#define BOOST_HANA_PP_BACK_IMPL_44(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44) e44

#define BOOST_HANA_PP_BACK_IMPL_45(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45) e45

#define BOOST_HANA_PP_BACK_IMPL_46(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46) e46

#define BOOST_HANA_PP_BACK_IMPL_47(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47) e47

#define BOOST_HANA_PP_BACK_IMPL_48(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48) e48

#define BOOST_HANA_PP_BACK_IMPL_49(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49) e49

#define BOOST_HANA_PP_BACK_IMPL_50(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50) e50

#define BOOST_HANA_PP_BACK_IMPL_51(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51) e51

#define BOOST_HANA_PP_BACK_IMPL_52(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52) e52

#define BOOST_HANA_PP_BACK_IMPL_53(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53) e53

#define BOOST_HANA_PP_BACK_IMPL_54(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54) e54

#define BOOST_HANA_PP_BACK_IMPL_55(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55) e55

#define BOOST_HANA_PP_BACK_IMPL_56(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56) e56

#define BOOST_HANA_PP_BACK_IMPL_57(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57) e57

#define BOOST_HANA_PP_BACK_IMPL_58(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58) e58

#define BOOST_HANA_PP_BACK_IMPL_59(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59) e59

#define BOOST_HANA_PP_BACK_IMPL_60(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60) e60

#define BOOST_HANA_PP_BACK_IMPL_61(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61) e61

#define BOOST_HANA_PP_BACK_IMPL_62(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62) e62

#define BOOST_HANA_PP_BACK_IMPL_63(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63) e63

#define BOOST_HANA_PP_BACK_IMPL_64(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64) e64

#define BOOST_HANA_PP_BACK_IMPL_65(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65) e65

#define BOOST_HANA_PP_BACK_IMPL_66(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66) e66

#define BOOST_HANA_PP_BACK_IMPL_67(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67) e67

#define BOOST_HANA_PP_BACK_IMPL_68(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68) e68

#define BOOST_HANA_PP_BACK_IMPL_69(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69) e69

#define BOOST_HANA_PP_BACK_IMPL_70(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70) e70

#define BOOST_HANA_PP_BACK_IMPL_71(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71) e71

#define BOOST_HANA_PP_BACK_IMPL_72(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72) e72

#define BOOST_HANA_PP_BACK_IMPL_73(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73) e73

#define BOOST_HANA_PP_BACK_IMPL_74(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74) e74

#define BOOST_HANA_PP_BACK_IMPL_75(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75) e75

#define BOOST_HANA_PP_BACK_IMPL_76(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76) e76

#define BOOST_HANA_PP_BACK_IMPL_77(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77) e77

#define BOOST_HANA_PP_BACK_IMPL_78(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78) e78

#define BOOST_HANA_PP_BACK_IMPL_79(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79) e79

#define BOOST_HANA_PP_BACK_IMPL_80(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80) e80

#define BOOST_HANA_PP_BACK_IMPL_81(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81) e81

#define BOOST_HANA_PP_BACK_IMPL_82(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82) e82

#define BOOST_HANA_PP_BACK_IMPL_83(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83) e83

#define BOOST_HANA_PP_BACK_IMPL_84(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84) e84

#define BOOST_HANA_PP_BACK_IMPL_85(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85) e85

#define BOOST_HANA_PP_BACK_IMPL_86(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86) e86

#define BOOST_HANA_PP_BACK_IMPL_87(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87) e87

#define BOOST_HANA_PP_BACK_IMPL_88(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88) e88

#define BOOST_HANA_PP_BACK_IMPL_89(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89) e89

#define BOOST_HANA_PP_BACK_IMPL_90(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90) e90

#define BOOST_HANA_PP_BACK_IMPL_91(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91) e91

#define BOOST_HANA_PP_BACK_IMPL_92(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92) e92

#define BOOST_HANA_PP_BACK_IMPL_93(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93) e93

#define BOOST_HANA_PP_BACK_IMPL_94(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94) e94

#define BOOST_HANA_PP_BACK_IMPL_95(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95) e95

#define BOOST_HANA_PP_BACK_IMPL_96(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96) e96

#define BOOST_HANA_PP_BACK_IMPL_97(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97) e97

#define BOOST_HANA_PP_BACK_IMPL_98(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98) e98

#define BOOST_HANA_PP_BACK_IMPL_99(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99) e99

#define BOOST_HANA_PP_BACK_IMPL_100(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100) e100

#define BOOST_HANA_PP_BACK_IMPL_101(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101) e101

#define BOOST_HANA_PP_BACK_IMPL_102(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102) e102

#define BOOST_HANA_PP_BACK_IMPL_103(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103) e103

#define BOOST_HANA_PP_BACK_IMPL_104(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104) e104

#define BOOST_HANA_PP_BACK_IMPL_105(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105) e105

#define BOOST_HANA_PP_BACK_IMPL_106(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106) e106

#define BOOST_HANA_PP_BACK_IMPL_107(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107) e107

#define BOOST_HANA_PP_BACK_IMPL_108(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108) e108

#define BOOST_HANA_PP_BACK_IMPL_109(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109) e109

#define BOOST_HANA_PP_BACK_IMPL_110(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110) e110

#define BOOST_HANA_PP_BACK_IMPL_111(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111) e111

#define BOOST_HANA_PP_BACK_IMPL_112(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112) e112

#define BOOST_HANA_PP_BACK_IMPL_113(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113) e113

#define BOOST_HANA_PP_BACK_IMPL_114(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114) e114

#define BOOST_HANA_PP_BACK_IMPL_115(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115) e115

#define BOOST_HANA_PP_BACK_IMPL_116(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116) e116

#define BOOST_HANA_PP_BACK_IMPL_117(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117) e117

#define BOOST_HANA_PP_BACK_IMPL_118(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118) e118

#define BOOST_HANA_PP_BACK_IMPL_119(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119) e119

#define BOOST_HANA_PP_BACK_IMPL_120(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120) e120

#define BOOST_HANA_PP_BACK_IMPL_121(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121) e121

#define BOOST_HANA_PP_BACK_IMPL_122(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122) e122

#define BOOST_HANA_PP_BACK_IMPL_123(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123) e123

#define BOOST_HANA_PP_BACK_IMPL_124(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124) e124

#define BOOST_HANA_PP_BACK_IMPL_125(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125) e125

#define BOOST_HANA_PP_BACK_IMPL_126(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126) e126

#define BOOST_HANA_PP_BACK_IMPL_127(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127) e127

#define BOOST_HANA_PP_BACK_IMPL_128(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128) e128

#define BOOST_HANA_PP_BACK_IMPL_129(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129) e129

#define BOOST_HANA_PP_BACK_IMPL_130(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130) e130

#define BOOST_HANA_PP_BACK_IMPL_131(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131) e131

#define BOOST_HANA_PP_BACK_IMPL_132(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132) e132

#define BOOST_HANA_PP_BACK_IMPL_133(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133) e133

#define BOOST_HANA_PP_BACK_IMPL_134(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134) e134

#define BOOST_HANA_PP_BACK_IMPL_135(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135) e135

#define BOOST_HANA_PP_BACK_IMPL_136(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136) e136

#define BOOST_HANA_PP_BACK_IMPL_137(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137) e137

#define BOOST_HANA_PP_BACK_IMPL_138(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138) e138

#define BOOST_HANA_PP_BACK_IMPL_139(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139) e139

#define BOOST_HANA_PP_BACK_IMPL_140(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140) e140

#define BOOST_HANA_PP_BACK_IMPL_141(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141) e141

#define BOOST_HANA_PP_BACK_IMPL_142(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142) e142

#define BOOST_HANA_PP_BACK_IMPL_143(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143) e143

#define BOOST_HANA_PP_BACK_IMPL_144(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144) e144

#define BOOST_HANA_PP_BACK_IMPL_145(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145) e145

#define BOOST_HANA_PP_BACK_IMPL_146(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146) e146

#define BOOST_HANA_PP_BACK_IMPL_147(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147) e147

#define BOOST_HANA_PP_BACK_IMPL_148(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148) e148

#define BOOST_HANA_PP_BACK_IMPL_149(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149) e149

#define BOOST_HANA_PP_BACK_IMPL_150(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150) e150

#define BOOST_HANA_PP_BACK_IMPL_151(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151) e151

#define BOOST_HANA_PP_BACK_IMPL_152(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152) e152

#define BOOST_HANA_PP_BACK_IMPL_153(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153) e153

#define BOOST_HANA_PP_BACK_IMPL_154(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154) e154

#define BOOST_HANA_PP_BACK_IMPL_155(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155) e155

#define BOOST_HANA_PP_BACK_IMPL_156(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156) e156

#define BOOST_HANA_PP_BACK_IMPL_157(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157) e157

#define BOOST_HANA_PP_BACK_IMPL_158(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158) e158

#define BOOST_HANA_PP_BACK_IMPL_159(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159) e159

#define BOOST_HANA_PP_BACK_IMPL_160(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159, e160) e160

#define BOOST_HANA_PP_BACK_IMPL_161(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159, e160, e161) e161

#define BOOST_HANA_PP_BACK_IMPL_162(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159, e160, e161, e162) e162

#define BOOST_HANA_PP_BACK_IMPL_163(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159, e160, e161, e162, e163) e163

#define BOOST_HANA_PP_BACK_IMPL_164(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159, e160, e161, e162, e163, e164) e164

#define BOOST_HANA_PP_BACK_IMPL_165(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159, e160, e161, e162, e163, e164, e165) e165

#define BOOST_HANA_PP_BACK_IMPL_166(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159, e160, e161, e162, e163, e164, e165, e166) e166

#define BOOST_HANA_PP_BACK_IMPL_167(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159, e160, e161, e162, e163, e164, e165, e166, e167) e167

#define BOOST_HANA_PP_BACK_IMPL_168(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159, e160, e161, e162, e163, e164, e165, e166, e167, e168) e168

#define BOOST_HANA_PP_BACK_IMPL_169(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159, e160, e161, e162, e163, e164, e165, e166, e167, e168, e169) e169

#define BOOST_HANA_PP_BACK_IMPL_170(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159, e160, e161, e162, e163, e164, e165, e166, e167, e168, e169, e170) e170

#define BOOST_HANA_PP_BACK_IMPL_171(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159, e160, e161, e162, e163, e164, e165, e166, e167, e168, e169, e170, e171) e171

#define BOOST_HANA_PP_BACK_IMPL_172(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159, e160, e161, e162, e163, e164, e165, e166, e167, e168, e169, e170, e171, e172) e172

#define BOOST_HANA_PP_BACK_IMPL_173(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159, e160, e161, e162, e163, e164, e165, e166, e167, e168, e169, e170, e171, e172, e173) e173

#define BOOST_HANA_PP_BACK_IMPL_174(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159, e160, e161, e162, e163, e164, e165, e166, e167, e168, e169, e170, e171, e172, e173, e174) e174

#define BOOST_HANA_PP_BACK_IMPL_175(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159, e160, e161, e162, e163, e164, e165, e166, e167, e168, e169, e170, e171, e172, e173, e174, e175) e175

#define BOOST_HANA_PP_BACK_IMPL_176(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159, e160, e161, e162, e163, e164, e165, e166, e167, e168, e169, e170, e171, e172, e173, e174, e175, e176) e176

#define BOOST_HANA_PP_BACK_IMPL_177(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159, e160, e161, e162, e163, e164, e165, e166, e167, e168, e169, e170, e171, e172, e173, e174, e175, e176, e177) e177

#define BOOST_HANA_PP_BACK_IMPL_178(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159, e160, e161, e162, e163, e164, e165, e166, e167, e168, e169, e170, e171, e172, e173, e174, e175, e176, e177, e178) e178

#define BOOST_HANA_PP_BACK_IMPL_179(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159, e160, e161, e162, e163, e164, e165, e166, e167, e168, e169, e170, e171, e172, e173, e174, e175, e176, e177, e178, e179) e179

#define BOOST_HANA_PP_BACK_IMPL_180(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159, e160, e161, e162, e163, e164, e165, e166, e167, e168, e169, e170, e171, e172, e173, e174, e175, e176, e177, e178, e179, e180) e180

#define BOOST_HANA_PP_BACK_IMPL_181(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159, e160, e161, e162, e163, e164, e165, e166, e167, e168, e169, e170, e171, e172, e173, e174, e175, e176, e177, e178, e179, e180, e181) e181

#define BOOST_HANA_PP_BACK_IMPL_182(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159, e160, e161, e162, e163, e164, e165, e166, e167, e168, e169, e170, e171, e172, e173, e174, e175, e176, e177, e178, e179, e180, e181, e182) e182

#define BOOST_HANA_PP_BACK_IMPL_183(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159, e160, e161, e162, e163, e164, e165, e166, e167, e168, e169, e170, e171, e172, e173, e174, e175, e176, e177, e178, e179, e180, e181, e182, e183) e183

#define BOOST_HANA_PP_BACK_IMPL_184(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159, e160, e161, e162, e163, e164, e165, e166, e167, e168, e169, e170, e171, e172, e173, e174, e175, e176, e177, e178, e179, e180, e181, e182, e183, e184) e184

#define BOOST_HANA_PP_BACK_IMPL_185(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159, e160, e161, e162, e163, e164, e165, e166, e167, e168, e169, e170, e171, e172, e173, e174, e175, e176, e177, e178, e179, e180, e181, e182, e183, e184, e185) e185

#define BOOST_HANA_PP_BACK_IMPL_186(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159, e160, e161, e162, e163, e164, e165, e166, e167, e168, e169, e170, e171, e172, e173, e174, e175, e176, e177, e178, e179, e180, e181, e182, e183, e184, e185, e186) e186

#define BOOST_HANA_PP_BACK_IMPL_187(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159, e160, e161, e162, e163, e164, e165, e166, e167, e168, e169, e170, e171, e172, e173, e174, e175, e176, e177, e178, e179, e180, e181, e182, e183, e184, e185, e186, e187) e187

#define BOOST_HANA_PP_BACK_IMPL_188(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159, e160, e161, e162, e163, e164, e165, e166, e167, e168, e169, e170, e171, e172, e173, e174, e175, e176, e177, e178, e179, e180, e181, e182, e183, e184, e185, e186, e187, e188) e188

#define BOOST_HANA_PP_BACK_IMPL_189(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159, e160, e161, e162, e163, e164, e165, e166, e167, e168, e169, e170, e171, e172, e173, e174, e175, e176, e177, e178, e179, e180, e181, e182, e183, e184, e185, e186, e187, e188, e189) e189

#define BOOST_HANA_PP_BACK_IMPL_190(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159, e160, e161, e162, e163, e164, e165, e166, e167, e168, e169, e170, e171, e172, e173, e174, e175, e176, e177, e178, e179, e180, e181, e182, e183, e184, e185, e186, e187, e188, e189, e190) e190

#define BOOST_HANA_PP_BACK_IMPL_191(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159, e160, e161, e162, e163, e164, e165, e166, e167, e168, e169, e170, e171, e172, e173, e174, e175, e176, e177, e178, e179, e180, e181, e182, e183, e184, e185, e186, e187, e188, e189, e190, e191) e191

#define BOOST_HANA_PP_BACK_IMPL_192(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159, e160, e161, e162, e163, e164, e165, e166, e167, e168, e169, e170, e171, e172, e173, e174, e175, e176, e177, e178, e179, e180, e181, e182, e183, e184, e185, e186, e187, e188, e189, e190, e191, e192) e192

#define BOOST_HANA_PP_BACK_IMPL_193(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159, e160, e161, e162, e163, e164, e165, e166, e167, e168, e169, e170, e171, e172, e173, e174, e175, e176, e177, e178, e179, e180, e181, e182, e183, e184, e185, e186, e187, e188, e189, e190, e191, e192, e193) e193

#define BOOST_HANA_PP_BACK_IMPL_194(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159, e160, e161, e162, e163, e164, e165, e166, e167, e168, e169, e170, e171, e172, e173, e174, e175, e176, e177, e178, e179, e180, e181, e182, e183, e184, e185, e186, e187, e188, e189, e190, e191, e192, e193, e194) e194

#define BOOST_HANA_PP_BACK_IMPL_195(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159, e160, e161, e162, e163, e164, e165, e166, e167, e168, e169, e170, e171, e172, e173, e174, e175, e176, e177, e178, e179, e180, e181, e182, e183, e184, e185, e186, e187, e188, e189, e190, e191, e192, e193, e194, e195) e195

#define BOOST_HANA_PP_BACK_IMPL_196(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159, e160, e161, e162, e163, e164, e165, e166, e167, e168, e169, e170, e171, e172, e173, e174, e175, e176, e177, e178, e179, e180, e181, e182, e183, e184, e185, e186, e187, e188, e189, e190, e191, e192, e193, e194, e195, e196) e196

#define BOOST_HANA_PP_BACK_IMPL_197(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159, e160, e161, e162, e163, e164, e165, e166, e167, e168, e169, e170, e171, e172, e173, e174, e175, e176, e177, e178, e179, e180, e181, e182, e183, e184, e185, e186, e187, e188, e189, e190, e191, e192, e193, e194, e195, e196, e197) e197

#define BOOST_HANA_PP_BACK_IMPL_198(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159, e160, e161, e162, e163, e164, e165, e166, e167, e168, e169, e170, e171, e172, e173, e174, e175, e176, e177, e178, e179, e180, e181, e182, e183, e184, e185, e186, e187, e188, e189, e190, e191, e192, e193, e194, e195, e196, e197, e198) e198

#define BOOST_HANA_PP_BACK_IMPL_199(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159, e160, e161, e162, e163, e164, e165, e166, e167, e168, e169, e170, e171, e172, e173, e174, e175, e176, e177, e178, e179, e180, e181, e182, e183, e184, e185, e186, e187, e188, e189, e190, e191, e192, e193, e194, e195, e196, e197, e198, e199) e199

#define BOOST_HANA_PP_BACK_IMPL_200(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159, e160, e161, e162, e163, e164, e165, e166, e167, e168, e169, e170, e171, e172, e173, e174, e175, e176, e177, e178, e179, e180, e181, e182, e183, e184, e185, e186, e187, e188, e189, e190, e191, e192, e193, e194, e195, e196, e197, e198, e199, e200) e200


//////////////////////////////////////////////////////////////////////////////
// BOOST_HANA_PP_DROP_BACK
//////////////////////////////////////////////////////////////////////////////
//! @ingroup group-details
//! Expands to all of its arguments, except for the last one.
#define BOOST_HANA_PP_DROP_BACK(...) \
    BOOST_HANA_PP_DROP_BACK_IMPL(BOOST_HANA_PP_NARG(__VA_ARGS__), __VA_ARGS__)

#ifdef BOOST_HANA_WORKAROUND_MSVC_PREPROCESSOR_616033
#   define BOOST_HANA_PP_DROP_BACK_IMPL(N, ...) BOOST_HANA_PP_DROP_BACK_IMPL_I(N, __VA_ARGS__)
#   define BOOST_HANA_PP_DROP_BACK_IMPL_I(N, ...) \
        BOOST_HANA_PP_CONCAT(BOOST_HANA_PP_CONCAT(BOOST_HANA_PP_DROP_BACK_IMPL_, N)(__VA_ARGS__),)
#else
#   define BOOST_HANA_PP_DROP_BACK_IMPL(N, ...) \
        BOOST_HANA_PP_CONCAT(BOOST_HANA_PP_DROP_BACK_IMPL_, N)(__VA_ARGS__)
#endif


#define BOOST_HANA_PP_DROP_BACK_IMPL_1(e1)

#define BOOST_HANA_PP_DROP_BACK_IMPL_2(e1, e2)e1

#define BOOST_HANA_PP_DROP_BACK_IMPL_3(e1, e2, e3)e1, e2

#define BOOST_HANA_PP_DROP_BACK_IMPL_4(e1, e2, e3, e4)e1, e2, e3

#define BOOST_HANA_PP_DROP_BACK_IMPL_5(e1, e2, e3, e4, e5)e1, e2, e3, e4

#define BOOST_HANA_PP_DROP_BACK_IMPL_6(e1, e2, e3, e4, e5, e6)e1, e2, e3, e4, e5

#define BOOST_HANA_PP_DROP_BACK_IMPL_7(e1, e2, e3, e4, e5, e6, e7)e1, e2, e3, e4, e5, e6

#define BOOST_HANA_PP_DROP_BACK_IMPL_8(e1, e2, e3, e4, e5, e6, e7, e8)e1, e2, e3, e4, e5, e6, e7

#define BOOST_HANA_PP_DROP_BACK_IMPL_9(e1, e2, e3, e4, e5, e6, e7, e8, e9)e1, e2, e3, e4, e5, e6, e7, e8

#define BOOST_HANA_PP_DROP_BACK_IMPL_10(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10)e1, e2, e3, e4, e5, e6, e7, e8, e9

#define BOOST_HANA_PP_DROP_BACK_IMPL_11(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10

#define BOOST_HANA_PP_DROP_BACK_IMPL_12(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11

#define BOOST_HANA_PP_DROP_BACK_IMPL_13(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12

#define BOOST_HANA_PP_DROP_BACK_IMPL_14(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13

#define BOOST_HANA_PP_DROP_BACK_IMPL_15(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14

#define BOOST_HANA_PP_DROP_BACK_IMPL_16(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15

#define BOOST_HANA_PP_DROP_BACK_IMPL_17(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16

#define BOOST_HANA_PP_DROP_BACK_IMPL_18(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17

#define BOOST_HANA_PP_DROP_BACK_IMPL_19(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18

#define BOOST_HANA_PP_DROP_BACK_IMPL_20(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19

#define BOOST_HANA_PP_DROP_BACK_IMPL_21(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20

#define BOOST_HANA_PP_DROP_BACK_IMPL_22(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21

#define BOOST_HANA_PP_DROP_BACK_IMPL_23(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22

#define BOOST_HANA_PP_DROP_BACK_IMPL_24(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23

#define BOOST_HANA_PP_DROP_BACK_IMPL_25(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24

#define BOOST_HANA_PP_DROP_BACK_IMPL_26(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25

#define BOOST_HANA_PP_DROP_BACK_IMPL_27(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26

#define BOOST_HANA_PP_DROP_BACK_IMPL_28(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27

#define BOOST_HANA_PP_DROP_BACK_IMPL_29(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28

#define BOOST_HANA_PP_DROP_BACK_IMPL_30(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29

#define BOOST_HANA_PP_DROP_BACK_IMPL_31(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30

#define BOOST_HANA_PP_DROP_BACK_IMPL_32(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31

#define BOOST_HANA_PP_DROP_BACK_IMPL_33(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32

#define BOOST_HANA_PP_DROP_BACK_IMPL_34(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33

#define BOOST_HANA_PP_DROP_BACK_IMPL_35(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34

#define BOOST_HANA_PP_DROP_BACK_IMPL_36(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35

#define BOOST_HANA_PP_DROP_BACK_IMPL_37(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36

#define BOOST_HANA_PP_DROP_BACK_IMPL_38(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37

#define BOOST_HANA_PP_DROP_BACK_IMPL_39(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38

#define BOOST_HANA_PP_DROP_BACK_IMPL_40(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39

#define BOOST_HANA_PP_DROP_BACK_IMPL_41(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40

#define BOOST_HANA_PP_DROP_BACK_IMPL_42(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41

#define BOOST_HANA_PP_DROP_BACK_IMPL_43(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42

#define BOOST_HANA_PP_DROP_BACK_IMPL_44(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43

#define BOOST_HANA_PP_DROP_BACK_IMPL_45(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44

#define BOOST_HANA_PP_DROP_BACK_IMPL_46(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45

#define BOOST_HANA_PP_DROP_BACK_IMPL_47(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46

#define BOOST_HANA_PP_DROP_BACK_IMPL_48(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47

#define BOOST_HANA_PP_DROP_BACK_IMPL_49(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48

#define BOOST_HANA_PP_DROP_BACK_IMPL_50(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49

#define BOOST_HANA_PP_DROP_BACK_IMPL_51(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50

#define BOOST_HANA_PP_DROP_BACK_IMPL_52(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51

#define BOOST_HANA_PP_DROP_BACK_IMPL_53(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52

#define BOOST_HANA_PP_DROP_BACK_IMPL_54(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53

#define BOOST_HANA_PP_DROP_BACK_IMPL_55(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54

#define BOOST_HANA_PP_DROP_BACK_IMPL_56(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55

#define BOOST_HANA_PP_DROP_BACK_IMPL_57(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56

#define BOOST_HANA_PP_DROP_BACK_IMPL_58(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57

#define BOOST_HANA_PP_DROP_BACK_IMPL_59(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58

#define BOOST_HANA_PP_DROP_BACK_IMPL_60(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59

#define BOOST_HANA_PP_DROP_BACK_IMPL_61(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60

#define BOOST_HANA_PP_DROP_BACK_IMPL_62(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61

#define BOOST_HANA_PP_DROP_BACK_IMPL_63(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62

#define BOOST_HANA_PP_DROP_BACK_IMPL_64(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63

#define BOOST_HANA_PP_DROP_BACK_IMPL_65(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64

#define BOOST_HANA_PP_DROP_BACK_IMPL_66(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65

#define BOOST_HANA_PP_DROP_BACK_IMPL_67(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66

#define BOOST_HANA_PP_DROP_BACK_IMPL_68(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67

#define BOOST_HANA_PP_DROP_BACK_IMPL_69(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68

#define BOOST_HANA_PP_DROP_BACK_IMPL_70(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69

#define BOOST_HANA_PP_DROP_BACK_IMPL_71(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70

#define BOOST_HANA_PP_DROP_BACK_IMPL_72(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71

#define BOOST_HANA_PP_DROP_BACK_IMPL_73(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72

#define BOOST_HANA_PP_DROP_BACK_IMPL_74(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73

#define BOOST_HANA_PP_DROP_BACK_IMPL_75(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74

#define BOOST_HANA_PP_DROP_BACK_IMPL_76(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75

#define BOOST_HANA_PP_DROP_BACK_IMPL_77(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76

#define BOOST_HANA_PP_DROP_BACK_IMPL_78(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77

#define BOOST_HANA_PP_DROP_BACK_IMPL_79(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78

#define BOOST_HANA_PP_DROP_BACK_IMPL_80(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79

#define BOOST_HANA_PP_DROP_BACK_IMPL_81(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80

#define BOOST_HANA_PP_DROP_BACK_IMPL_82(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81

#define BOOST_HANA_PP_DROP_BACK_IMPL_83(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82

#define BOOST_HANA_PP_DROP_BACK_IMPL_84(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83

#define BOOST_HANA_PP_DROP_BACK_IMPL_85(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84

#define BOOST_HANA_PP_DROP_BACK_IMPL_86(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85

#define BOOST_HANA_PP_DROP_BACK_IMPL_87(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86

#define BOOST_HANA_PP_DROP_BACK_IMPL_88(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87

#define BOOST_HANA_PP_DROP_BACK_IMPL_89(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88

#define BOOST_HANA_PP_DROP_BACK_IMPL_90(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89

#define BOOST_HANA_PP_DROP_BACK_IMPL_91(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90

#define BOOST_HANA_PP_DROP_BACK_IMPL_92(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91

#define BOOST_HANA_PP_DROP_BACK_IMPL_93(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92

#define BOOST_HANA_PP_DROP_BACK_IMPL_94(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93

#define BOOST_HANA_PP_DROP_BACK_IMPL_95(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94

#define BOOST_HANA_PP_DROP_BACK_IMPL_96(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95

#define BOOST_HANA_PP_DROP_BACK_IMPL_97(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96

#define BOOST_HANA_PP_DROP_BACK_IMPL_98(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97

#define BOOST_HANA_PP_DROP_BACK_IMPL_99(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98

#define BOOST_HANA_PP_DROP_BACK_IMPL_100(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99

#define BOOST_HANA_PP_DROP_BACK_IMPL_101(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100

#define BOOST_HANA_PP_DROP_BACK_IMPL_102(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101

#define BOOST_HANA_PP_DROP_BACK_IMPL_103(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102

#define BOOST_HANA_PP_DROP_BACK_IMPL_104(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103

#define BOOST_HANA_PP_DROP_BACK_IMPL_105(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104

#define BOOST_HANA_PP_DROP_BACK_IMPL_106(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105

#define BOOST_HANA_PP_DROP_BACK_IMPL_107(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106

#define BOOST_HANA_PP_DROP_BACK_IMPL_108(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107

#define BOOST_HANA_PP_DROP_BACK_IMPL_109(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108

#define BOOST_HANA_PP_DROP_BACK_IMPL_110(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109

#define BOOST_HANA_PP_DROP_BACK_IMPL_111(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110

#define BOOST_HANA_PP_DROP_BACK_IMPL_112(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111

#define BOOST_HANA_PP_DROP_BACK_IMPL_113(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112

#define BOOST_HANA_PP_DROP_BACK_IMPL_114(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113

#define BOOST_HANA_PP_DROP_BACK_IMPL_115(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114

#define BOOST_HANA_PP_DROP_BACK_IMPL_116(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115

#define BOOST_HANA_PP_DROP_BACK_IMPL_117(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116

#define BOOST_HANA_PP_DROP_BACK_IMPL_118(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117

#define BOOST_HANA_PP_DROP_BACK_IMPL_119(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118

#define BOOST_HANA_PP_DROP_BACK_IMPL_120(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119

#define BOOST_HANA_PP_DROP_BACK_IMPL_121(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120

#define BOOST_HANA_PP_DROP_BACK_IMPL_122(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121

#define BOOST_HANA_PP_DROP_BACK_IMPL_123(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122

#define BOOST_HANA_PP_DROP_BACK_IMPL_124(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123

#define BOOST_HANA_PP_DROP_BACK_IMPL_125(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124

#define BOOST_HANA_PP_DROP_BACK_IMPL_126(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125

#define BOOST_HANA_PP_DROP_BACK_IMPL_127(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126

#define BOOST_HANA_PP_DROP_BACK_IMPL_128(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127

#define BOOST_HANA_PP_DROP_BACK_IMPL_129(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128

#define BOOST_HANA_PP_DROP_BACK_IMPL_130(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129

#define BOOST_HANA_PP_DROP_BACK_IMPL_131(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130

#define BOOST_HANA_PP_DROP_BACK_IMPL_132(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131

#define BOOST_HANA_PP_DROP_BACK_IMPL_133(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132

#define BOOST_HANA_PP_DROP_BACK_IMPL_134(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133

#define BOOST_HANA_PP_DROP_BACK_IMPL_135(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134

#define BOOST_HANA_PP_DROP_BACK_IMPL_136(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135

#define BOOST_HANA_PP_DROP_BACK_IMPL_137(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136

#define BOOST_HANA_PP_DROP_BACK_IMPL_138(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137

#define BOOST_HANA_PP_DROP_BACK_IMPL_139(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138

#define BOOST_HANA_PP_DROP_BACK_IMPL_140(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139

#define BOOST_HANA_PP_DROP_BACK_IMPL_141(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140

#define BOOST_HANA_PP_DROP_BACK_IMPL_142(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141

#define BOOST_HANA_PP_DROP_BACK_IMPL_143(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142

#define BOOST_HANA_PP_DROP_BACK_IMPL_144(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143

#define BOOST_HANA_PP_DROP_BACK_IMPL_145(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144

#define BOOST_HANA_PP_DROP_BACK_IMPL_146(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145

#define BOOST_HANA_PP_DROP_BACK_IMPL_147(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146

#define BOOST_HANA_PP_DROP_BACK_IMPL_148(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147

#define BOOST_HANA_PP_DROP_BACK_IMPL_149(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148

#define BOOST_HANA_PP_DROP_BACK_IMPL_150(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149

#define BOOST_HANA_PP_DROP_BACK_IMPL_151(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150

#define BOOST_HANA_PP_DROP_BACK_IMPL_152(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151

#define BOOST_HANA_PP_DROP_BACK_IMPL_153(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152

#define BOOST_HANA_PP_DROP_BACK_IMPL_154(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153

#define BOOST_HANA_PP_DROP_BACK_IMPL_155(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154

#define BOOST_HANA_PP_DROP_BACK_IMPL_156(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155

#define BOOST_HANA_PP_DROP_BACK_IMPL_157(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156

#define BOOST_HANA_PP_DROP_BACK_IMPL_158(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157

#define BOOST_HANA_PP_DROP_BACK_IMPL_159(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158

#define BOOST_HANA_PP_DROP_BACK_IMPL_160(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159, e160)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159

#define BOOST_HANA_PP_DROP_BACK_IMPL_161(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159, e160, e161)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159, e160

#define BOOST_HANA_PP_DROP_BACK_IMPL_162(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159, e160, e161, e162)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159, e160, e161

#define BOOST_HANA_PP_DROP_BACK_IMPL_163(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159, e160, e161, e162, e163)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159, e160, e161, e162

#define BOOST_HANA_PP_DROP_BACK_IMPL_164(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159, e160, e161, e162, e163, e164)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159, e160, e161, e162, e163

#define BOOST_HANA_PP_DROP_BACK_IMPL_165(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159, e160, e161, e162, e163, e164, e165)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159, e160, e161, e162, e163, e164

#define BOOST_HANA_PP_DROP_BACK_IMPL_166(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159, e160, e161, e162, e163, e164, e165, e166)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159, e160, e161, e162, e163, e164, e165

#define BOOST_HANA_PP_DROP_BACK_IMPL_167(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159, e160, e161, e162, e163, e164, e165, e166, e167)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159, e160, e161, e162, e163, e164, e165, e166

#define BOOST_HANA_PP_DROP_BACK_IMPL_168(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159, e160, e161, e162, e163, e164, e165, e166, e167, e168)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159, e160, e161, e162, e163, e164, e165, e166, e167

#define BOOST_HANA_PP_DROP_BACK_IMPL_169(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159, e160, e161, e162, e163, e164, e165, e166, e167, e168, e169)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159, e160, e161, e162, e163, e164, e165, e166, e167, e168

#define BOOST_HANA_PP_DROP_BACK_IMPL_170(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159, e160, e161, e162, e163, e164, e165, e166, e167, e168, e169, e170)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159, e160, e161, e162, e163, e164, e165, e166, e167, e168, e169

#define BOOST_HANA_PP_DROP_BACK_IMPL_171(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159, e160, e161, e162, e163, e164, e165, e166, e167, e168, e169, e170, e171)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159, e160, e161, e162, e163, e164, e165, e166, e167, e168, e169, e170

#define BOOST_HANA_PP_DROP_BACK_IMPL_172(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159, e160, e161, e162, e163, e164, e165, e166, e167, e168, e169, e170, e171, e172)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159, e160, e161, e162, e163, e164, e165, e166, e167, e168, e169, e170, e171

#define BOOST_HANA_PP_DROP_BACK_IMPL_173(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159, e160, e161, e162, e163, e164, e165, e166, e167, e168, e169, e170, e171, e172, e173)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159, e160, e161, e162, e163, e164, e165, e166, e167, e168, e169, e170, e171, e172

#define BOOST_HANA_PP_DROP_BACK_IMPL_174(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159, e160, e161, e162, e163, e164, e165, e166, e167, e168, e169, e170, e171, e172, e173, e174)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159, e160, e161, e162, e163, e164, e165, e166, e167, e168, e169, e170, e171, e172, e173

#define BOOST_HANA_PP_DROP_BACK_IMPL_175(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159, e160, e161, e162, e163, e164, e165, e166, e167, e168, e169, e170, e171, e172, e173, e174, e175)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159, e160, e161, e162, e163, e164, e165, e166, e167, e168, e169, e170, e171, e172, e173, e174

#define BOOST_HANA_PP_DROP_BACK_IMPL_176(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159, e160, e161, e162, e163, e164, e165, e166, e167, e168, e169, e170, e171, e172, e173, e174, e175, e176)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159, e160, e161, e162, e163, e164, e165, e166, e167, e168, e169, e170, e171, e172, e173, e174, e175

#define BOOST_HANA_PP_DROP_BACK_IMPL_177(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159, e160, e161, e162, e163, e164, e165, e166, e167, e168, e169, e170, e171, e172, e173, e174, e175, e176, e177)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159, e160, e161, e162, e163, e164, e165, e166, e167, e168, e169, e170, e171, e172, e173, e174, e175, e176

#define BOOST_HANA_PP_DROP_BACK_IMPL_178(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159, e160, e161, e162, e163, e164, e165, e166, e167, e168, e169, e170, e171, e172, e173, e174, e175, e176, e177, e178)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159, e160, e161, e162, e163, e164, e165, e166, e167, e168, e169, e170, e171, e172, e173, e174, e175, e176, e177

#define BOOST_HANA_PP_DROP_BACK_IMPL_179(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159, e160, e161, e162, e163, e164, e165, e166, e167, e168, e169, e170, e171, e172, e173, e174, e175, e176, e177, e178, e179)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159, e160, e161, e162, e163, e164, e165, e166, e167, e168, e169, e170, e171, e172, e173, e174, e175, e176, e177, e178

#define BOOST_HANA_PP_DROP_BACK_IMPL_180(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159, e160, e161, e162, e163, e164, e165, e166, e167, e168, e169, e170, e171, e172, e173, e174, e175, e176, e177, e178, e179, e180)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159, e160, e161, e162, e163, e164, e165, e166, e167, e168, e169, e170, e171, e172, e173, e174, e175, e176, e177, e178, e179

#define BOOST_HANA_PP_DROP_BACK_IMPL_181(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159, e160, e161, e162, e163, e164, e165, e166, e167, e168, e169, e170, e171, e172, e173, e174, e175, e176, e177, e178, e179, e180, e181)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159, e160, e161, e162, e163, e164, e165, e166, e167, e168, e169, e170, e171, e172, e173, e174, e175, e176, e177, e178, e179, e180

#define BOOST_HANA_PP_DROP_BACK_IMPL_182(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159, e160, e161, e162, e163, e164, e165, e166, e167, e168, e169, e170, e171, e172, e173, e174, e175, e176, e177, e178, e179, e180, e181, e182)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159, e160, e161, e162, e163, e164, e165, e166, e167, e168, e169, e170, e171, e172, e173, e174, e175, e176, e177, e178, e179, e180, e181

#define BOOST_HANA_PP_DROP_BACK_IMPL_183(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159, e160, e161, e162, e163, e164, e165, e166, e167, e168, e169, e170, e171, e172, e173, e174, e175, e176, e177, e178, e179, e180, e181, e182, e183)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159, e160, e161, e162, e163, e164, e165, e166, e167, e168, e169, e170, e171, e172, e173, e174, e175, e176, e177, e178, e179, e180, e181, e182

#define BOOST_HANA_PP_DROP_BACK_IMPL_184(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159, e160, e161, e162, e163, e164, e165, e166, e167, e168, e169, e170, e171, e172, e173, e174, e175, e176, e177, e178, e179, e180, e181, e182, e183, e184)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159, e160, e161, e162, e163, e164, e165, e166, e167, e168, e169, e170, e171, e172, e173, e174, e175, e176, e177, e178, e179, e180, e181, e182, e183

#define BOOST_HANA_PP_DROP_BACK_IMPL_185(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159, e160, e161, e162, e163, e164, e165, e166, e167, e168, e169, e170, e171, e172, e173, e174, e175, e176, e177, e178, e179, e180, e181, e182, e183, e184, e185)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159, e160, e161, e162, e163, e164, e165, e166, e167, e168, e169, e170, e171, e172, e173, e174, e175, e176, e177, e178, e179, e180, e181, e182, e183, e184

#define BOOST_HANA_PP_DROP_BACK_IMPL_186(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159, e160, e161, e162, e163, e164, e165, e166, e167, e168, e169, e170, e171, e172, e173, e174, e175, e176, e177, e178, e179, e180, e181, e182, e183, e184, e185, e186)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159, e160, e161, e162, e163, e164, e165, e166, e167, e168, e169, e170, e171, e172, e173, e174, e175, e176, e177, e178, e179, e180, e181, e182, e183, e184, e185

#define BOOST_HANA_PP_DROP_BACK_IMPL_187(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159, e160, e161, e162, e163, e164, e165, e166, e167, e168, e169, e170, e171, e172, e173, e174, e175, e176, e177, e178, e179, e180, e181, e182, e183, e184, e185, e186, e187)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159, e160, e161, e162, e163, e164, e165, e166, e167, e168, e169, e170, e171, e172, e173, e174, e175, e176, e177, e178, e179, e180, e181, e182, e183, e184, e185, e186

#define BOOST_HANA_PP_DROP_BACK_IMPL_188(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159, e160, e161, e162, e163, e164, e165, e166, e167, e168, e169, e170, e171, e172, e173, e174, e175, e176, e177, e178, e179, e180, e181, e182, e183, e184, e185, e186, e187, e188)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159, e160, e161, e162, e163, e164, e165, e166, e167, e168, e169, e170, e171, e172, e173, e174, e175, e176, e177, e178, e179, e180, e181, e182, e183, e184, e185, e186, e187

#define BOOST_HANA_PP_DROP_BACK_IMPL_189(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159, e160, e161, e162, e163, e164, e165, e166, e167, e168, e169, e170, e171, e172, e173, e174, e175, e176, e177, e178, e179, e180, e181, e182, e183, e184, e185, e186, e187, e188, e189)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159, e160, e161, e162, e163, e164, e165, e166, e167, e168, e169, e170, e171, e172, e173, e174, e175, e176, e177, e178, e179, e180, e181, e182, e183, e184, e185, e186, e187, e188

#define BOOST_HANA_PP_DROP_BACK_IMPL_190(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159, e160, e161, e162, e163, e164, e165, e166, e167, e168, e169, e170, e171, e172, e173, e174, e175, e176, e177, e178, e179, e180, e181, e182, e183, e184, e185, e186, e187, e188, e189, e190)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159, e160, e161, e162, e163, e164, e165, e166, e167, e168, e169, e170, e171, e172, e173, e174, e175, e176, e177, e178, e179, e180, e181, e182, e183, e184, e185, e186, e187, e188, e189

#define BOOST_HANA_PP_DROP_BACK_IMPL_191(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159, e160, e161, e162, e163, e164, e165, e166, e167, e168, e169, e170, e171, e172, e173, e174, e175, e176, e177, e178, e179, e180, e181, e182, e183, e184, e185, e186, e187, e188, e189, e190, e191)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159, e160, e161, e162, e163, e164, e165, e166, e167, e168, e169, e170, e171, e172, e173, e174, e175, e176, e177, e178, e179, e180, e181, e182, e183, e184, e185, e186, e187, e188, e189, e190

#define BOOST_HANA_PP_DROP_BACK_IMPL_192(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159, e160, e161, e162, e163, e164, e165, e166, e167, e168, e169, e170, e171, e172, e173, e174, e175, e176, e177, e178, e179, e180, e181, e182, e183, e184, e185, e186, e187, e188, e189, e190, e191, e192)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159, e160, e161, e162, e163, e164, e165, e166, e167, e168, e169, e170, e171, e172, e173, e174, e175, e176, e177, e178, e179, e180, e181, e182, e183, e184, e185, e186, e187, e188, e189, e190, e191

#define BOOST_HANA_PP_DROP_BACK_IMPL_193(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159, e160, e161, e162, e163, e164, e165, e166, e167, e168, e169, e170, e171, e172, e173, e174, e175, e176, e177, e178, e179, e180, e181, e182, e183, e184, e185, e186, e187, e188, e189, e190, e191, e192, e193)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159, e160, e161, e162, e163, e164, e165, e166, e167, e168, e169, e170, e171, e172, e173, e174, e175, e176, e177, e178, e179, e180, e181, e182, e183, e184, e185, e186, e187, e188, e189, e190, e191, e192

#define BOOST_HANA_PP_DROP_BACK_IMPL_194(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159, e160, e161, e162, e163, e164, e165, e166, e167, e168, e169, e170, e171, e172, e173, e174, e175, e176, e177, e178, e179, e180, e181, e182, e183, e184, e185, e186, e187, e188, e189, e190, e191, e192, e193, e194)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159, e160, e161, e162, e163, e164, e165, e166, e167, e168, e169, e170, e171, e172, e173, e174, e175, e176, e177, e178, e179, e180, e181, e182, e183, e184, e185, e186, e187, e188, e189, e190, e191, e192, e193

#define BOOST_HANA_PP_DROP_BACK_IMPL_195(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159, e160, e161, e162, e163, e164, e165, e166, e167, e168, e169, e170, e171, e172, e173, e174, e175, e176, e177, e178, e179, e180, e181, e182, e183, e184, e185, e186, e187, e188, e189, e190, e191, e192, e193, e194, e195)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159, e160, e161, e162, e163, e164, e165, e166, e167, e168, e169, e170, e171, e172, e173, e174, e175, e176, e177, e178, e179, e180, e181, e182, e183, e184, e185, e186, e187, e188, e189, e190, e191, e192, e193, e194

#define BOOST_HANA_PP_DROP_BACK_IMPL_196(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159, e160, e161, e162, e163, e164, e165, e166, e167, e168, e169, e170, e171, e172, e173, e174, e175, e176, e177, e178, e179, e180, e181, e182, e183, e184, e185, e186, e187, e188, e189, e190, e191, e192, e193, e194, e195, e196)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159, e160, e161, e162, e163, e164, e165, e166, e167, e168, e169, e170, e171, e172, e173, e174, e175, e176, e177, e178, e179, e180, e181, e182, e183, e184, e185, e186, e187, e188, e189, e190, e191, e192, e193, e194, e195

#define BOOST_HANA_PP_DROP_BACK_IMPL_197(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159, e160, e161, e162, e163, e164, e165, e166, e167, e168, e169, e170, e171, e172, e173, e174, e175, e176, e177, e178, e179, e180, e181, e182, e183, e184, e185, e186, e187, e188, e189, e190, e191, e192, e193, e194, e195, e196, e197)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159, e160, e161, e162, e163, e164, e165, e166, e167, e168, e169, e170, e171, e172, e173, e174, e175, e176, e177, e178, e179, e180, e181, e182, e183, e184, e185, e186, e187, e188, e189, e190, e191, e192, e193, e194, e195, e196

#define BOOST_HANA_PP_DROP_BACK_IMPL_198(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159, e160, e161, e162, e163, e164, e165, e166, e167, e168, e169, e170, e171, e172, e173, e174, e175, e176, e177, e178, e179, e180, e181, e182, e183, e184, e185, e186, e187, e188, e189, e190, e191, e192, e193, e194, e195, e196, e197, e198)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159, e160, e161, e162, e163, e164, e165, e166, e167, e168, e169, e170, e171, e172, e173, e174, e175, e176, e177, e178, e179, e180, e181, e182, e183, e184, e185, e186, e187, e188, e189, e190, e191, e192, e193, e194, e195, e196, e197

#define BOOST_HANA_PP_DROP_BACK_IMPL_199(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159, e160, e161, e162, e163, e164, e165, e166, e167, e168, e169, e170, e171, e172, e173, e174, e175, e176, e177, e178, e179, e180, e181, e182, e183, e184, e185, e186, e187, e188, e189, e190, e191, e192, e193, e194, e195, e196, e197, e198, e199)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159, e160, e161, e162, e163, e164, e165, e166, e167, e168, e169, e170, e171, e172, e173, e174, e175, e176, e177, e178, e179, e180, e181, e182, e183, e184, e185, e186, e187, e188, e189, e190, e191, e192, e193, e194, e195, e196, e197, e198

#define BOOST_HANA_PP_DROP_BACK_IMPL_200(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159, e160, e161, e162, e163, e164, e165, e166, e167, e168, e169, e170, e171, e172, e173, e174, e175, e176, e177, e178, e179, e180, e181, e182, e183, e184, e185, e186, e187, e188, e189, e190, e191, e192, e193, e194, e195, e196, e197, e198, e199, e200)e1, e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12, e13, e14, e15, e16, e17, e18, e19, e20, e21, e22, e23, e24, e25, e26, e27, e28, e29, e30, e31, e32, e33, e34, e35, e36, e37, e38, e39, e40, e41, e42, e43, e44, e45, e46, e47, e48, e49, e50, e51, e52, e53, e54, e55, e56, e57, e58, e59, e60, e61, e62, e63, e64, e65, e66, e67, e68, e69, e70, e71, e72, e73, e74, e75, e76, e77, e78, e79, e80, e81, e82, e83, e84, e85, e86, e87, e88, e89, e90, e91, e92, e93, e94, e95, e96, e97, e98, e99, e100, e101, e102, e103, e104, e105, e106, e107, e108, e109, e110, e111, e112, e113, e114, e115, e116, e117, e118, e119, e120, e121, e122, e123, e124, e125, e126, e127, e128, e129, e130, e131, e132, e133, e134, e135, e136, e137, e138, e139, e140, e141, e142, e143, e144, e145, e146, e147, e148, e149, e150, e151, e152, e153, e154, e155, e156, e157, e158, e159, e160, e161, e162, e163, e164, e165, e166, e167, e168, e169, e170, e171, e172, e173, e174, e175, e176, e177, e178, e179, e180, e181, e182, e183, e184, e185, e186, e187, e188, e189, e190, e191, e192, e193, e194, e195, e196, e197, e198, e199


//////////////////////////////////////////////////////////////////////////////
// BOOST_HANA_ADAPT_STRUCT
//////////////////////////////////////////////////////////////////////////////
template <typename ...>
struct BOOST_HANA_ADAPT_STRUCT_must_be_called_in_the_global_namespace;

#define BOOST_HANA_ADAPT_STRUCT(...)                                        \
  template <>                                                               \
  struct BOOST_HANA_ADAPT_STRUCT_must_be_called_in_the_global_namespace<>;  \
  BOOST_HANA_ADAPT_STRUCT_IMPL(BOOST_HANA_PP_NARG(__VA_ARGS__), __VA_ARGS__)\
  static_assert(true, "force the usage of a trailing semicolon")            \
/**/

#ifdef BOOST_HANA_WORKAROUND_MSVC_PREPROCESSOR_616033
#   define BOOST_HANA_ADAPT_STRUCT_IMPL(N, ...) BOOST_HANA_ADAPT_STRUCT_IMPL_I(N, __VA_ARGS__)
#   define BOOST_HANA_ADAPT_STRUCT_IMPL_I(N, ...) \
        BOOST_HANA_PP_CONCAT(BOOST_HANA_PP_CONCAT(BOOST_HANA_ADAPT_STRUCT_IMPL_, N)(__VA_ARGS__),)
#else
#   define BOOST_HANA_ADAPT_STRUCT_IMPL(N, ...) \
    BOOST_HANA_PP_CONCAT(BOOST_HANA_ADAPT_STRUCT_IMPL_, N)(__VA_ARGS__)
#endif


#define BOOST_HANA_ADAPT_STRUCT_IMPL_1(TYPE )    \
    namespace boost { namespace hana {                                                            \
        template <>                                                                               \
        struct accessors_impl<TYPE> {                                                             \
            static constexpr auto apply() {                                                       \
                struct member_names {                                                             \
                  static constexpr auto get() {                                                   \
                      return ::boost::hana::make_tuple(                                           \
                             \
                      );                                                                          \
                  }                                                                               \
                };                                                                                \
                return ::boost::hana::make_tuple(                                                 \
                    \
                );                                                                                \
            }                                                                                     \
        };                                                                                        \
    }}                                                                                            \
/**/

#define BOOST_HANA_ADAPT_STRUCT_IMPL_2(TYPE , m1)    \
    namespace boost { namespace hana {                                                            \
        template <>                                                                               \
        struct accessors_impl<TYPE> {                                                             \
            static constexpr auto apply() {                                                       \
                struct member_names {                                                             \
                  static constexpr auto get() {                                                   \
                      return ::boost::hana::make_tuple(                                           \
                          BOOST_HANA_PP_STRINGIZE(m1)   \
                      );                                                                          \
                  }                                                                               \
                };                                                                                \
                return ::boost::hana::make_tuple(                                                 \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m1), &TYPE::m1>{})\
                );                                                                                \
            }                                                                                     \
        };                                                                                        \
    }}                                                                                            \
/**/

#define BOOST_HANA_ADAPT_STRUCT_IMPL_3(TYPE , m1, m2)    \
    namespace boost { namespace hana {                                                            \
        template <>                                                                               \
        struct accessors_impl<TYPE> {                                                             \
            static constexpr auto apply() {                                                       \
                struct member_names {                                                             \
                  static constexpr auto get() {                                                   \
                      return ::boost::hana::make_tuple(                                           \
                          BOOST_HANA_PP_STRINGIZE(m1), BOOST_HANA_PP_STRINGIZE(m2)   \
                      );                                                                          \
                  }                                                                               \
                };                                                                                \
                return ::boost::hana::make_tuple(                                                 \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m1), &TYPE::m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m2), &TYPE::m2>{})\
                );                                                                                \
            }                                                                                     \
        };                                                                                        \
    }}                                                                                            \
/**/

#define BOOST_HANA_ADAPT_STRUCT_IMPL_4(TYPE , m1, m2, m3)    \
    namespace boost { namespace hana {                                                            \
        template <>                                                                               \
        struct accessors_impl<TYPE> {                                                             \
            static constexpr auto apply() {                                                       \
                struct member_names {                                                             \
                  static constexpr auto get() {                                                   \
                      return ::boost::hana::make_tuple(                                           \
                          BOOST_HANA_PP_STRINGIZE(m1), BOOST_HANA_PP_STRINGIZE(m2), BOOST_HANA_PP_STRINGIZE(m3)   \
                      );                                                                          \
                  }                                                                               \
                };                                                                                \
                return ::boost::hana::make_tuple(                                                 \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m1), &TYPE::m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m2), &TYPE::m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m3), &TYPE::m3>{})\
                );                                                                                \
            }                                                                                     \
        };                                                                                        \
    }}                                                                                            \
/**/

#define BOOST_HANA_ADAPT_STRUCT_IMPL_5(TYPE , m1, m2, m3, m4)    \
    namespace boost { namespace hana {                                                            \
        template <>                                                                               \
        struct accessors_impl<TYPE> {                                                             \
            static constexpr auto apply() {                                                       \
                struct member_names {                                                             \
                  static constexpr auto get() {                                                   \
                      return ::boost::hana::make_tuple(                                           \
                          BOOST_HANA_PP_STRINGIZE(m1), BOOST_HANA_PP_STRINGIZE(m2), BOOST_HANA_PP_STRINGIZE(m3), BOOST_HANA_PP_STRINGIZE(m4)   \
                      );                                                                          \
                  }                                                                               \
                };                                                                                \
                return ::boost::hana::make_tuple(                                                 \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m1), &TYPE::m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m2), &TYPE::m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m3), &TYPE::m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m4), &TYPE::m4>{})\
                );                                                                                \
            }                                                                                     \
        };                                                                                        \
    }}                                                                                            \
/**/

#define BOOST_HANA_ADAPT_STRUCT_IMPL_6(TYPE , m1, m2, m3, m4, m5)    \
    namespace boost { namespace hana {                                                            \
        template <>                                                                               \
        struct accessors_impl<TYPE> {                                                             \
            static constexpr auto apply() {                                                       \
                struct member_names {                                                             \
                  static constexpr auto get() {                                                   \
                      return ::boost::hana::make_tuple(                                           \
                          BOOST_HANA_PP_STRINGIZE(m1), BOOST_HANA_PP_STRINGIZE(m2), BOOST_HANA_PP_STRINGIZE(m3), BOOST_HANA_PP_STRINGIZE(m4), BOOST_HANA_PP_STRINGIZE(m5)   \
                      );                                                                          \
                  }                                                                               \
                };                                                                                \
                return ::boost::hana::make_tuple(                                                 \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m1), &TYPE::m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m2), &TYPE::m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m3), &TYPE::m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m4), &TYPE::m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m5), &TYPE::m5>{})\
                );                                                                                \
            }                                                                                     \
        };                                                                                        \
    }}                                                                                            \
/**/

#define BOOST_HANA_ADAPT_STRUCT_IMPL_7(TYPE , m1, m2, m3, m4, m5, m6)    \
    namespace boost { namespace hana {                                                            \
        template <>                                                                               \
        struct accessors_impl<TYPE> {                                                             \
            static constexpr auto apply() {                                                       \
                struct member_names {                                                             \
                  static constexpr auto get() {                                                   \
                      return ::boost::hana::make_tuple(                                           \
                          BOOST_HANA_PP_STRINGIZE(m1), BOOST_HANA_PP_STRINGIZE(m2), BOOST_HANA_PP_STRINGIZE(m3), BOOST_HANA_PP_STRINGIZE(m4), BOOST_HANA_PP_STRINGIZE(m5), BOOST_HANA_PP_STRINGIZE(m6)   \
                      );                                                                          \
                  }                                                                               \
                };                                                                                \
                return ::boost::hana::make_tuple(                                                 \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m1), &TYPE::m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m2), &TYPE::m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m3), &TYPE::m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m4), &TYPE::m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m5), &TYPE::m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m6), &TYPE::m6>{})\
                );                                                                                \
            }                                                                                     \
        };                                                                                        \
    }}                                                                                            \
/**/

#define BOOST_HANA_ADAPT_STRUCT_IMPL_8(TYPE , m1, m2, m3, m4, m5, m6, m7)    \
    namespace boost { namespace hana {                                                            \
        template <>                                                                               \
        struct accessors_impl<TYPE> {                                                             \
            static constexpr auto apply() {                                                       \
                struct member_names {                                                             \
                  static constexpr auto get() {                                                   \
                      return ::boost::hana::make_tuple(                                           \
                          BOOST_HANA_PP_STRINGIZE(m1), BOOST_HANA_PP_STRINGIZE(m2), BOOST_HANA_PP_STRINGIZE(m3), BOOST_HANA_PP_STRINGIZE(m4), BOOST_HANA_PP_STRINGIZE(m5), BOOST_HANA_PP_STRINGIZE(m6), BOOST_HANA_PP_STRINGIZE(m7)   \
                      );                                                                          \
                  }                                                                               \
                };                                                                                \
                return ::boost::hana::make_tuple(                                                 \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m1), &TYPE::m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m2), &TYPE::m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m3), &TYPE::m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m4), &TYPE::m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m5), &TYPE::m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m6), &TYPE::m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m7), &TYPE::m7>{})\
                );                                                                                \
            }                                                                                     \
        };                                                                                        \
    }}                                                                                            \
/**/

#define BOOST_HANA_ADAPT_STRUCT_IMPL_9(TYPE , m1, m2, m3, m4, m5, m6, m7, m8)    \
    namespace boost { namespace hana {                                                            \
        template <>                                                                               \
        struct accessors_impl<TYPE> {                                                             \
            static constexpr auto apply() {                                                       \
                struct member_names {                                                             \
                  static constexpr auto get() {                                                   \
                      return ::boost::hana::make_tuple(                                           \
                          BOOST_HANA_PP_STRINGIZE(m1), BOOST_HANA_PP_STRINGIZE(m2), BOOST_HANA_PP_STRINGIZE(m3), BOOST_HANA_PP_STRINGIZE(m4), BOOST_HANA_PP_STRINGIZE(m5), BOOST_HANA_PP_STRINGIZE(m6), BOOST_HANA_PP_STRINGIZE(m7), BOOST_HANA_PP_STRINGIZE(m8)   \
                      );                                                                          \
                  }                                                                               \
                };                                                                                \
                return ::boost::hana::make_tuple(                                                 \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m1), &TYPE::m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m2), &TYPE::m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m3), &TYPE::m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m4), &TYPE::m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m5), &TYPE::m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m6), &TYPE::m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m7), &TYPE::m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m8), &TYPE::m8>{})\
                );                                                                                \
            }                                                                                     \
        };                                                                                        \
    }}                                                                                            \
/**/

#define BOOST_HANA_ADAPT_STRUCT_IMPL_10(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9)    \
    namespace boost { namespace hana {                                                            \
        template <>                                                                               \
        struct accessors_impl<TYPE> {                                                             \
            static constexpr auto apply() {                                                       \
                struct member_names {                                                             \
                  static constexpr auto get() {                                                   \
                      return ::boost::hana::make_tuple(                                           \
                          BOOST_HANA_PP_STRINGIZE(m1), BOOST_HANA_PP_STRINGIZE(m2), BOOST_HANA_PP_STRINGIZE(m3), BOOST_HANA_PP_STRINGIZE(m4), BOOST_HANA_PP_STRINGIZE(m5), BOOST_HANA_PP_STRINGIZE(m6), BOOST_HANA_PP_STRINGIZE(m7), BOOST_HANA_PP_STRINGIZE(m8), BOOST_HANA_PP_STRINGIZE(m9)   \
                      );                                                                          \
                  }                                                                               \
                };                                                                                \
                return ::boost::hana::make_tuple(                                                 \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m1), &TYPE::m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m2), &TYPE::m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m3), &TYPE::m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m4), &TYPE::m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m5), &TYPE::m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m6), &TYPE::m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m7), &TYPE::m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m8), &TYPE::m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m9), &TYPE::m9>{})\
                );                                                                                \
            }                                                                                     \
        };                                                                                        \
    }}                                                                                            \
/**/

#define BOOST_HANA_ADAPT_STRUCT_IMPL_11(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10)    \
    namespace boost { namespace hana {                                                            \
        template <>                                                                               \
        struct accessors_impl<TYPE> {                                                             \
            static constexpr auto apply() {                                                       \
                struct member_names {                                                             \
                  static constexpr auto get() {                                                   \
                      return ::boost::hana::make_tuple(                                           \
                          BOOST_HANA_PP_STRINGIZE(m1), BOOST_HANA_PP_STRINGIZE(m2), BOOST_HANA_PP_STRINGIZE(m3), BOOST_HANA_PP_STRINGIZE(m4), BOOST_HANA_PP_STRINGIZE(m5), BOOST_HANA_PP_STRINGIZE(m6), BOOST_HANA_PP_STRINGIZE(m7), BOOST_HANA_PP_STRINGIZE(m8), BOOST_HANA_PP_STRINGIZE(m9), BOOST_HANA_PP_STRINGIZE(m10)   \
                      );                                                                          \
                  }                                                                               \
                };                                                                                \
                return ::boost::hana::make_tuple(                                                 \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m1), &TYPE::m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m2), &TYPE::m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m3), &TYPE::m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m4), &TYPE::m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m5), &TYPE::m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m6), &TYPE::m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m7), &TYPE::m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m8), &TYPE::m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m9), &TYPE::m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m10), &TYPE::m10>{})\
                );                                                                                \
            }                                                                                     \
        };                                                                                        \
    }}                                                                                            \
/**/

#define BOOST_HANA_ADAPT_STRUCT_IMPL_12(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11)    \
    namespace boost { namespace hana {                                                            \
        template <>                                                                               \
        struct accessors_impl<TYPE> {                                                             \
            static constexpr auto apply() {                                                       \
                struct member_names {                                                             \
                  static constexpr auto get() {                                                   \
                      return ::boost::hana::make_tuple(                                           \
                          BOOST_HANA_PP_STRINGIZE(m1), BOOST_HANA_PP_STRINGIZE(m2), BOOST_HANA_PP_STRINGIZE(m3), BOOST_HANA_PP_STRINGIZE(m4), BOOST_HANA_PP_STRINGIZE(m5), BOOST_HANA_PP_STRINGIZE(m6), BOOST_HANA_PP_STRINGIZE(m7), BOOST_HANA_PP_STRINGIZE(m8), BOOST_HANA_PP_STRINGIZE(m9), BOOST_HANA_PP_STRINGIZE(m10), BOOST_HANA_PP_STRINGIZE(m11)   \
                      );                                                                          \
                  }                                                                               \
                };                                                                                \
                return ::boost::hana::make_tuple(                                                 \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m1), &TYPE::m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m2), &TYPE::m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m3), &TYPE::m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m4), &TYPE::m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m5), &TYPE::m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m6), &TYPE::m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m7), &TYPE::m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m8), &TYPE::m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m9), &TYPE::m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m10), &TYPE::m10>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m11), &TYPE::m11>{})\
                );                                                                                \
            }                                                                                     \
        };                                                                                        \
    }}                                                                                            \
/**/

#define BOOST_HANA_ADAPT_STRUCT_IMPL_13(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12)    \
    namespace boost { namespace hana {                                                            \
        template <>                                                                               \
        struct accessors_impl<TYPE> {                                                             \
            static constexpr auto apply() {                                                       \
                struct member_names {                                                             \
                  static constexpr auto get() {                                                   \
                      return ::boost::hana::make_tuple(                                           \
                          BOOST_HANA_PP_STRINGIZE(m1), BOOST_HANA_PP_STRINGIZE(m2), BOOST_HANA_PP_STRINGIZE(m3), BOOST_HANA_PP_STRINGIZE(m4), BOOST_HANA_PP_STRINGIZE(m5), BOOST_HANA_PP_STRINGIZE(m6), BOOST_HANA_PP_STRINGIZE(m7), BOOST_HANA_PP_STRINGIZE(m8), BOOST_HANA_PP_STRINGIZE(m9), BOOST_HANA_PP_STRINGIZE(m10), BOOST_HANA_PP_STRINGIZE(m11), BOOST_HANA_PP_STRINGIZE(m12)   \
                      );                                                                          \
                  }                                                                               \
                };                                                                                \
                return ::boost::hana::make_tuple(                                                 \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m1), &TYPE::m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m2), &TYPE::m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m3), &TYPE::m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m4), &TYPE::m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m5), &TYPE::m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m6), &TYPE::m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m7), &TYPE::m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m8), &TYPE::m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m9), &TYPE::m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m10), &TYPE::m10>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m11), &TYPE::m11>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m12), &TYPE::m12>{})\
                );                                                                                \
            }                                                                                     \
        };                                                                                        \
    }}                                                                                            \
/**/

#define BOOST_HANA_ADAPT_STRUCT_IMPL_14(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13)    \
    namespace boost { namespace hana {                                                            \
        template <>                                                                               \
        struct accessors_impl<TYPE> {                                                             \
            static constexpr auto apply() {                                                       \
                struct member_names {                                                             \
                  static constexpr auto get() {                                                   \
                      return ::boost::hana::make_tuple(                                           \
                          BOOST_HANA_PP_STRINGIZE(m1), BOOST_HANA_PP_STRINGIZE(m2), BOOST_HANA_PP_STRINGIZE(m3), BOOST_HANA_PP_STRINGIZE(m4), BOOST_HANA_PP_STRINGIZE(m5), BOOST_HANA_PP_STRINGIZE(m6), BOOST_HANA_PP_STRINGIZE(m7), BOOST_HANA_PP_STRINGIZE(m8), BOOST_HANA_PP_STRINGIZE(m9), BOOST_HANA_PP_STRINGIZE(m10), BOOST_HANA_PP_STRINGIZE(m11), BOOST_HANA_PP_STRINGIZE(m12), BOOST_HANA_PP_STRINGIZE(m13)   \
                      );                                                                          \
                  }                                                                               \
                };                                                                                \
                return ::boost::hana::make_tuple(                                                 \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m1), &TYPE::m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m2), &TYPE::m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m3), &TYPE::m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m4), &TYPE::m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m5), &TYPE::m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m6), &TYPE::m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m7), &TYPE::m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m8), &TYPE::m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m9), &TYPE::m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m10), &TYPE::m10>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m11), &TYPE::m11>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m12), &TYPE::m12>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m13), &TYPE::m13>{})\
                );                                                                                \
            }                                                                                     \
        };                                                                                        \
    }}                                                                                            \
/**/

#define BOOST_HANA_ADAPT_STRUCT_IMPL_15(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14)    \
    namespace boost { namespace hana {                                                            \
        template <>                                                                               \
        struct accessors_impl<TYPE> {                                                             \
            static constexpr auto apply() {                                                       \
                struct member_names {                                                             \
                  static constexpr auto get() {                                                   \
                      return ::boost::hana::make_tuple(                                           \
                          BOOST_HANA_PP_STRINGIZE(m1), BOOST_HANA_PP_STRINGIZE(m2), BOOST_HANA_PP_STRINGIZE(m3), BOOST_HANA_PP_STRINGIZE(m4), BOOST_HANA_PP_STRINGIZE(m5), BOOST_HANA_PP_STRINGIZE(m6), BOOST_HANA_PP_STRINGIZE(m7), BOOST_HANA_PP_STRINGIZE(m8), BOOST_HANA_PP_STRINGIZE(m9), BOOST_HANA_PP_STRINGIZE(m10), BOOST_HANA_PP_STRINGIZE(m11), BOOST_HANA_PP_STRINGIZE(m12), BOOST_HANA_PP_STRINGIZE(m13), BOOST_HANA_PP_STRINGIZE(m14)   \
                      );                                                                          \
                  }                                                                               \
                };                                                                                \
                return ::boost::hana::make_tuple(                                                 \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m1), &TYPE::m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m2), &TYPE::m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m3), &TYPE::m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m4), &TYPE::m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m5), &TYPE::m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m6), &TYPE::m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m7), &TYPE::m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m8), &TYPE::m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m9), &TYPE::m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m10), &TYPE::m10>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m11), &TYPE::m11>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m12), &TYPE::m12>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m13), &TYPE::m13>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m14), &TYPE::m14>{})\
                );                                                                                \
            }                                                                                     \
        };                                                                                        \
    }}                                                                                            \
/**/

#define BOOST_HANA_ADAPT_STRUCT_IMPL_16(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15)    \
    namespace boost { namespace hana {                                                            \
        template <>                                                                               \
        struct accessors_impl<TYPE> {                                                             \
            static constexpr auto apply() {                                                       \
                struct member_names {                                                             \
                  static constexpr auto get() {                                                   \
                      return ::boost::hana::make_tuple(                                           \
                          BOOST_HANA_PP_STRINGIZE(m1), BOOST_HANA_PP_STRINGIZE(m2), BOOST_HANA_PP_STRINGIZE(m3), BOOST_HANA_PP_STRINGIZE(m4), BOOST_HANA_PP_STRINGIZE(m5), BOOST_HANA_PP_STRINGIZE(m6), BOOST_HANA_PP_STRINGIZE(m7), BOOST_HANA_PP_STRINGIZE(m8), BOOST_HANA_PP_STRINGIZE(m9), BOOST_HANA_PP_STRINGIZE(m10), BOOST_HANA_PP_STRINGIZE(m11), BOOST_HANA_PP_STRINGIZE(m12), BOOST_HANA_PP_STRINGIZE(m13), BOOST_HANA_PP_STRINGIZE(m14), BOOST_HANA_PP_STRINGIZE(m15)   \
                      );                                                                          \
                  }                                                                               \
                };                                                                                \
                return ::boost::hana::make_tuple(                                                 \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m1), &TYPE::m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m2), &TYPE::m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m3), &TYPE::m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m4), &TYPE::m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m5), &TYPE::m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m6), &TYPE::m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m7), &TYPE::m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m8), &TYPE::m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m9), &TYPE::m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m10), &TYPE::m10>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m11), &TYPE::m11>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m12), &TYPE::m12>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m13), &TYPE::m13>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m14), &TYPE::m14>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m15), &TYPE::m15>{})\
                );                                                                                \
            }                                                                                     \
        };                                                                                        \
    }}                                                                                            \
/**/

#define BOOST_HANA_ADAPT_STRUCT_IMPL_17(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16)    \
    namespace boost { namespace hana {                                                            \
        template <>                                                                               \
        struct accessors_impl<TYPE> {                                                             \
            static constexpr auto apply() {                                                       \
                struct member_names {                                                             \
                  static constexpr auto get() {                                                   \
                      return ::boost::hana::make_tuple(                                           \
                          BOOST_HANA_PP_STRINGIZE(m1), BOOST_HANA_PP_STRINGIZE(m2), BOOST_HANA_PP_STRINGIZE(m3), BOOST_HANA_PP_STRINGIZE(m4), BOOST_HANA_PP_STRINGIZE(m5), BOOST_HANA_PP_STRINGIZE(m6), BOOST_HANA_PP_STRINGIZE(m7), BOOST_HANA_PP_STRINGIZE(m8), BOOST_HANA_PP_STRINGIZE(m9), BOOST_HANA_PP_STRINGIZE(m10), BOOST_HANA_PP_STRINGIZE(m11), BOOST_HANA_PP_STRINGIZE(m12), BOOST_HANA_PP_STRINGIZE(m13), BOOST_HANA_PP_STRINGIZE(m14), BOOST_HANA_PP_STRINGIZE(m15), BOOST_HANA_PP_STRINGIZE(m16)   \
                      );                                                                          \
                  }                                                                               \
                };                                                                                \
                return ::boost::hana::make_tuple(                                                 \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m1), &TYPE::m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m2), &TYPE::m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m3), &TYPE::m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m4), &TYPE::m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m5), &TYPE::m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m6), &TYPE::m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m7), &TYPE::m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m8), &TYPE::m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m9), &TYPE::m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m10), &TYPE::m10>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m11), &TYPE::m11>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m12), &TYPE::m12>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m13), &TYPE::m13>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m14), &TYPE::m14>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m15), &TYPE::m15>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m16), &TYPE::m16>{})\
                );                                                                                \
            }                                                                                     \
        };                                                                                        \
    }}                                                                                            \
/**/

#define BOOST_HANA_ADAPT_STRUCT_IMPL_18(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17)    \
    namespace boost { namespace hana {                                                            \
        template <>                                                                               \
        struct accessors_impl<TYPE> {                                                             \
            static constexpr auto apply() {                                                       \
                struct member_names {                                                             \
                  static constexpr auto get() {                                                   \
                      return ::boost::hana::make_tuple(                                           \
                          BOOST_HANA_PP_STRINGIZE(m1), BOOST_HANA_PP_STRINGIZE(m2), BOOST_HANA_PP_STRINGIZE(m3), BOOST_HANA_PP_STRINGIZE(m4), BOOST_HANA_PP_STRINGIZE(m5), BOOST_HANA_PP_STRINGIZE(m6), BOOST_HANA_PP_STRINGIZE(m7), BOOST_HANA_PP_STRINGIZE(m8), BOOST_HANA_PP_STRINGIZE(m9), BOOST_HANA_PP_STRINGIZE(m10), BOOST_HANA_PP_STRINGIZE(m11), BOOST_HANA_PP_STRINGIZE(m12), BOOST_HANA_PP_STRINGIZE(m13), BOOST_HANA_PP_STRINGIZE(m14), BOOST_HANA_PP_STRINGIZE(m15), BOOST_HANA_PP_STRINGIZE(m16), BOOST_HANA_PP_STRINGIZE(m17)   \
                      );                                                                          \
                  }                                                                               \
                };                                                                                \
                return ::boost::hana::make_tuple(                                                 \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m1), &TYPE::m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m2), &TYPE::m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m3), &TYPE::m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m4), &TYPE::m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m5), &TYPE::m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m6), &TYPE::m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m7), &TYPE::m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m8), &TYPE::m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m9), &TYPE::m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m10), &TYPE::m10>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m11), &TYPE::m11>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m12), &TYPE::m12>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m13), &TYPE::m13>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m14), &TYPE::m14>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m15), &TYPE::m15>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m16), &TYPE::m16>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m17), &TYPE::m17>{})\
                );                                                                                \
            }                                                                                     \
        };                                                                                        \
    }}                                                                                            \
/**/

#define BOOST_HANA_ADAPT_STRUCT_IMPL_19(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18)    \
    namespace boost { namespace hana {                                                            \
        template <>                                                                               \
        struct accessors_impl<TYPE> {                                                             \
            static constexpr auto apply() {                                                       \
                struct member_names {                                                             \
                  static constexpr auto get() {                                                   \
                      return ::boost::hana::make_tuple(                                           \
                          BOOST_HANA_PP_STRINGIZE(m1), BOOST_HANA_PP_STRINGIZE(m2), BOOST_HANA_PP_STRINGIZE(m3), BOOST_HANA_PP_STRINGIZE(m4), BOOST_HANA_PP_STRINGIZE(m5), BOOST_HANA_PP_STRINGIZE(m6), BOOST_HANA_PP_STRINGIZE(m7), BOOST_HANA_PP_STRINGIZE(m8), BOOST_HANA_PP_STRINGIZE(m9), BOOST_HANA_PP_STRINGIZE(m10), BOOST_HANA_PP_STRINGIZE(m11), BOOST_HANA_PP_STRINGIZE(m12), BOOST_HANA_PP_STRINGIZE(m13), BOOST_HANA_PP_STRINGIZE(m14), BOOST_HANA_PP_STRINGIZE(m15), BOOST_HANA_PP_STRINGIZE(m16), BOOST_HANA_PP_STRINGIZE(m17), BOOST_HANA_PP_STRINGIZE(m18)   \
                      );                                                                          \
                  }                                                                               \
                };                                                                                \
                return ::boost::hana::make_tuple(                                                 \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m1), &TYPE::m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m2), &TYPE::m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m3), &TYPE::m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m4), &TYPE::m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m5), &TYPE::m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m6), &TYPE::m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m7), &TYPE::m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m8), &TYPE::m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m9), &TYPE::m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m10), &TYPE::m10>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m11), &TYPE::m11>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m12), &TYPE::m12>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m13), &TYPE::m13>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m14), &TYPE::m14>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m15), &TYPE::m15>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m16), &TYPE::m16>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m17), &TYPE::m17>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m18), &TYPE::m18>{})\
                );                                                                                \
            }                                                                                     \
        };                                                                                        \
    }}                                                                                            \
/**/

#define BOOST_HANA_ADAPT_STRUCT_IMPL_20(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19)    \
    namespace boost { namespace hana {                                                            \
        template <>                                                                               \
        struct accessors_impl<TYPE> {                                                             \
            static constexpr auto apply() {                                                       \
                struct member_names {                                                             \
                  static constexpr auto get() {                                                   \
                      return ::boost::hana::make_tuple(                                           \
                          BOOST_HANA_PP_STRINGIZE(m1), BOOST_HANA_PP_STRINGIZE(m2), BOOST_HANA_PP_STRINGIZE(m3), BOOST_HANA_PP_STRINGIZE(m4), BOOST_HANA_PP_STRINGIZE(m5), BOOST_HANA_PP_STRINGIZE(m6), BOOST_HANA_PP_STRINGIZE(m7), BOOST_HANA_PP_STRINGIZE(m8), BOOST_HANA_PP_STRINGIZE(m9), BOOST_HANA_PP_STRINGIZE(m10), BOOST_HANA_PP_STRINGIZE(m11), BOOST_HANA_PP_STRINGIZE(m12), BOOST_HANA_PP_STRINGIZE(m13), BOOST_HANA_PP_STRINGIZE(m14), BOOST_HANA_PP_STRINGIZE(m15), BOOST_HANA_PP_STRINGIZE(m16), BOOST_HANA_PP_STRINGIZE(m17), BOOST_HANA_PP_STRINGIZE(m18), BOOST_HANA_PP_STRINGIZE(m19)   \
                      );                                                                          \
                  }                                                                               \
                };                                                                                \
                return ::boost::hana::make_tuple(                                                 \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m1), &TYPE::m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m2), &TYPE::m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m3), &TYPE::m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m4), &TYPE::m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m5), &TYPE::m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m6), &TYPE::m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m7), &TYPE::m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m8), &TYPE::m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m9), &TYPE::m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m10), &TYPE::m10>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m11), &TYPE::m11>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m12), &TYPE::m12>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m13), &TYPE::m13>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m14), &TYPE::m14>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m15), &TYPE::m15>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m16), &TYPE::m16>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m17), &TYPE::m17>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m18), &TYPE::m18>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<18, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m19), &TYPE::m19>{})\
                );                                                                                \
            }                                                                                     \
        };                                                                                        \
    }}                                                                                            \
/**/

#define BOOST_HANA_ADAPT_STRUCT_IMPL_21(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20)    \
    namespace boost { namespace hana {                                                            \
        template <>                                                                               \
        struct accessors_impl<TYPE> {                                                             \
            static constexpr auto apply() {                                                       \
                struct member_names {                                                             \
                  static constexpr auto get() {                                                   \
                      return ::boost::hana::make_tuple(                                           \
                          BOOST_HANA_PP_STRINGIZE(m1), BOOST_HANA_PP_STRINGIZE(m2), BOOST_HANA_PP_STRINGIZE(m3), BOOST_HANA_PP_STRINGIZE(m4), BOOST_HANA_PP_STRINGIZE(m5), BOOST_HANA_PP_STRINGIZE(m6), BOOST_HANA_PP_STRINGIZE(m7), BOOST_HANA_PP_STRINGIZE(m8), BOOST_HANA_PP_STRINGIZE(m9), BOOST_HANA_PP_STRINGIZE(m10), BOOST_HANA_PP_STRINGIZE(m11), BOOST_HANA_PP_STRINGIZE(m12), BOOST_HANA_PP_STRINGIZE(m13), BOOST_HANA_PP_STRINGIZE(m14), BOOST_HANA_PP_STRINGIZE(m15), BOOST_HANA_PP_STRINGIZE(m16), BOOST_HANA_PP_STRINGIZE(m17), BOOST_HANA_PP_STRINGIZE(m18), BOOST_HANA_PP_STRINGIZE(m19), BOOST_HANA_PP_STRINGIZE(m20)   \
                      );                                                                          \
                  }                                                                               \
                };                                                                                \
                return ::boost::hana::make_tuple(                                                 \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m1), &TYPE::m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m2), &TYPE::m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m3), &TYPE::m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m4), &TYPE::m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m5), &TYPE::m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m6), &TYPE::m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m7), &TYPE::m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m8), &TYPE::m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m9), &TYPE::m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m10), &TYPE::m10>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m11), &TYPE::m11>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m12), &TYPE::m12>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m13), &TYPE::m13>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m14), &TYPE::m14>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m15), &TYPE::m15>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m16), &TYPE::m16>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m17), &TYPE::m17>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m18), &TYPE::m18>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<18, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m19), &TYPE::m19>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<19, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m20), &TYPE::m20>{})\
                );                                                                                \
            }                                                                                     \
        };                                                                                        \
    }}                                                                                            \
/**/

#define BOOST_HANA_ADAPT_STRUCT_IMPL_22(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21)    \
    namespace boost { namespace hana {                                                            \
        template <>                                                                               \
        struct accessors_impl<TYPE> {                                                             \
            static constexpr auto apply() {                                                       \
                struct member_names {                                                             \
                  static constexpr auto get() {                                                   \
                      return ::boost::hana::make_tuple(                                           \
                          BOOST_HANA_PP_STRINGIZE(m1), BOOST_HANA_PP_STRINGIZE(m2), BOOST_HANA_PP_STRINGIZE(m3), BOOST_HANA_PP_STRINGIZE(m4), BOOST_HANA_PP_STRINGIZE(m5), BOOST_HANA_PP_STRINGIZE(m6), BOOST_HANA_PP_STRINGIZE(m7), BOOST_HANA_PP_STRINGIZE(m8), BOOST_HANA_PP_STRINGIZE(m9), BOOST_HANA_PP_STRINGIZE(m10), BOOST_HANA_PP_STRINGIZE(m11), BOOST_HANA_PP_STRINGIZE(m12), BOOST_HANA_PP_STRINGIZE(m13), BOOST_HANA_PP_STRINGIZE(m14), BOOST_HANA_PP_STRINGIZE(m15), BOOST_HANA_PP_STRINGIZE(m16), BOOST_HANA_PP_STRINGIZE(m17), BOOST_HANA_PP_STRINGIZE(m18), BOOST_HANA_PP_STRINGIZE(m19), BOOST_HANA_PP_STRINGIZE(m20), BOOST_HANA_PP_STRINGIZE(m21)   \
                      );                                                                          \
                  }                                                                               \
                };                                                                                \
                return ::boost::hana::make_tuple(                                                 \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m1), &TYPE::m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m2), &TYPE::m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m3), &TYPE::m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m4), &TYPE::m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m5), &TYPE::m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m6), &TYPE::m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m7), &TYPE::m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m8), &TYPE::m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m9), &TYPE::m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m10), &TYPE::m10>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m11), &TYPE::m11>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m12), &TYPE::m12>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m13), &TYPE::m13>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m14), &TYPE::m14>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m15), &TYPE::m15>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m16), &TYPE::m16>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m17), &TYPE::m17>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m18), &TYPE::m18>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<18, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m19), &TYPE::m19>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<19, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m20), &TYPE::m20>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<20, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m21), &TYPE::m21>{})\
                );                                                                                \
            }                                                                                     \
        };                                                                                        \
    }}                                                                                            \
/**/

#define BOOST_HANA_ADAPT_STRUCT_IMPL_23(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21, m22)    \
    namespace boost { namespace hana {                                                            \
        template <>                                                                               \
        struct accessors_impl<TYPE> {                                                             \
            static constexpr auto apply() {                                                       \
                struct member_names {                                                             \
                  static constexpr auto get() {                                                   \
                      return ::boost::hana::make_tuple(                                           \
                          BOOST_HANA_PP_STRINGIZE(m1), BOOST_HANA_PP_STRINGIZE(m2), BOOST_HANA_PP_STRINGIZE(m3), BOOST_HANA_PP_STRINGIZE(m4), BOOST_HANA_PP_STRINGIZE(m5), BOOST_HANA_PP_STRINGIZE(m6), BOOST_HANA_PP_STRINGIZE(m7), BOOST_HANA_PP_STRINGIZE(m8), BOOST_HANA_PP_STRINGIZE(m9), BOOST_HANA_PP_STRINGIZE(m10), BOOST_HANA_PP_STRINGIZE(m11), BOOST_HANA_PP_STRINGIZE(m12), BOOST_HANA_PP_STRINGIZE(m13), BOOST_HANA_PP_STRINGIZE(m14), BOOST_HANA_PP_STRINGIZE(m15), BOOST_HANA_PP_STRINGIZE(m16), BOOST_HANA_PP_STRINGIZE(m17), BOOST_HANA_PP_STRINGIZE(m18), BOOST_HANA_PP_STRINGIZE(m19), BOOST_HANA_PP_STRINGIZE(m20), BOOST_HANA_PP_STRINGIZE(m21), BOOST_HANA_PP_STRINGIZE(m22)   \
                      );                                                                          \
                  }                                                                               \
                };                                                                                \
                return ::boost::hana::make_tuple(                                                 \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m1), &TYPE::m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m2), &TYPE::m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m3), &TYPE::m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m4), &TYPE::m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m5), &TYPE::m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m6), &TYPE::m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m7), &TYPE::m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m8), &TYPE::m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m9), &TYPE::m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m10), &TYPE::m10>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m11), &TYPE::m11>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m12), &TYPE::m12>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m13), &TYPE::m13>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m14), &TYPE::m14>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m15), &TYPE::m15>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m16), &TYPE::m16>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m17), &TYPE::m17>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m18), &TYPE::m18>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<18, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m19), &TYPE::m19>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<19, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m20), &TYPE::m20>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<20, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m21), &TYPE::m21>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<21, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m22), &TYPE::m22>{})\
                );                                                                                \
            }                                                                                     \
        };                                                                                        \
    }}                                                                                            \
/**/

#define BOOST_HANA_ADAPT_STRUCT_IMPL_24(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21, m22, m23)    \
    namespace boost { namespace hana {                                                            \
        template <>                                                                               \
        struct accessors_impl<TYPE> {                                                             \
            static constexpr auto apply() {                                                       \
                struct member_names {                                                             \
                  static constexpr auto get() {                                                   \
                      return ::boost::hana::make_tuple(                                           \
                          BOOST_HANA_PP_STRINGIZE(m1), BOOST_HANA_PP_STRINGIZE(m2), BOOST_HANA_PP_STRINGIZE(m3), BOOST_HANA_PP_STRINGIZE(m4), BOOST_HANA_PP_STRINGIZE(m5), BOOST_HANA_PP_STRINGIZE(m6), BOOST_HANA_PP_STRINGIZE(m7), BOOST_HANA_PP_STRINGIZE(m8), BOOST_HANA_PP_STRINGIZE(m9), BOOST_HANA_PP_STRINGIZE(m10), BOOST_HANA_PP_STRINGIZE(m11), BOOST_HANA_PP_STRINGIZE(m12), BOOST_HANA_PP_STRINGIZE(m13), BOOST_HANA_PP_STRINGIZE(m14), BOOST_HANA_PP_STRINGIZE(m15), BOOST_HANA_PP_STRINGIZE(m16), BOOST_HANA_PP_STRINGIZE(m17), BOOST_HANA_PP_STRINGIZE(m18), BOOST_HANA_PP_STRINGIZE(m19), BOOST_HANA_PP_STRINGIZE(m20), BOOST_HANA_PP_STRINGIZE(m21), BOOST_HANA_PP_STRINGIZE(m22), BOOST_HANA_PP_STRINGIZE(m23)   \
                      );                                                                          \
                  }                                                                               \
                };                                                                                \
                return ::boost::hana::make_tuple(                                                 \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m1), &TYPE::m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m2), &TYPE::m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m3), &TYPE::m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m4), &TYPE::m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m5), &TYPE::m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m6), &TYPE::m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m7), &TYPE::m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m8), &TYPE::m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m9), &TYPE::m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m10), &TYPE::m10>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m11), &TYPE::m11>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m12), &TYPE::m12>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m13), &TYPE::m13>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m14), &TYPE::m14>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m15), &TYPE::m15>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m16), &TYPE::m16>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m17), &TYPE::m17>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m18), &TYPE::m18>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<18, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m19), &TYPE::m19>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<19, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m20), &TYPE::m20>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<20, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m21), &TYPE::m21>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<21, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m22), &TYPE::m22>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<22, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m23), &TYPE::m23>{})\
                );                                                                                \
            }                                                                                     \
        };                                                                                        \
    }}                                                                                            \
/**/

#define BOOST_HANA_ADAPT_STRUCT_IMPL_25(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21, m22, m23, m24)    \
    namespace boost { namespace hana {                                                            \
        template <>                                                                               \
        struct accessors_impl<TYPE> {                                                             \
            static constexpr auto apply() {                                                       \
                struct member_names {                                                             \
                  static constexpr auto get() {                                                   \
                      return ::boost::hana::make_tuple(                                           \
                          BOOST_HANA_PP_STRINGIZE(m1), BOOST_HANA_PP_STRINGIZE(m2), BOOST_HANA_PP_STRINGIZE(m3), BOOST_HANA_PP_STRINGIZE(m4), BOOST_HANA_PP_STRINGIZE(m5), BOOST_HANA_PP_STRINGIZE(m6), BOOST_HANA_PP_STRINGIZE(m7), BOOST_HANA_PP_STRINGIZE(m8), BOOST_HANA_PP_STRINGIZE(m9), BOOST_HANA_PP_STRINGIZE(m10), BOOST_HANA_PP_STRINGIZE(m11), BOOST_HANA_PP_STRINGIZE(m12), BOOST_HANA_PP_STRINGIZE(m13), BOOST_HANA_PP_STRINGIZE(m14), BOOST_HANA_PP_STRINGIZE(m15), BOOST_HANA_PP_STRINGIZE(m16), BOOST_HANA_PP_STRINGIZE(m17), BOOST_HANA_PP_STRINGIZE(m18), BOOST_HANA_PP_STRINGIZE(m19), BOOST_HANA_PP_STRINGIZE(m20), BOOST_HANA_PP_STRINGIZE(m21), BOOST_HANA_PP_STRINGIZE(m22), BOOST_HANA_PP_STRINGIZE(m23), BOOST_HANA_PP_STRINGIZE(m24)   \
                      );                                                                          \
                  }                                                                               \
                };                                                                                \
                return ::boost::hana::make_tuple(                                                 \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m1), &TYPE::m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m2), &TYPE::m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m3), &TYPE::m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m4), &TYPE::m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m5), &TYPE::m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m6), &TYPE::m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m7), &TYPE::m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m8), &TYPE::m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m9), &TYPE::m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m10), &TYPE::m10>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m11), &TYPE::m11>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m12), &TYPE::m12>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m13), &TYPE::m13>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m14), &TYPE::m14>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m15), &TYPE::m15>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m16), &TYPE::m16>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m17), &TYPE::m17>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m18), &TYPE::m18>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<18, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m19), &TYPE::m19>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<19, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m20), &TYPE::m20>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<20, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m21), &TYPE::m21>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<21, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m22), &TYPE::m22>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<22, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m23), &TYPE::m23>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<23, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m24), &TYPE::m24>{})\
                );                                                                                \
            }                                                                                     \
        };                                                                                        \
    }}                                                                                            \
/**/

#define BOOST_HANA_ADAPT_STRUCT_IMPL_26(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21, m22, m23, m24, m25)    \
    namespace boost { namespace hana {                                                            \
        template <>                                                                               \
        struct accessors_impl<TYPE> {                                                             \
            static constexpr auto apply() {                                                       \
                struct member_names {                                                             \
                  static constexpr auto get() {                                                   \
                      return ::boost::hana::make_tuple(                                           \
                          BOOST_HANA_PP_STRINGIZE(m1), BOOST_HANA_PP_STRINGIZE(m2), BOOST_HANA_PP_STRINGIZE(m3), BOOST_HANA_PP_STRINGIZE(m4), BOOST_HANA_PP_STRINGIZE(m5), BOOST_HANA_PP_STRINGIZE(m6), BOOST_HANA_PP_STRINGIZE(m7), BOOST_HANA_PP_STRINGIZE(m8), BOOST_HANA_PP_STRINGIZE(m9), BOOST_HANA_PP_STRINGIZE(m10), BOOST_HANA_PP_STRINGIZE(m11), BOOST_HANA_PP_STRINGIZE(m12), BOOST_HANA_PP_STRINGIZE(m13), BOOST_HANA_PP_STRINGIZE(m14), BOOST_HANA_PP_STRINGIZE(m15), BOOST_HANA_PP_STRINGIZE(m16), BOOST_HANA_PP_STRINGIZE(m17), BOOST_HANA_PP_STRINGIZE(m18), BOOST_HANA_PP_STRINGIZE(m19), BOOST_HANA_PP_STRINGIZE(m20), BOOST_HANA_PP_STRINGIZE(m21), BOOST_HANA_PP_STRINGIZE(m22), BOOST_HANA_PP_STRINGIZE(m23), BOOST_HANA_PP_STRINGIZE(m24), BOOST_HANA_PP_STRINGIZE(m25)   \
                      );                                                                          \
                  }                                                                               \
                };                                                                                \
                return ::boost::hana::make_tuple(                                                 \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m1), &TYPE::m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m2), &TYPE::m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m3), &TYPE::m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m4), &TYPE::m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m5), &TYPE::m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m6), &TYPE::m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m7), &TYPE::m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m8), &TYPE::m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m9), &TYPE::m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m10), &TYPE::m10>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m11), &TYPE::m11>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m12), &TYPE::m12>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m13), &TYPE::m13>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m14), &TYPE::m14>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m15), &TYPE::m15>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m16), &TYPE::m16>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m17), &TYPE::m17>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m18), &TYPE::m18>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<18, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m19), &TYPE::m19>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<19, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m20), &TYPE::m20>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<20, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m21), &TYPE::m21>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<21, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m22), &TYPE::m22>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<22, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m23), &TYPE::m23>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<23, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m24), &TYPE::m24>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<24, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m25), &TYPE::m25>{})\
                );                                                                                \
            }                                                                                     \
        };                                                                                        \
    }}                                                                                            \
/**/

#define BOOST_HANA_ADAPT_STRUCT_IMPL_27(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21, m22, m23, m24, m25, m26)    \
    namespace boost { namespace hana {                                                            \
        template <>                                                                               \
        struct accessors_impl<TYPE> {                                                             \
            static constexpr auto apply() {                                                       \
                struct member_names {                                                             \
                  static constexpr auto get() {                                                   \
                      return ::boost::hana::make_tuple(                                           \
                          BOOST_HANA_PP_STRINGIZE(m1), BOOST_HANA_PP_STRINGIZE(m2), BOOST_HANA_PP_STRINGIZE(m3), BOOST_HANA_PP_STRINGIZE(m4), BOOST_HANA_PP_STRINGIZE(m5), BOOST_HANA_PP_STRINGIZE(m6), BOOST_HANA_PP_STRINGIZE(m7), BOOST_HANA_PP_STRINGIZE(m8), BOOST_HANA_PP_STRINGIZE(m9), BOOST_HANA_PP_STRINGIZE(m10), BOOST_HANA_PP_STRINGIZE(m11), BOOST_HANA_PP_STRINGIZE(m12), BOOST_HANA_PP_STRINGIZE(m13), BOOST_HANA_PP_STRINGIZE(m14), BOOST_HANA_PP_STRINGIZE(m15), BOOST_HANA_PP_STRINGIZE(m16), BOOST_HANA_PP_STRINGIZE(m17), BOOST_HANA_PP_STRINGIZE(m18), BOOST_HANA_PP_STRINGIZE(m19), BOOST_HANA_PP_STRINGIZE(m20), BOOST_HANA_PP_STRINGIZE(m21), BOOST_HANA_PP_STRINGIZE(m22), BOOST_HANA_PP_STRINGIZE(m23), BOOST_HANA_PP_STRINGIZE(m24), BOOST_HANA_PP_STRINGIZE(m25), BOOST_HANA_PP_STRINGIZE(m26)   \
                      );                                                                          \
                  }                                                                               \
                };                                                                                \
                return ::boost::hana::make_tuple(                                                 \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m1), &TYPE::m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m2), &TYPE::m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m3), &TYPE::m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m4), &TYPE::m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m5), &TYPE::m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m6), &TYPE::m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m7), &TYPE::m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m8), &TYPE::m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m9), &TYPE::m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m10), &TYPE::m10>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m11), &TYPE::m11>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m12), &TYPE::m12>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m13), &TYPE::m13>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m14), &TYPE::m14>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m15), &TYPE::m15>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m16), &TYPE::m16>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m17), &TYPE::m17>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m18), &TYPE::m18>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<18, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m19), &TYPE::m19>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<19, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m20), &TYPE::m20>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<20, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m21), &TYPE::m21>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<21, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m22), &TYPE::m22>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<22, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m23), &TYPE::m23>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<23, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m24), &TYPE::m24>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<24, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m25), &TYPE::m25>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<25, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m26), &TYPE::m26>{})\
                );                                                                                \
            }                                                                                     \
        };                                                                                        \
    }}                                                                                            \
/**/

#define BOOST_HANA_ADAPT_STRUCT_IMPL_28(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21, m22, m23, m24, m25, m26, m27)    \
    namespace boost { namespace hana {                                                            \
        template <>                                                                               \
        struct accessors_impl<TYPE> {                                                             \
            static constexpr auto apply() {                                                       \
                struct member_names {                                                             \
                  static constexpr auto get() {                                                   \
                      return ::boost::hana::make_tuple(                                           \
                          BOOST_HANA_PP_STRINGIZE(m1), BOOST_HANA_PP_STRINGIZE(m2), BOOST_HANA_PP_STRINGIZE(m3), BOOST_HANA_PP_STRINGIZE(m4), BOOST_HANA_PP_STRINGIZE(m5), BOOST_HANA_PP_STRINGIZE(m6), BOOST_HANA_PP_STRINGIZE(m7), BOOST_HANA_PP_STRINGIZE(m8), BOOST_HANA_PP_STRINGIZE(m9), BOOST_HANA_PP_STRINGIZE(m10), BOOST_HANA_PP_STRINGIZE(m11), BOOST_HANA_PP_STRINGIZE(m12), BOOST_HANA_PP_STRINGIZE(m13), BOOST_HANA_PP_STRINGIZE(m14), BOOST_HANA_PP_STRINGIZE(m15), BOOST_HANA_PP_STRINGIZE(m16), BOOST_HANA_PP_STRINGIZE(m17), BOOST_HANA_PP_STRINGIZE(m18), BOOST_HANA_PP_STRINGIZE(m19), BOOST_HANA_PP_STRINGIZE(m20), BOOST_HANA_PP_STRINGIZE(m21), BOOST_HANA_PP_STRINGIZE(m22), BOOST_HANA_PP_STRINGIZE(m23), BOOST_HANA_PP_STRINGIZE(m24), BOOST_HANA_PP_STRINGIZE(m25), BOOST_HANA_PP_STRINGIZE(m26), BOOST_HANA_PP_STRINGIZE(m27)   \
                      );                                                                          \
                  }                                                                               \
                };                                                                                \
                return ::boost::hana::make_tuple(                                                 \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m1), &TYPE::m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m2), &TYPE::m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m3), &TYPE::m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m4), &TYPE::m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m5), &TYPE::m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m6), &TYPE::m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m7), &TYPE::m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m8), &TYPE::m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m9), &TYPE::m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m10), &TYPE::m10>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m11), &TYPE::m11>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m12), &TYPE::m12>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m13), &TYPE::m13>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m14), &TYPE::m14>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m15), &TYPE::m15>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m16), &TYPE::m16>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m17), &TYPE::m17>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m18), &TYPE::m18>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<18, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m19), &TYPE::m19>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<19, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m20), &TYPE::m20>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<20, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m21), &TYPE::m21>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<21, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m22), &TYPE::m22>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<22, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m23), &TYPE::m23>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<23, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m24), &TYPE::m24>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<24, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m25), &TYPE::m25>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<25, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m26), &TYPE::m26>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<26, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m27), &TYPE::m27>{})\
                );                                                                                \
            }                                                                                     \
        };                                                                                        \
    }}                                                                                            \
/**/

#define BOOST_HANA_ADAPT_STRUCT_IMPL_29(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21, m22, m23, m24, m25, m26, m27, m28)    \
    namespace boost { namespace hana {                                                            \
        template <>                                                                               \
        struct accessors_impl<TYPE> {                                                             \
            static constexpr auto apply() {                                                       \
                struct member_names {                                                             \
                  static constexpr auto get() {                                                   \
                      return ::boost::hana::make_tuple(                                           \
                          BOOST_HANA_PP_STRINGIZE(m1), BOOST_HANA_PP_STRINGIZE(m2), BOOST_HANA_PP_STRINGIZE(m3), BOOST_HANA_PP_STRINGIZE(m4), BOOST_HANA_PP_STRINGIZE(m5), BOOST_HANA_PP_STRINGIZE(m6), BOOST_HANA_PP_STRINGIZE(m7), BOOST_HANA_PP_STRINGIZE(m8), BOOST_HANA_PP_STRINGIZE(m9), BOOST_HANA_PP_STRINGIZE(m10), BOOST_HANA_PP_STRINGIZE(m11), BOOST_HANA_PP_STRINGIZE(m12), BOOST_HANA_PP_STRINGIZE(m13), BOOST_HANA_PP_STRINGIZE(m14), BOOST_HANA_PP_STRINGIZE(m15), BOOST_HANA_PP_STRINGIZE(m16), BOOST_HANA_PP_STRINGIZE(m17), BOOST_HANA_PP_STRINGIZE(m18), BOOST_HANA_PP_STRINGIZE(m19), BOOST_HANA_PP_STRINGIZE(m20), BOOST_HANA_PP_STRINGIZE(m21), BOOST_HANA_PP_STRINGIZE(m22), BOOST_HANA_PP_STRINGIZE(m23), BOOST_HANA_PP_STRINGIZE(m24), BOOST_HANA_PP_STRINGIZE(m25), BOOST_HANA_PP_STRINGIZE(m26), BOOST_HANA_PP_STRINGIZE(m27), BOOST_HANA_PP_STRINGIZE(m28)   \
                      );                                                                          \
                  }                                                                               \
                };                                                                                \
                return ::boost::hana::make_tuple(                                                 \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m1), &TYPE::m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m2), &TYPE::m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m3), &TYPE::m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m4), &TYPE::m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m5), &TYPE::m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m6), &TYPE::m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m7), &TYPE::m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m8), &TYPE::m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m9), &TYPE::m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m10), &TYPE::m10>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m11), &TYPE::m11>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m12), &TYPE::m12>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m13), &TYPE::m13>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m14), &TYPE::m14>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m15), &TYPE::m15>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m16), &TYPE::m16>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m17), &TYPE::m17>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m18), &TYPE::m18>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<18, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m19), &TYPE::m19>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<19, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m20), &TYPE::m20>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<20, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m21), &TYPE::m21>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<21, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m22), &TYPE::m22>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<22, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m23), &TYPE::m23>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<23, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m24), &TYPE::m24>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<24, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m25), &TYPE::m25>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<25, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m26), &TYPE::m26>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<26, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m27), &TYPE::m27>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<27, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m28), &TYPE::m28>{})\
                );                                                                                \
            }                                                                                     \
        };                                                                                        \
    }}                                                                                            \
/**/

#define BOOST_HANA_ADAPT_STRUCT_IMPL_30(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21, m22, m23, m24, m25, m26, m27, m28, m29)    \
    namespace boost { namespace hana {                                                            \
        template <>                                                                               \
        struct accessors_impl<TYPE> {                                                             \
            static constexpr auto apply() {                                                       \
                struct member_names {                                                             \
                  static constexpr auto get() {                                                   \
                      return ::boost::hana::make_tuple(                                           \
                          BOOST_HANA_PP_STRINGIZE(m1), BOOST_HANA_PP_STRINGIZE(m2), BOOST_HANA_PP_STRINGIZE(m3), BOOST_HANA_PP_STRINGIZE(m4), BOOST_HANA_PP_STRINGIZE(m5), BOOST_HANA_PP_STRINGIZE(m6), BOOST_HANA_PP_STRINGIZE(m7), BOOST_HANA_PP_STRINGIZE(m8), BOOST_HANA_PP_STRINGIZE(m9), BOOST_HANA_PP_STRINGIZE(m10), BOOST_HANA_PP_STRINGIZE(m11), BOOST_HANA_PP_STRINGIZE(m12), BOOST_HANA_PP_STRINGIZE(m13), BOOST_HANA_PP_STRINGIZE(m14), BOOST_HANA_PP_STRINGIZE(m15), BOOST_HANA_PP_STRINGIZE(m16), BOOST_HANA_PP_STRINGIZE(m17), BOOST_HANA_PP_STRINGIZE(m18), BOOST_HANA_PP_STRINGIZE(m19), BOOST_HANA_PP_STRINGIZE(m20), BOOST_HANA_PP_STRINGIZE(m21), BOOST_HANA_PP_STRINGIZE(m22), BOOST_HANA_PP_STRINGIZE(m23), BOOST_HANA_PP_STRINGIZE(m24), BOOST_HANA_PP_STRINGIZE(m25), BOOST_HANA_PP_STRINGIZE(m26), BOOST_HANA_PP_STRINGIZE(m27), BOOST_HANA_PP_STRINGIZE(m28), BOOST_HANA_PP_STRINGIZE(m29)   \
                      );                                                                          \
                  }                                                                               \
                };                                                                                \
                return ::boost::hana::make_tuple(                                                 \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m1), &TYPE::m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m2), &TYPE::m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m3), &TYPE::m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m4), &TYPE::m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m5), &TYPE::m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m6), &TYPE::m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m7), &TYPE::m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m8), &TYPE::m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m9), &TYPE::m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m10), &TYPE::m10>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m11), &TYPE::m11>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m12), &TYPE::m12>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m13), &TYPE::m13>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m14), &TYPE::m14>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m15), &TYPE::m15>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m16), &TYPE::m16>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m17), &TYPE::m17>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m18), &TYPE::m18>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<18, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m19), &TYPE::m19>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<19, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m20), &TYPE::m20>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<20, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m21), &TYPE::m21>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<21, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m22), &TYPE::m22>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<22, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m23), &TYPE::m23>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<23, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m24), &TYPE::m24>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<24, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m25), &TYPE::m25>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<25, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m26), &TYPE::m26>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<26, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m27), &TYPE::m27>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<27, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m28), &TYPE::m28>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<28, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m29), &TYPE::m29>{})\
                );                                                                                \
            }                                                                                     \
        };                                                                                        \
    }}                                                                                            \
/**/

#define BOOST_HANA_ADAPT_STRUCT_IMPL_31(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21, m22, m23, m24, m25, m26, m27, m28, m29, m30)    \
    namespace boost { namespace hana {                                                            \
        template <>                                                                               \
        struct accessors_impl<TYPE> {                                                             \
            static constexpr auto apply() {                                                       \
                struct member_names {                                                             \
                  static constexpr auto get() {                                                   \
                      return ::boost::hana::make_tuple(                                           \
                          BOOST_HANA_PP_STRINGIZE(m1), BOOST_HANA_PP_STRINGIZE(m2), BOOST_HANA_PP_STRINGIZE(m3), BOOST_HANA_PP_STRINGIZE(m4), BOOST_HANA_PP_STRINGIZE(m5), BOOST_HANA_PP_STRINGIZE(m6), BOOST_HANA_PP_STRINGIZE(m7), BOOST_HANA_PP_STRINGIZE(m8), BOOST_HANA_PP_STRINGIZE(m9), BOOST_HANA_PP_STRINGIZE(m10), BOOST_HANA_PP_STRINGIZE(m11), BOOST_HANA_PP_STRINGIZE(m12), BOOST_HANA_PP_STRINGIZE(m13), BOOST_HANA_PP_STRINGIZE(m14), BOOST_HANA_PP_STRINGIZE(m15), BOOST_HANA_PP_STRINGIZE(m16), BOOST_HANA_PP_STRINGIZE(m17), BOOST_HANA_PP_STRINGIZE(m18), BOOST_HANA_PP_STRINGIZE(m19), BOOST_HANA_PP_STRINGIZE(m20), BOOST_HANA_PP_STRINGIZE(m21), BOOST_HANA_PP_STRINGIZE(m22), BOOST_HANA_PP_STRINGIZE(m23), BOOST_HANA_PP_STRINGIZE(m24), BOOST_HANA_PP_STRINGIZE(m25), BOOST_HANA_PP_STRINGIZE(m26), BOOST_HANA_PP_STRINGIZE(m27), BOOST_HANA_PP_STRINGIZE(m28), BOOST_HANA_PP_STRINGIZE(m29), BOOST_HANA_PP_STRINGIZE(m30)   \
                      );                                                                          \
                  }                                                                               \
                };                                                                                \
                return ::boost::hana::make_tuple(                                                 \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m1), &TYPE::m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m2), &TYPE::m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m3), &TYPE::m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m4), &TYPE::m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m5), &TYPE::m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m6), &TYPE::m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m7), &TYPE::m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m8), &TYPE::m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m9), &TYPE::m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m10), &TYPE::m10>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m11), &TYPE::m11>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m12), &TYPE::m12>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m13), &TYPE::m13>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m14), &TYPE::m14>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m15), &TYPE::m15>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m16), &TYPE::m16>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m17), &TYPE::m17>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m18), &TYPE::m18>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<18, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m19), &TYPE::m19>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<19, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m20), &TYPE::m20>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<20, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m21), &TYPE::m21>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<21, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m22), &TYPE::m22>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<22, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m23), &TYPE::m23>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<23, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m24), &TYPE::m24>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<24, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m25), &TYPE::m25>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<25, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m26), &TYPE::m26>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<26, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m27), &TYPE::m27>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<27, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m28), &TYPE::m28>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<28, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m29), &TYPE::m29>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<29, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m30), &TYPE::m30>{})\
                );                                                                                \
            }                                                                                     \
        };                                                                                        \
    }}                                                                                            \
/**/

#define BOOST_HANA_ADAPT_STRUCT_IMPL_32(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21, m22, m23, m24, m25, m26, m27, m28, m29, m30, m31)    \
    namespace boost { namespace hana {                                                            \
        template <>                                                                               \
        struct accessors_impl<TYPE> {                                                             \
            static constexpr auto apply() {                                                       \
                struct member_names {                                                             \
                  static constexpr auto get() {                                                   \
                      return ::boost::hana::make_tuple(                                           \
                          BOOST_HANA_PP_STRINGIZE(m1), BOOST_HANA_PP_STRINGIZE(m2), BOOST_HANA_PP_STRINGIZE(m3), BOOST_HANA_PP_STRINGIZE(m4), BOOST_HANA_PP_STRINGIZE(m5), BOOST_HANA_PP_STRINGIZE(m6), BOOST_HANA_PP_STRINGIZE(m7), BOOST_HANA_PP_STRINGIZE(m8), BOOST_HANA_PP_STRINGIZE(m9), BOOST_HANA_PP_STRINGIZE(m10), BOOST_HANA_PP_STRINGIZE(m11), BOOST_HANA_PP_STRINGIZE(m12), BOOST_HANA_PP_STRINGIZE(m13), BOOST_HANA_PP_STRINGIZE(m14), BOOST_HANA_PP_STRINGIZE(m15), BOOST_HANA_PP_STRINGIZE(m16), BOOST_HANA_PP_STRINGIZE(m17), BOOST_HANA_PP_STRINGIZE(m18), BOOST_HANA_PP_STRINGIZE(m19), BOOST_HANA_PP_STRINGIZE(m20), BOOST_HANA_PP_STRINGIZE(m21), BOOST_HANA_PP_STRINGIZE(m22), BOOST_HANA_PP_STRINGIZE(m23), BOOST_HANA_PP_STRINGIZE(m24), BOOST_HANA_PP_STRINGIZE(m25), BOOST_HANA_PP_STRINGIZE(m26), BOOST_HANA_PP_STRINGIZE(m27), BOOST_HANA_PP_STRINGIZE(m28), BOOST_HANA_PP_STRINGIZE(m29), BOOST_HANA_PP_STRINGIZE(m30), BOOST_HANA_PP_STRINGIZE(m31)   \
                      );                                                                          \
                  }                                                                               \
                };                                                                                \
                return ::boost::hana::make_tuple(                                                 \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m1), &TYPE::m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m2), &TYPE::m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m3), &TYPE::m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m4), &TYPE::m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m5), &TYPE::m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m6), &TYPE::m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m7), &TYPE::m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m8), &TYPE::m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m9), &TYPE::m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m10), &TYPE::m10>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m11), &TYPE::m11>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m12), &TYPE::m12>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m13), &TYPE::m13>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m14), &TYPE::m14>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m15), &TYPE::m15>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m16), &TYPE::m16>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m17), &TYPE::m17>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m18), &TYPE::m18>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<18, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m19), &TYPE::m19>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<19, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m20), &TYPE::m20>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<20, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m21), &TYPE::m21>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<21, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m22), &TYPE::m22>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<22, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m23), &TYPE::m23>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<23, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m24), &TYPE::m24>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<24, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m25), &TYPE::m25>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<25, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m26), &TYPE::m26>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<26, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m27), &TYPE::m27>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<27, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m28), &TYPE::m28>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<28, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m29), &TYPE::m29>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<29, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m30), &TYPE::m30>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<30, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m31), &TYPE::m31>{})\
                );                                                                                \
            }                                                                                     \
        };                                                                                        \
    }}                                                                                            \
/**/

#define BOOST_HANA_ADAPT_STRUCT_IMPL_33(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21, m22, m23, m24, m25, m26, m27, m28, m29, m30, m31, m32)    \
    namespace boost { namespace hana {                                                            \
        template <>                                                                               \
        struct accessors_impl<TYPE> {                                                             \
            static constexpr auto apply() {                                                       \
                struct member_names {                                                             \
                  static constexpr auto get() {                                                   \
                      return ::boost::hana::make_tuple(                                           \
                          BOOST_HANA_PP_STRINGIZE(m1), BOOST_HANA_PP_STRINGIZE(m2), BOOST_HANA_PP_STRINGIZE(m3), BOOST_HANA_PP_STRINGIZE(m4), BOOST_HANA_PP_STRINGIZE(m5), BOOST_HANA_PP_STRINGIZE(m6), BOOST_HANA_PP_STRINGIZE(m7), BOOST_HANA_PP_STRINGIZE(m8), BOOST_HANA_PP_STRINGIZE(m9), BOOST_HANA_PP_STRINGIZE(m10), BOOST_HANA_PP_STRINGIZE(m11), BOOST_HANA_PP_STRINGIZE(m12), BOOST_HANA_PP_STRINGIZE(m13), BOOST_HANA_PP_STRINGIZE(m14), BOOST_HANA_PP_STRINGIZE(m15), BOOST_HANA_PP_STRINGIZE(m16), BOOST_HANA_PP_STRINGIZE(m17), BOOST_HANA_PP_STRINGIZE(m18), BOOST_HANA_PP_STRINGIZE(m19), BOOST_HANA_PP_STRINGIZE(m20), BOOST_HANA_PP_STRINGIZE(m21), BOOST_HANA_PP_STRINGIZE(m22), BOOST_HANA_PP_STRINGIZE(m23), BOOST_HANA_PP_STRINGIZE(m24), BOOST_HANA_PP_STRINGIZE(m25), BOOST_HANA_PP_STRINGIZE(m26), BOOST_HANA_PP_STRINGIZE(m27), BOOST_HANA_PP_STRINGIZE(m28), BOOST_HANA_PP_STRINGIZE(m29), BOOST_HANA_PP_STRINGIZE(m30), BOOST_HANA_PP_STRINGIZE(m31), BOOST_HANA_PP_STRINGIZE(m32)   \
                      );                                                                          \
                  }                                                                               \
                };                                                                                \
                return ::boost::hana::make_tuple(                                                 \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m1), &TYPE::m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m2), &TYPE::m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m3), &TYPE::m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m4), &TYPE::m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m5), &TYPE::m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m6), &TYPE::m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m7), &TYPE::m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m8), &TYPE::m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m9), &TYPE::m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m10), &TYPE::m10>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m11), &TYPE::m11>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m12), &TYPE::m12>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m13), &TYPE::m13>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m14), &TYPE::m14>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m15), &TYPE::m15>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m16), &TYPE::m16>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m17), &TYPE::m17>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m18), &TYPE::m18>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<18, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m19), &TYPE::m19>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<19, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m20), &TYPE::m20>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<20, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m21), &TYPE::m21>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<21, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m22), &TYPE::m22>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<22, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m23), &TYPE::m23>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<23, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m24), &TYPE::m24>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<24, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m25), &TYPE::m25>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<25, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m26), &TYPE::m26>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<26, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m27), &TYPE::m27>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<27, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m28), &TYPE::m28>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<28, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m29), &TYPE::m29>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<29, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m30), &TYPE::m30>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<30, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m31), &TYPE::m31>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<31, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m32), &TYPE::m32>{})\
                );                                                                                \
            }                                                                                     \
        };                                                                                        \
    }}                                                                                            \
/**/

#define BOOST_HANA_ADAPT_STRUCT_IMPL_34(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21, m22, m23, m24, m25, m26, m27, m28, m29, m30, m31, m32, m33)    \
    namespace boost { namespace hana {                                                            \
        template <>                                                                               \
        struct accessors_impl<TYPE> {                                                             \
            static constexpr auto apply() {                                                       \
                struct member_names {                                                             \
                  static constexpr auto get() {                                                   \
                      return ::boost::hana::make_tuple(                                           \
                          BOOST_HANA_PP_STRINGIZE(m1), BOOST_HANA_PP_STRINGIZE(m2), BOOST_HANA_PP_STRINGIZE(m3), BOOST_HANA_PP_STRINGIZE(m4), BOOST_HANA_PP_STRINGIZE(m5), BOOST_HANA_PP_STRINGIZE(m6), BOOST_HANA_PP_STRINGIZE(m7), BOOST_HANA_PP_STRINGIZE(m8), BOOST_HANA_PP_STRINGIZE(m9), BOOST_HANA_PP_STRINGIZE(m10), BOOST_HANA_PP_STRINGIZE(m11), BOOST_HANA_PP_STRINGIZE(m12), BOOST_HANA_PP_STRINGIZE(m13), BOOST_HANA_PP_STRINGIZE(m14), BOOST_HANA_PP_STRINGIZE(m15), BOOST_HANA_PP_STRINGIZE(m16), BOOST_HANA_PP_STRINGIZE(m17), BOOST_HANA_PP_STRINGIZE(m18), BOOST_HANA_PP_STRINGIZE(m19), BOOST_HANA_PP_STRINGIZE(m20), BOOST_HANA_PP_STRINGIZE(m21), BOOST_HANA_PP_STRINGIZE(m22), BOOST_HANA_PP_STRINGIZE(m23), BOOST_HANA_PP_STRINGIZE(m24), BOOST_HANA_PP_STRINGIZE(m25), BOOST_HANA_PP_STRINGIZE(m26), BOOST_HANA_PP_STRINGIZE(m27), BOOST_HANA_PP_STRINGIZE(m28), BOOST_HANA_PP_STRINGIZE(m29), BOOST_HANA_PP_STRINGIZE(m30), BOOST_HANA_PP_STRINGIZE(m31), BOOST_HANA_PP_STRINGIZE(m32), BOOST_HANA_PP_STRINGIZE(m33)   \
                      );                                                                          \
                  }                                                                               \
                };                                                                                \
                return ::boost::hana::make_tuple(                                                 \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m1), &TYPE::m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m2), &TYPE::m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m3), &TYPE::m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m4), &TYPE::m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m5), &TYPE::m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m6), &TYPE::m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m7), &TYPE::m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m8), &TYPE::m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m9), &TYPE::m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m10), &TYPE::m10>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m11), &TYPE::m11>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m12), &TYPE::m12>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m13), &TYPE::m13>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m14), &TYPE::m14>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m15), &TYPE::m15>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m16), &TYPE::m16>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m17), &TYPE::m17>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m18), &TYPE::m18>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<18, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m19), &TYPE::m19>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<19, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m20), &TYPE::m20>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<20, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m21), &TYPE::m21>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<21, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m22), &TYPE::m22>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<22, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m23), &TYPE::m23>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<23, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m24), &TYPE::m24>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<24, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m25), &TYPE::m25>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<25, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m26), &TYPE::m26>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<26, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m27), &TYPE::m27>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<27, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m28), &TYPE::m28>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<28, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m29), &TYPE::m29>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<29, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m30), &TYPE::m30>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<30, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m31), &TYPE::m31>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<31, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m32), &TYPE::m32>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<32, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m33), &TYPE::m33>{})\
                );                                                                                \
            }                                                                                     \
        };                                                                                        \
    }}                                                                                            \
/**/

#define BOOST_HANA_ADAPT_STRUCT_IMPL_35(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21, m22, m23, m24, m25, m26, m27, m28, m29, m30, m31, m32, m33, m34)    \
    namespace boost { namespace hana {                                                            \
        template <>                                                                               \
        struct accessors_impl<TYPE> {                                                             \
            static constexpr auto apply() {                                                       \
                struct member_names {                                                             \
                  static constexpr auto get() {                                                   \
                      return ::boost::hana::make_tuple(                                           \
                          BOOST_HANA_PP_STRINGIZE(m1), BOOST_HANA_PP_STRINGIZE(m2), BOOST_HANA_PP_STRINGIZE(m3), BOOST_HANA_PP_STRINGIZE(m4), BOOST_HANA_PP_STRINGIZE(m5), BOOST_HANA_PP_STRINGIZE(m6), BOOST_HANA_PP_STRINGIZE(m7), BOOST_HANA_PP_STRINGIZE(m8), BOOST_HANA_PP_STRINGIZE(m9), BOOST_HANA_PP_STRINGIZE(m10), BOOST_HANA_PP_STRINGIZE(m11), BOOST_HANA_PP_STRINGIZE(m12), BOOST_HANA_PP_STRINGIZE(m13), BOOST_HANA_PP_STRINGIZE(m14), BOOST_HANA_PP_STRINGIZE(m15), BOOST_HANA_PP_STRINGIZE(m16), BOOST_HANA_PP_STRINGIZE(m17), BOOST_HANA_PP_STRINGIZE(m18), BOOST_HANA_PP_STRINGIZE(m19), BOOST_HANA_PP_STRINGIZE(m20), BOOST_HANA_PP_STRINGIZE(m21), BOOST_HANA_PP_STRINGIZE(m22), BOOST_HANA_PP_STRINGIZE(m23), BOOST_HANA_PP_STRINGIZE(m24), BOOST_HANA_PP_STRINGIZE(m25), BOOST_HANA_PP_STRINGIZE(m26), BOOST_HANA_PP_STRINGIZE(m27), BOOST_HANA_PP_STRINGIZE(m28), BOOST_HANA_PP_STRINGIZE(m29), BOOST_HANA_PP_STRINGIZE(m30), BOOST_HANA_PP_STRINGIZE(m31), BOOST_HANA_PP_STRINGIZE(m32), BOOST_HANA_PP_STRINGIZE(m33), BOOST_HANA_PP_STRINGIZE(m34)   \
                      );                                                                          \
                  }                                                                               \
                };                                                                                \
                return ::boost::hana::make_tuple(                                                 \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m1), &TYPE::m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m2), &TYPE::m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m3), &TYPE::m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m4), &TYPE::m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m5), &TYPE::m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m6), &TYPE::m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m7), &TYPE::m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m8), &TYPE::m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m9), &TYPE::m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m10), &TYPE::m10>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m11), &TYPE::m11>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m12), &TYPE::m12>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m13), &TYPE::m13>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m14), &TYPE::m14>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m15), &TYPE::m15>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m16), &TYPE::m16>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m17), &TYPE::m17>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m18), &TYPE::m18>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<18, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m19), &TYPE::m19>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<19, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m20), &TYPE::m20>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<20, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m21), &TYPE::m21>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<21, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m22), &TYPE::m22>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<22, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m23), &TYPE::m23>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<23, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m24), &TYPE::m24>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<24, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m25), &TYPE::m25>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<25, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m26), &TYPE::m26>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<26, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m27), &TYPE::m27>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<27, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m28), &TYPE::m28>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<28, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m29), &TYPE::m29>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<29, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m30), &TYPE::m30>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<30, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m31), &TYPE::m31>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<31, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m32), &TYPE::m32>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<32, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m33), &TYPE::m33>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<33, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m34), &TYPE::m34>{})\
                );                                                                                \
            }                                                                                     \
        };                                                                                        \
    }}                                                                                            \
/**/

#define BOOST_HANA_ADAPT_STRUCT_IMPL_36(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21, m22, m23, m24, m25, m26, m27, m28, m29, m30, m31, m32, m33, m34, m35)    \
    namespace boost { namespace hana {                                                            \
        template <>                                                                               \
        struct accessors_impl<TYPE> {                                                             \
            static constexpr auto apply() {                                                       \
                struct member_names {                                                             \
                  static constexpr auto get() {                                                   \
                      return ::boost::hana::make_tuple(                                           \
                          BOOST_HANA_PP_STRINGIZE(m1), BOOST_HANA_PP_STRINGIZE(m2), BOOST_HANA_PP_STRINGIZE(m3), BOOST_HANA_PP_STRINGIZE(m4), BOOST_HANA_PP_STRINGIZE(m5), BOOST_HANA_PP_STRINGIZE(m6), BOOST_HANA_PP_STRINGIZE(m7), BOOST_HANA_PP_STRINGIZE(m8), BOOST_HANA_PP_STRINGIZE(m9), BOOST_HANA_PP_STRINGIZE(m10), BOOST_HANA_PP_STRINGIZE(m11), BOOST_HANA_PP_STRINGIZE(m12), BOOST_HANA_PP_STRINGIZE(m13), BOOST_HANA_PP_STRINGIZE(m14), BOOST_HANA_PP_STRINGIZE(m15), BOOST_HANA_PP_STRINGIZE(m16), BOOST_HANA_PP_STRINGIZE(m17), BOOST_HANA_PP_STRINGIZE(m18), BOOST_HANA_PP_STRINGIZE(m19), BOOST_HANA_PP_STRINGIZE(m20), BOOST_HANA_PP_STRINGIZE(m21), BOOST_HANA_PP_STRINGIZE(m22), BOOST_HANA_PP_STRINGIZE(m23), BOOST_HANA_PP_STRINGIZE(m24), BOOST_HANA_PP_STRINGIZE(m25), BOOST_HANA_PP_STRINGIZE(m26), BOOST_HANA_PP_STRINGIZE(m27), BOOST_HANA_PP_STRINGIZE(m28), BOOST_HANA_PP_STRINGIZE(m29), BOOST_HANA_PP_STRINGIZE(m30), BOOST_HANA_PP_STRINGIZE(m31), BOOST_HANA_PP_STRINGIZE(m32), BOOST_HANA_PP_STRINGIZE(m33), BOOST_HANA_PP_STRINGIZE(m34), BOOST_HANA_PP_STRINGIZE(m35)   \
                      );                                                                          \
                  }                                                                               \
                };                                                                                \
                return ::boost::hana::make_tuple(                                                 \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m1), &TYPE::m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m2), &TYPE::m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m3), &TYPE::m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m4), &TYPE::m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m5), &TYPE::m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m6), &TYPE::m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m7), &TYPE::m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m8), &TYPE::m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m9), &TYPE::m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m10), &TYPE::m10>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m11), &TYPE::m11>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m12), &TYPE::m12>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m13), &TYPE::m13>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m14), &TYPE::m14>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m15), &TYPE::m15>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m16), &TYPE::m16>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m17), &TYPE::m17>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m18), &TYPE::m18>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<18, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m19), &TYPE::m19>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<19, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m20), &TYPE::m20>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<20, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m21), &TYPE::m21>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<21, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m22), &TYPE::m22>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<22, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m23), &TYPE::m23>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<23, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m24), &TYPE::m24>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<24, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m25), &TYPE::m25>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<25, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m26), &TYPE::m26>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<26, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m27), &TYPE::m27>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<27, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m28), &TYPE::m28>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<28, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m29), &TYPE::m29>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<29, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m30), &TYPE::m30>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<30, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m31), &TYPE::m31>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<31, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m32), &TYPE::m32>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<32, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m33), &TYPE::m33>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<33, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m34), &TYPE::m34>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<34, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m35), &TYPE::m35>{})\
                );                                                                                \
            }                                                                                     \
        };                                                                                        \
    }}                                                                                            \
/**/

#define BOOST_HANA_ADAPT_STRUCT_IMPL_37(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21, m22, m23, m24, m25, m26, m27, m28, m29, m30, m31, m32, m33, m34, m35, m36)    \
    namespace boost { namespace hana {                                                            \
        template <>                                                                               \
        struct accessors_impl<TYPE> {                                                             \
            static constexpr auto apply() {                                                       \
                struct member_names {                                                             \
                  static constexpr auto get() {                                                   \
                      return ::boost::hana::make_tuple(                                           \
                          BOOST_HANA_PP_STRINGIZE(m1), BOOST_HANA_PP_STRINGIZE(m2), BOOST_HANA_PP_STRINGIZE(m3), BOOST_HANA_PP_STRINGIZE(m4), BOOST_HANA_PP_STRINGIZE(m5), BOOST_HANA_PP_STRINGIZE(m6), BOOST_HANA_PP_STRINGIZE(m7), BOOST_HANA_PP_STRINGIZE(m8), BOOST_HANA_PP_STRINGIZE(m9), BOOST_HANA_PP_STRINGIZE(m10), BOOST_HANA_PP_STRINGIZE(m11), BOOST_HANA_PP_STRINGIZE(m12), BOOST_HANA_PP_STRINGIZE(m13), BOOST_HANA_PP_STRINGIZE(m14), BOOST_HANA_PP_STRINGIZE(m15), BOOST_HANA_PP_STRINGIZE(m16), BOOST_HANA_PP_STRINGIZE(m17), BOOST_HANA_PP_STRINGIZE(m18), BOOST_HANA_PP_STRINGIZE(m19), BOOST_HANA_PP_STRINGIZE(m20), BOOST_HANA_PP_STRINGIZE(m21), BOOST_HANA_PP_STRINGIZE(m22), BOOST_HANA_PP_STRINGIZE(m23), BOOST_HANA_PP_STRINGIZE(m24), BOOST_HANA_PP_STRINGIZE(m25), BOOST_HANA_PP_STRINGIZE(m26), BOOST_HANA_PP_STRINGIZE(m27), BOOST_HANA_PP_STRINGIZE(m28), BOOST_HANA_PP_STRINGIZE(m29), BOOST_HANA_PP_STRINGIZE(m30), BOOST_HANA_PP_STRINGIZE(m31), BOOST_HANA_PP_STRINGIZE(m32), BOOST_HANA_PP_STRINGIZE(m33), BOOST_HANA_PP_STRINGIZE(m34), BOOST_HANA_PP_STRINGIZE(m35), BOOST_HANA_PP_STRINGIZE(m36)   \
                      );                                                                          \
                  }                                                                               \
                };                                                                                \
                return ::boost::hana::make_tuple(                                                 \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m1), &TYPE::m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m2), &TYPE::m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m3), &TYPE::m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m4), &TYPE::m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m5), &TYPE::m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m6), &TYPE::m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m7), &TYPE::m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m8), &TYPE::m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m9), &TYPE::m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m10), &TYPE::m10>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m11), &TYPE::m11>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m12), &TYPE::m12>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m13), &TYPE::m13>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m14), &TYPE::m14>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m15), &TYPE::m15>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m16), &TYPE::m16>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m17), &TYPE::m17>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m18), &TYPE::m18>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<18, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m19), &TYPE::m19>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<19, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m20), &TYPE::m20>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<20, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m21), &TYPE::m21>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<21, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m22), &TYPE::m22>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<22, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m23), &TYPE::m23>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<23, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m24), &TYPE::m24>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<24, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m25), &TYPE::m25>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<25, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m26), &TYPE::m26>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<26, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m27), &TYPE::m27>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<27, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m28), &TYPE::m28>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<28, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m29), &TYPE::m29>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<29, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m30), &TYPE::m30>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<30, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m31), &TYPE::m31>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<31, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m32), &TYPE::m32>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<32, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m33), &TYPE::m33>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<33, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m34), &TYPE::m34>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<34, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m35), &TYPE::m35>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<35, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m36), &TYPE::m36>{})\
                );                                                                                \
            }                                                                                     \
        };                                                                                        \
    }}                                                                                            \
/**/

#define BOOST_HANA_ADAPT_STRUCT_IMPL_38(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21, m22, m23, m24, m25, m26, m27, m28, m29, m30, m31, m32, m33, m34, m35, m36, m37)    \
    namespace boost { namespace hana {                                                            \
        template <>                                                                               \
        struct accessors_impl<TYPE> {                                                             \
            static constexpr auto apply() {                                                       \
                struct member_names {                                                             \
                  static constexpr auto get() {                                                   \
                      return ::boost::hana::make_tuple(                                           \
                          BOOST_HANA_PP_STRINGIZE(m1), BOOST_HANA_PP_STRINGIZE(m2), BOOST_HANA_PP_STRINGIZE(m3), BOOST_HANA_PP_STRINGIZE(m4), BOOST_HANA_PP_STRINGIZE(m5), BOOST_HANA_PP_STRINGIZE(m6), BOOST_HANA_PP_STRINGIZE(m7), BOOST_HANA_PP_STRINGIZE(m8), BOOST_HANA_PP_STRINGIZE(m9), BOOST_HANA_PP_STRINGIZE(m10), BOOST_HANA_PP_STRINGIZE(m11), BOOST_HANA_PP_STRINGIZE(m12), BOOST_HANA_PP_STRINGIZE(m13), BOOST_HANA_PP_STRINGIZE(m14), BOOST_HANA_PP_STRINGIZE(m15), BOOST_HANA_PP_STRINGIZE(m16), BOOST_HANA_PP_STRINGIZE(m17), BOOST_HANA_PP_STRINGIZE(m18), BOOST_HANA_PP_STRINGIZE(m19), BOOST_HANA_PP_STRINGIZE(m20), BOOST_HANA_PP_STRINGIZE(m21), BOOST_HANA_PP_STRINGIZE(m22), BOOST_HANA_PP_STRINGIZE(m23), BOOST_HANA_PP_STRINGIZE(m24), BOOST_HANA_PP_STRINGIZE(m25), BOOST_HANA_PP_STRINGIZE(m26), BOOST_HANA_PP_STRINGIZE(m27), BOOST_HANA_PP_STRINGIZE(m28), BOOST_HANA_PP_STRINGIZE(m29), BOOST_HANA_PP_STRINGIZE(m30), BOOST_HANA_PP_STRINGIZE(m31), BOOST_HANA_PP_STRINGIZE(m32), BOOST_HANA_PP_STRINGIZE(m33), BOOST_HANA_PP_STRINGIZE(m34), BOOST_HANA_PP_STRINGIZE(m35), BOOST_HANA_PP_STRINGIZE(m36), BOOST_HANA_PP_STRINGIZE(m37)   \
                      );                                                                          \
                  }                                                                               \
                };                                                                                \
                return ::boost::hana::make_tuple(                                                 \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m1), &TYPE::m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m2), &TYPE::m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m3), &TYPE::m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m4), &TYPE::m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m5), &TYPE::m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m6), &TYPE::m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m7), &TYPE::m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m8), &TYPE::m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m9), &TYPE::m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m10), &TYPE::m10>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m11), &TYPE::m11>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m12), &TYPE::m12>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m13), &TYPE::m13>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m14), &TYPE::m14>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m15), &TYPE::m15>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m16), &TYPE::m16>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m17), &TYPE::m17>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m18), &TYPE::m18>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<18, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m19), &TYPE::m19>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<19, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m20), &TYPE::m20>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<20, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m21), &TYPE::m21>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<21, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m22), &TYPE::m22>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<22, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m23), &TYPE::m23>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<23, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m24), &TYPE::m24>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<24, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m25), &TYPE::m25>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<25, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m26), &TYPE::m26>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<26, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m27), &TYPE::m27>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<27, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m28), &TYPE::m28>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<28, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m29), &TYPE::m29>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<29, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m30), &TYPE::m30>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<30, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m31), &TYPE::m31>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<31, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m32), &TYPE::m32>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<32, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m33), &TYPE::m33>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<33, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m34), &TYPE::m34>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<34, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m35), &TYPE::m35>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<35, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m36), &TYPE::m36>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<36, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m37), &TYPE::m37>{})\
                );                                                                                \
            }                                                                                     \
        };                                                                                        \
    }}                                                                                            \
/**/

#define BOOST_HANA_ADAPT_STRUCT_IMPL_39(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21, m22, m23, m24, m25, m26, m27, m28, m29, m30, m31, m32, m33, m34, m35, m36, m37, m38)    \
    namespace boost { namespace hana {                                                            \
        template <>                                                                               \
        struct accessors_impl<TYPE> {                                                             \
            static constexpr auto apply() {                                                       \
                struct member_names {                                                             \
                  static constexpr auto get() {                                                   \
                      return ::boost::hana::make_tuple(                                           \
                          BOOST_HANA_PP_STRINGIZE(m1), BOOST_HANA_PP_STRINGIZE(m2), BOOST_HANA_PP_STRINGIZE(m3), BOOST_HANA_PP_STRINGIZE(m4), BOOST_HANA_PP_STRINGIZE(m5), BOOST_HANA_PP_STRINGIZE(m6), BOOST_HANA_PP_STRINGIZE(m7), BOOST_HANA_PP_STRINGIZE(m8), BOOST_HANA_PP_STRINGIZE(m9), BOOST_HANA_PP_STRINGIZE(m10), BOOST_HANA_PP_STRINGIZE(m11), BOOST_HANA_PP_STRINGIZE(m12), BOOST_HANA_PP_STRINGIZE(m13), BOOST_HANA_PP_STRINGIZE(m14), BOOST_HANA_PP_STRINGIZE(m15), BOOST_HANA_PP_STRINGIZE(m16), BOOST_HANA_PP_STRINGIZE(m17), BOOST_HANA_PP_STRINGIZE(m18), BOOST_HANA_PP_STRINGIZE(m19), BOOST_HANA_PP_STRINGIZE(m20), BOOST_HANA_PP_STRINGIZE(m21), BOOST_HANA_PP_STRINGIZE(m22), BOOST_HANA_PP_STRINGIZE(m23), BOOST_HANA_PP_STRINGIZE(m24), BOOST_HANA_PP_STRINGIZE(m25), BOOST_HANA_PP_STRINGIZE(m26), BOOST_HANA_PP_STRINGIZE(m27), BOOST_HANA_PP_STRINGIZE(m28), BOOST_HANA_PP_STRINGIZE(m29), BOOST_HANA_PP_STRINGIZE(m30), BOOST_HANA_PP_STRINGIZE(m31), BOOST_HANA_PP_STRINGIZE(m32), BOOST_HANA_PP_STRINGIZE(m33), BOOST_HANA_PP_STRINGIZE(m34), BOOST_HANA_PP_STRINGIZE(m35), BOOST_HANA_PP_STRINGIZE(m36), BOOST_HANA_PP_STRINGIZE(m37), BOOST_HANA_PP_STRINGIZE(m38)   \
                      );                                                                          \
                  }                                                                               \
                };                                                                                \
                return ::boost::hana::make_tuple(                                                 \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m1), &TYPE::m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m2), &TYPE::m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m3), &TYPE::m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m4), &TYPE::m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m5), &TYPE::m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m6), &TYPE::m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m7), &TYPE::m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m8), &TYPE::m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m9), &TYPE::m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m10), &TYPE::m10>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m11), &TYPE::m11>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m12), &TYPE::m12>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m13), &TYPE::m13>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m14), &TYPE::m14>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m15), &TYPE::m15>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m16), &TYPE::m16>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m17), &TYPE::m17>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m18), &TYPE::m18>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<18, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m19), &TYPE::m19>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<19, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m20), &TYPE::m20>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<20, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m21), &TYPE::m21>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<21, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m22), &TYPE::m22>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<22, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m23), &TYPE::m23>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<23, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m24), &TYPE::m24>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<24, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m25), &TYPE::m25>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<25, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m26), &TYPE::m26>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<26, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m27), &TYPE::m27>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<27, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m28), &TYPE::m28>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<28, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m29), &TYPE::m29>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<29, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m30), &TYPE::m30>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<30, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m31), &TYPE::m31>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<31, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m32), &TYPE::m32>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<32, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m33), &TYPE::m33>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<33, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m34), &TYPE::m34>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<34, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m35), &TYPE::m35>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<35, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m36), &TYPE::m36>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<36, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m37), &TYPE::m37>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<37, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m38), &TYPE::m38>{})\
                );                                                                                \
            }                                                                                     \
        };                                                                                        \
    }}                                                                                            \
/**/

#define BOOST_HANA_ADAPT_STRUCT_IMPL_40(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21, m22, m23, m24, m25, m26, m27, m28, m29, m30, m31, m32, m33, m34, m35, m36, m37, m38, m39)    \
    namespace boost { namespace hana {                                                            \
        template <>                                                                               \
        struct accessors_impl<TYPE> {                                                             \
            static constexpr auto apply() {                                                       \
                struct member_names {                                                             \
                  static constexpr auto get() {                                                   \
                      return ::boost::hana::make_tuple(                                           \
                          BOOST_HANA_PP_STRINGIZE(m1), BOOST_HANA_PP_STRINGIZE(m2), BOOST_HANA_PP_STRINGIZE(m3), BOOST_HANA_PP_STRINGIZE(m4), BOOST_HANA_PP_STRINGIZE(m5), BOOST_HANA_PP_STRINGIZE(m6), BOOST_HANA_PP_STRINGIZE(m7), BOOST_HANA_PP_STRINGIZE(m8), BOOST_HANA_PP_STRINGIZE(m9), BOOST_HANA_PP_STRINGIZE(m10), BOOST_HANA_PP_STRINGIZE(m11), BOOST_HANA_PP_STRINGIZE(m12), BOOST_HANA_PP_STRINGIZE(m13), BOOST_HANA_PP_STRINGIZE(m14), BOOST_HANA_PP_STRINGIZE(m15), BOOST_HANA_PP_STRINGIZE(m16), BOOST_HANA_PP_STRINGIZE(m17), BOOST_HANA_PP_STRINGIZE(m18), BOOST_HANA_PP_STRINGIZE(m19), BOOST_HANA_PP_STRINGIZE(m20), BOOST_HANA_PP_STRINGIZE(m21), BOOST_HANA_PP_STRINGIZE(m22), BOOST_HANA_PP_STRINGIZE(m23), BOOST_HANA_PP_STRINGIZE(m24), BOOST_HANA_PP_STRINGIZE(m25), BOOST_HANA_PP_STRINGIZE(m26), BOOST_HANA_PP_STRINGIZE(m27), BOOST_HANA_PP_STRINGIZE(m28), BOOST_HANA_PP_STRINGIZE(m29), BOOST_HANA_PP_STRINGIZE(m30), BOOST_HANA_PP_STRINGIZE(m31), BOOST_HANA_PP_STRINGIZE(m32), BOOST_HANA_PP_STRINGIZE(m33), BOOST_HANA_PP_STRINGIZE(m34), BOOST_HANA_PP_STRINGIZE(m35), BOOST_HANA_PP_STRINGIZE(m36), BOOST_HANA_PP_STRINGIZE(m37), BOOST_HANA_PP_STRINGIZE(m38), BOOST_HANA_PP_STRINGIZE(m39)   \
                      );                                                                          \
                  }                                                                               \
                };                                                                                \
                return ::boost::hana::make_tuple(                                                 \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m1), &TYPE::m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m2), &TYPE::m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m3), &TYPE::m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m4), &TYPE::m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m5), &TYPE::m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m6), &TYPE::m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m7), &TYPE::m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m8), &TYPE::m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m9), &TYPE::m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m10), &TYPE::m10>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m11), &TYPE::m11>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m12), &TYPE::m12>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m13), &TYPE::m13>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m14), &TYPE::m14>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m15), &TYPE::m15>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m16), &TYPE::m16>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m17), &TYPE::m17>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m18), &TYPE::m18>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<18, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m19), &TYPE::m19>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<19, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m20), &TYPE::m20>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<20, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m21), &TYPE::m21>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<21, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m22), &TYPE::m22>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<22, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m23), &TYPE::m23>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<23, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m24), &TYPE::m24>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<24, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m25), &TYPE::m25>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<25, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m26), &TYPE::m26>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<26, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m27), &TYPE::m27>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<27, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m28), &TYPE::m28>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<28, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m29), &TYPE::m29>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<29, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m30), &TYPE::m30>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<30, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m31), &TYPE::m31>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<31, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m32), &TYPE::m32>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<32, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m33), &TYPE::m33>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<33, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m34), &TYPE::m34>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<34, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m35), &TYPE::m35>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<35, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m36), &TYPE::m36>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<36, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m37), &TYPE::m37>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<37, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m38), &TYPE::m38>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<38, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m39), &TYPE::m39>{})\
                );                                                                                \
            }                                                                                     \
        };                                                                                        \
    }}                                                                                            \
/**/

#define BOOST_HANA_ADAPT_STRUCT_IMPL_41(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21, m22, m23, m24, m25, m26, m27, m28, m29, m30, m31, m32, m33, m34, m35, m36, m37, m38, m39, m40)    \
    namespace boost { namespace hana {                                                            \
        template <>                                                                               \
        struct accessors_impl<TYPE> {                                                             \
            static constexpr auto apply() {                                                       \
                struct member_names {                                                             \
                  static constexpr auto get() {                                                   \
                      return ::boost::hana::make_tuple(                                           \
                          BOOST_HANA_PP_STRINGIZE(m1), BOOST_HANA_PP_STRINGIZE(m2), BOOST_HANA_PP_STRINGIZE(m3), BOOST_HANA_PP_STRINGIZE(m4), BOOST_HANA_PP_STRINGIZE(m5), BOOST_HANA_PP_STRINGIZE(m6), BOOST_HANA_PP_STRINGIZE(m7), BOOST_HANA_PP_STRINGIZE(m8), BOOST_HANA_PP_STRINGIZE(m9), BOOST_HANA_PP_STRINGIZE(m10), BOOST_HANA_PP_STRINGIZE(m11), BOOST_HANA_PP_STRINGIZE(m12), BOOST_HANA_PP_STRINGIZE(m13), BOOST_HANA_PP_STRINGIZE(m14), BOOST_HANA_PP_STRINGIZE(m15), BOOST_HANA_PP_STRINGIZE(m16), BOOST_HANA_PP_STRINGIZE(m17), BOOST_HANA_PP_STRINGIZE(m18), BOOST_HANA_PP_STRINGIZE(m19), BOOST_HANA_PP_STRINGIZE(m20), BOOST_HANA_PP_STRINGIZE(m21), BOOST_HANA_PP_STRINGIZE(m22), BOOST_HANA_PP_STRINGIZE(m23), BOOST_HANA_PP_STRINGIZE(m24), BOOST_HANA_PP_STRINGIZE(m25), BOOST_HANA_PP_STRINGIZE(m26), BOOST_HANA_PP_STRINGIZE(m27), BOOST_HANA_PP_STRINGIZE(m28), BOOST_HANA_PP_STRINGIZE(m29), BOOST_HANA_PP_STRINGIZE(m30), BOOST_HANA_PP_STRINGIZE(m31), BOOST_HANA_PP_STRINGIZE(m32), BOOST_HANA_PP_STRINGIZE(m33), BOOST_HANA_PP_STRINGIZE(m34), BOOST_HANA_PP_STRINGIZE(m35), BOOST_HANA_PP_STRINGIZE(m36), BOOST_HANA_PP_STRINGIZE(m37), BOOST_HANA_PP_STRINGIZE(m38), BOOST_HANA_PP_STRINGIZE(m39), BOOST_HANA_PP_STRINGIZE(m40)   \
                      );                                                                          \
                  }                                                                               \
                };                                                                                \
                return ::boost::hana::make_tuple(                                                 \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m1), &TYPE::m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m2), &TYPE::m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m3), &TYPE::m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m4), &TYPE::m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m5), &TYPE::m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m6), &TYPE::m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m7), &TYPE::m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m8), &TYPE::m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m9), &TYPE::m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m10), &TYPE::m10>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m11), &TYPE::m11>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m12), &TYPE::m12>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m13), &TYPE::m13>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m14), &TYPE::m14>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m15), &TYPE::m15>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m16), &TYPE::m16>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m17), &TYPE::m17>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m18), &TYPE::m18>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<18, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m19), &TYPE::m19>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<19, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m20), &TYPE::m20>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<20, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m21), &TYPE::m21>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<21, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m22), &TYPE::m22>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<22, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m23), &TYPE::m23>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<23, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m24), &TYPE::m24>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<24, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m25), &TYPE::m25>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<25, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m26), &TYPE::m26>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<26, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m27), &TYPE::m27>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<27, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m28), &TYPE::m28>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<28, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m29), &TYPE::m29>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<29, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m30), &TYPE::m30>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<30, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m31), &TYPE::m31>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<31, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m32), &TYPE::m32>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<32, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m33), &TYPE::m33>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<33, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m34), &TYPE::m34>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<34, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m35), &TYPE::m35>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<35, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m36), &TYPE::m36>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<36, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m37), &TYPE::m37>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<37, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m38), &TYPE::m38>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<38, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m39), &TYPE::m39>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<39, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m40), &TYPE::m40>{})\
                );                                                                                \
            }                                                                                     \
        };                                                                                        \
    }}                                                                                            \
/**/

#define BOOST_HANA_ADAPT_STRUCT_IMPL_42(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21, m22, m23, m24, m25, m26, m27, m28, m29, m30, m31, m32, m33, m34, m35, m36, m37, m38, m39, m40, m41)    \
    namespace boost { namespace hana {                                                            \
        template <>                                                                               \
        struct accessors_impl<TYPE> {                                                             \
            static constexpr auto apply() {                                                       \
                struct member_names {                                                             \
                  static constexpr auto get() {                                                   \
                      return ::boost::hana::make_tuple(                                           \
                          BOOST_HANA_PP_STRINGIZE(m1), BOOST_HANA_PP_STRINGIZE(m2), BOOST_HANA_PP_STRINGIZE(m3), BOOST_HANA_PP_STRINGIZE(m4), BOOST_HANA_PP_STRINGIZE(m5), BOOST_HANA_PP_STRINGIZE(m6), BOOST_HANA_PP_STRINGIZE(m7), BOOST_HANA_PP_STRINGIZE(m8), BOOST_HANA_PP_STRINGIZE(m9), BOOST_HANA_PP_STRINGIZE(m10), BOOST_HANA_PP_STRINGIZE(m11), BOOST_HANA_PP_STRINGIZE(m12), BOOST_HANA_PP_STRINGIZE(m13), BOOST_HANA_PP_STRINGIZE(m14), BOOST_HANA_PP_STRINGIZE(m15), BOOST_HANA_PP_STRINGIZE(m16), BOOST_HANA_PP_STRINGIZE(m17), BOOST_HANA_PP_STRINGIZE(m18), BOOST_HANA_PP_STRINGIZE(m19), BOOST_HANA_PP_STRINGIZE(m20), BOOST_HANA_PP_STRINGIZE(m21), BOOST_HANA_PP_STRINGIZE(m22), BOOST_HANA_PP_STRINGIZE(m23), BOOST_HANA_PP_STRINGIZE(m24), BOOST_HANA_PP_STRINGIZE(m25), BOOST_HANA_PP_STRINGIZE(m26), BOOST_HANA_PP_STRINGIZE(m27), BOOST_HANA_PP_STRINGIZE(m28), BOOST_HANA_PP_STRINGIZE(m29), BOOST_HANA_PP_STRINGIZE(m30), BOOST_HANA_PP_STRINGIZE(m31), BOOST_HANA_PP_STRINGIZE(m32), BOOST_HANA_PP_STRINGIZE(m33), BOOST_HANA_PP_STRINGIZE(m34), BOOST_HANA_PP_STRINGIZE(m35), BOOST_HANA_PP_STRINGIZE(m36), BOOST_HANA_PP_STRINGIZE(m37), BOOST_HANA_PP_STRINGIZE(m38), BOOST_HANA_PP_STRINGIZE(m39), BOOST_HANA_PP_STRINGIZE(m40), BOOST_HANA_PP_STRINGIZE(m41)   \
                      );                                                                          \
                  }                                                                               \
                };                                                                                \
                return ::boost::hana::make_tuple(                                                 \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m1), &TYPE::m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m2), &TYPE::m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m3), &TYPE::m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m4), &TYPE::m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m5), &TYPE::m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m6), &TYPE::m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m7), &TYPE::m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m8), &TYPE::m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m9), &TYPE::m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m10), &TYPE::m10>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m11), &TYPE::m11>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m12), &TYPE::m12>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m13), &TYPE::m13>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m14), &TYPE::m14>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m15), &TYPE::m15>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m16), &TYPE::m16>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m17), &TYPE::m17>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m18), &TYPE::m18>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<18, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m19), &TYPE::m19>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<19, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m20), &TYPE::m20>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<20, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m21), &TYPE::m21>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<21, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m22), &TYPE::m22>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<22, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m23), &TYPE::m23>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<23, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m24), &TYPE::m24>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<24, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m25), &TYPE::m25>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<25, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m26), &TYPE::m26>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<26, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m27), &TYPE::m27>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<27, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m28), &TYPE::m28>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<28, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m29), &TYPE::m29>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<29, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m30), &TYPE::m30>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<30, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m31), &TYPE::m31>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<31, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m32), &TYPE::m32>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<32, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m33), &TYPE::m33>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<33, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m34), &TYPE::m34>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<34, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m35), &TYPE::m35>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<35, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m36), &TYPE::m36>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<36, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m37), &TYPE::m37>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<37, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m38), &TYPE::m38>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<38, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m39), &TYPE::m39>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<39, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m40), &TYPE::m40>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<40, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m41), &TYPE::m41>{})\
                );                                                                                \
            }                                                                                     \
        };                                                                                        \
    }}                                                                                            \
/**/

#define BOOST_HANA_ADAPT_STRUCT_IMPL_43(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21, m22, m23, m24, m25, m26, m27, m28, m29, m30, m31, m32, m33, m34, m35, m36, m37, m38, m39, m40, m41, m42)    \
    namespace boost { namespace hana {                                                            \
        template <>                                                                               \
        struct accessors_impl<TYPE> {                                                             \
            static constexpr auto apply() {                                                       \
                struct member_names {                                                             \
                  static constexpr auto get() {                                                   \
                      return ::boost::hana::make_tuple(                                           \
                          BOOST_HANA_PP_STRINGIZE(m1), BOOST_HANA_PP_STRINGIZE(m2), BOOST_HANA_PP_STRINGIZE(m3), BOOST_HANA_PP_STRINGIZE(m4), BOOST_HANA_PP_STRINGIZE(m5), BOOST_HANA_PP_STRINGIZE(m6), BOOST_HANA_PP_STRINGIZE(m7), BOOST_HANA_PP_STRINGIZE(m8), BOOST_HANA_PP_STRINGIZE(m9), BOOST_HANA_PP_STRINGIZE(m10), BOOST_HANA_PP_STRINGIZE(m11), BOOST_HANA_PP_STRINGIZE(m12), BOOST_HANA_PP_STRINGIZE(m13), BOOST_HANA_PP_STRINGIZE(m14), BOOST_HANA_PP_STRINGIZE(m15), BOOST_HANA_PP_STRINGIZE(m16), BOOST_HANA_PP_STRINGIZE(m17), BOOST_HANA_PP_STRINGIZE(m18), BOOST_HANA_PP_STRINGIZE(m19), BOOST_HANA_PP_STRINGIZE(m20), BOOST_HANA_PP_STRINGIZE(m21), BOOST_HANA_PP_STRINGIZE(m22), BOOST_HANA_PP_STRINGIZE(m23), BOOST_HANA_PP_STRINGIZE(m24), BOOST_HANA_PP_STRINGIZE(m25), BOOST_HANA_PP_STRINGIZE(m26), BOOST_HANA_PP_STRINGIZE(m27), BOOST_HANA_PP_STRINGIZE(m28), BOOST_HANA_PP_STRINGIZE(m29), BOOST_HANA_PP_STRINGIZE(m30), BOOST_HANA_PP_STRINGIZE(m31), BOOST_HANA_PP_STRINGIZE(m32), BOOST_HANA_PP_STRINGIZE(m33), BOOST_HANA_PP_STRINGIZE(m34), BOOST_HANA_PP_STRINGIZE(m35), BOOST_HANA_PP_STRINGIZE(m36), BOOST_HANA_PP_STRINGIZE(m37), BOOST_HANA_PP_STRINGIZE(m38), BOOST_HANA_PP_STRINGIZE(m39), BOOST_HANA_PP_STRINGIZE(m40), BOOST_HANA_PP_STRINGIZE(m41), BOOST_HANA_PP_STRINGIZE(m42)   \
                      );                                                                          \
                  }                                                                               \
                };                                                                                \
                return ::boost::hana::make_tuple(                                                 \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m1), &TYPE::m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m2), &TYPE::m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m3), &TYPE::m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m4), &TYPE::m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m5), &TYPE::m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m6), &TYPE::m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m7), &TYPE::m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m8), &TYPE::m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m9), &TYPE::m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m10), &TYPE::m10>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m11), &TYPE::m11>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m12), &TYPE::m12>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m13), &TYPE::m13>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m14), &TYPE::m14>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m15), &TYPE::m15>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m16), &TYPE::m16>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m17), &TYPE::m17>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m18), &TYPE::m18>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<18, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m19), &TYPE::m19>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<19, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m20), &TYPE::m20>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<20, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m21), &TYPE::m21>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<21, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m22), &TYPE::m22>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<22, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m23), &TYPE::m23>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<23, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m24), &TYPE::m24>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<24, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m25), &TYPE::m25>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<25, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m26), &TYPE::m26>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<26, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m27), &TYPE::m27>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<27, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m28), &TYPE::m28>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<28, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m29), &TYPE::m29>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<29, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m30), &TYPE::m30>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<30, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m31), &TYPE::m31>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<31, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m32), &TYPE::m32>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<32, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m33), &TYPE::m33>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<33, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m34), &TYPE::m34>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<34, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m35), &TYPE::m35>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<35, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m36), &TYPE::m36>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<36, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m37), &TYPE::m37>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<37, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m38), &TYPE::m38>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<38, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m39), &TYPE::m39>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<39, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m40), &TYPE::m40>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<40, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m41), &TYPE::m41>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<41, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m42), &TYPE::m42>{})\
                );                                                                                \
            }                                                                                     \
        };                                                                                        \
    }}                                                                                            \
/**/

#define BOOST_HANA_ADAPT_STRUCT_IMPL_44(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21, m22, m23, m24, m25, m26, m27, m28, m29, m30, m31, m32, m33, m34, m35, m36, m37, m38, m39, m40, m41, m42, m43)    \
    namespace boost { namespace hana {                                                            \
        template <>                                                                               \
        struct accessors_impl<TYPE> {                                                             \
            static constexpr auto apply() {                                                       \
                struct member_names {                                                             \
                  static constexpr auto get() {                                                   \
                      return ::boost::hana::make_tuple(                                           \
                          BOOST_HANA_PP_STRINGIZE(m1), BOOST_HANA_PP_STRINGIZE(m2), BOOST_HANA_PP_STRINGIZE(m3), BOOST_HANA_PP_STRINGIZE(m4), BOOST_HANA_PP_STRINGIZE(m5), BOOST_HANA_PP_STRINGIZE(m6), BOOST_HANA_PP_STRINGIZE(m7), BOOST_HANA_PP_STRINGIZE(m8), BOOST_HANA_PP_STRINGIZE(m9), BOOST_HANA_PP_STRINGIZE(m10), BOOST_HANA_PP_STRINGIZE(m11), BOOST_HANA_PP_STRINGIZE(m12), BOOST_HANA_PP_STRINGIZE(m13), BOOST_HANA_PP_STRINGIZE(m14), BOOST_HANA_PP_STRINGIZE(m15), BOOST_HANA_PP_STRINGIZE(m16), BOOST_HANA_PP_STRINGIZE(m17), BOOST_HANA_PP_STRINGIZE(m18), BOOST_HANA_PP_STRINGIZE(m19), BOOST_HANA_PP_STRINGIZE(m20), BOOST_HANA_PP_STRINGIZE(m21), BOOST_HANA_PP_STRINGIZE(m22), BOOST_HANA_PP_STRINGIZE(m23), BOOST_HANA_PP_STRINGIZE(m24), BOOST_HANA_PP_STRINGIZE(m25), BOOST_HANA_PP_STRINGIZE(m26), BOOST_HANA_PP_STRINGIZE(m27), BOOST_HANA_PP_STRINGIZE(m28), BOOST_HANA_PP_STRINGIZE(m29), BOOST_HANA_PP_STRINGIZE(m30), BOOST_HANA_PP_STRINGIZE(m31), BOOST_HANA_PP_STRINGIZE(m32), BOOST_HANA_PP_STRINGIZE(m33), BOOST_HANA_PP_STRINGIZE(m34), BOOST_HANA_PP_STRINGIZE(m35), BOOST_HANA_PP_STRINGIZE(m36), BOOST_HANA_PP_STRINGIZE(m37), BOOST_HANA_PP_STRINGIZE(m38), BOOST_HANA_PP_STRINGIZE(m39), BOOST_HANA_PP_STRINGIZE(m40), BOOST_HANA_PP_STRINGIZE(m41), BOOST_HANA_PP_STRINGIZE(m42), BOOST_HANA_PP_STRINGIZE(m43)   \
                      );                                                                          \
                  }                                                                               \
                };                                                                                \
                return ::boost::hana::make_tuple(                                                 \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m1), &TYPE::m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m2), &TYPE::m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m3), &TYPE::m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m4), &TYPE::m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m5), &TYPE::m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m6), &TYPE::m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m7), &TYPE::m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m8), &TYPE::m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m9), &TYPE::m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m10), &TYPE::m10>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m11), &TYPE::m11>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m12), &TYPE::m12>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m13), &TYPE::m13>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m14), &TYPE::m14>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m15), &TYPE::m15>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m16), &TYPE::m16>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m17), &TYPE::m17>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m18), &TYPE::m18>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<18, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m19), &TYPE::m19>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<19, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m20), &TYPE::m20>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<20, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m21), &TYPE::m21>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<21, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m22), &TYPE::m22>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<22, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m23), &TYPE::m23>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<23, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m24), &TYPE::m24>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<24, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m25), &TYPE::m25>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<25, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m26), &TYPE::m26>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<26, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m27), &TYPE::m27>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<27, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m28), &TYPE::m28>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<28, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m29), &TYPE::m29>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<29, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m30), &TYPE::m30>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<30, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m31), &TYPE::m31>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<31, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m32), &TYPE::m32>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<32, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m33), &TYPE::m33>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<33, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m34), &TYPE::m34>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<34, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m35), &TYPE::m35>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<35, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m36), &TYPE::m36>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<36, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m37), &TYPE::m37>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<37, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m38), &TYPE::m38>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<38, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m39), &TYPE::m39>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<39, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m40), &TYPE::m40>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<40, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m41), &TYPE::m41>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<41, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m42), &TYPE::m42>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<42, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m43), &TYPE::m43>{})\
                );                                                                                \
            }                                                                                     \
        };                                                                                        \
    }}                                                                                            \
/**/

#define BOOST_HANA_ADAPT_STRUCT_IMPL_45(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21, m22, m23, m24, m25, m26, m27, m28, m29, m30, m31, m32, m33, m34, m35, m36, m37, m38, m39, m40, m41, m42, m43, m44)    \
    namespace boost { namespace hana {                                                            \
        template <>                                                                               \
        struct accessors_impl<TYPE> {                                                             \
            static constexpr auto apply() {                                                       \
                struct member_names {                                                             \
                  static constexpr auto get() {                                                   \
                      return ::boost::hana::make_tuple(                                           \
                          BOOST_HANA_PP_STRINGIZE(m1), BOOST_HANA_PP_STRINGIZE(m2), BOOST_HANA_PP_STRINGIZE(m3), BOOST_HANA_PP_STRINGIZE(m4), BOOST_HANA_PP_STRINGIZE(m5), BOOST_HANA_PP_STRINGIZE(m6), BOOST_HANA_PP_STRINGIZE(m7), BOOST_HANA_PP_STRINGIZE(m8), BOOST_HANA_PP_STRINGIZE(m9), BOOST_HANA_PP_STRINGIZE(m10), BOOST_HANA_PP_STRINGIZE(m11), BOOST_HANA_PP_STRINGIZE(m12), BOOST_HANA_PP_STRINGIZE(m13), BOOST_HANA_PP_STRINGIZE(m14), BOOST_HANA_PP_STRINGIZE(m15), BOOST_HANA_PP_STRINGIZE(m16), BOOST_HANA_PP_STRINGIZE(m17), BOOST_HANA_PP_STRINGIZE(m18), BOOST_HANA_PP_STRINGIZE(m19), BOOST_HANA_PP_STRINGIZE(m20), BOOST_HANA_PP_STRINGIZE(m21), BOOST_HANA_PP_STRINGIZE(m22), BOOST_HANA_PP_STRINGIZE(m23), BOOST_HANA_PP_STRINGIZE(m24), BOOST_HANA_PP_STRINGIZE(m25), BOOST_HANA_PP_STRINGIZE(m26), BOOST_HANA_PP_STRINGIZE(m27), BOOST_HANA_PP_STRINGIZE(m28), BOOST_HANA_PP_STRINGIZE(m29), BOOST_HANA_PP_STRINGIZE(m30), BOOST_HANA_PP_STRINGIZE(m31), BOOST_HANA_PP_STRINGIZE(m32), BOOST_HANA_PP_STRINGIZE(m33), BOOST_HANA_PP_STRINGIZE(m34), BOOST_HANA_PP_STRINGIZE(m35), BOOST_HANA_PP_STRINGIZE(m36), BOOST_HANA_PP_STRINGIZE(m37), BOOST_HANA_PP_STRINGIZE(m38), BOOST_HANA_PP_STRINGIZE(m39), BOOST_HANA_PP_STRINGIZE(m40), BOOST_HANA_PP_STRINGIZE(m41), BOOST_HANA_PP_STRINGIZE(m42), BOOST_HANA_PP_STRINGIZE(m43), BOOST_HANA_PP_STRINGIZE(m44)   \
                      );                                                                          \
                  }                                                                               \
                };                                                                                \
                return ::boost::hana::make_tuple(                                                 \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m1), &TYPE::m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m2), &TYPE::m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m3), &TYPE::m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m4), &TYPE::m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m5), &TYPE::m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m6), &TYPE::m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m7), &TYPE::m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m8), &TYPE::m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m9), &TYPE::m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m10), &TYPE::m10>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m11), &TYPE::m11>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m12), &TYPE::m12>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m13), &TYPE::m13>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m14), &TYPE::m14>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m15), &TYPE::m15>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m16), &TYPE::m16>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m17), &TYPE::m17>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m18), &TYPE::m18>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<18, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m19), &TYPE::m19>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<19, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m20), &TYPE::m20>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<20, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m21), &TYPE::m21>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<21, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m22), &TYPE::m22>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<22, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m23), &TYPE::m23>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<23, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m24), &TYPE::m24>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<24, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m25), &TYPE::m25>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<25, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m26), &TYPE::m26>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<26, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m27), &TYPE::m27>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<27, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m28), &TYPE::m28>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<28, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m29), &TYPE::m29>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<29, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m30), &TYPE::m30>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<30, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m31), &TYPE::m31>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<31, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m32), &TYPE::m32>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<32, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m33), &TYPE::m33>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<33, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m34), &TYPE::m34>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<34, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m35), &TYPE::m35>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<35, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m36), &TYPE::m36>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<36, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m37), &TYPE::m37>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<37, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m38), &TYPE::m38>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<38, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m39), &TYPE::m39>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<39, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m40), &TYPE::m40>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<40, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m41), &TYPE::m41>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<41, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m42), &TYPE::m42>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<42, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m43), &TYPE::m43>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<43, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m44), &TYPE::m44>{})\
                );                                                                                \
            }                                                                                     \
        };                                                                                        \
    }}                                                                                            \
/**/

#define BOOST_HANA_ADAPT_STRUCT_IMPL_46(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21, m22, m23, m24, m25, m26, m27, m28, m29, m30, m31, m32, m33, m34, m35, m36, m37, m38, m39, m40, m41, m42, m43, m44, m45)    \
    namespace boost { namespace hana {                                                            \
        template <>                                                                               \
        struct accessors_impl<TYPE> {                                                             \
            static constexpr auto apply() {                                                       \
                struct member_names {                                                             \
                  static constexpr auto get() {                                                   \
                      return ::boost::hana::make_tuple(                                           \
                          BOOST_HANA_PP_STRINGIZE(m1), BOOST_HANA_PP_STRINGIZE(m2), BOOST_HANA_PP_STRINGIZE(m3), BOOST_HANA_PP_STRINGIZE(m4), BOOST_HANA_PP_STRINGIZE(m5), BOOST_HANA_PP_STRINGIZE(m6), BOOST_HANA_PP_STRINGIZE(m7), BOOST_HANA_PP_STRINGIZE(m8), BOOST_HANA_PP_STRINGIZE(m9), BOOST_HANA_PP_STRINGIZE(m10), BOOST_HANA_PP_STRINGIZE(m11), BOOST_HANA_PP_STRINGIZE(m12), BOOST_HANA_PP_STRINGIZE(m13), BOOST_HANA_PP_STRINGIZE(m14), BOOST_HANA_PP_STRINGIZE(m15), BOOST_HANA_PP_STRINGIZE(m16), BOOST_HANA_PP_STRINGIZE(m17), BOOST_HANA_PP_STRINGIZE(m18), BOOST_HANA_PP_STRINGIZE(m19), BOOST_HANA_PP_STRINGIZE(m20), BOOST_HANA_PP_STRINGIZE(m21), BOOST_HANA_PP_STRINGIZE(m22), BOOST_HANA_PP_STRINGIZE(m23), BOOST_HANA_PP_STRINGIZE(m24), BOOST_HANA_PP_STRINGIZE(m25), BOOST_HANA_PP_STRINGIZE(m26), BOOST_HANA_PP_STRINGIZE(m27), BOOST_HANA_PP_STRINGIZE(m28), BOOST_HANA_PP_STRINGIZE(m29), BOOST_HANA_PP_STRINGIZE(m30), BOOST_HANA_PP_STRINGIZE(m31), BOOST_HANA_PP_STRINGIZE(m32), BOOST_HANA_PP_STRINGIZE(m33), BOOST_HANA_PP_STRINGIZE(m34), BOOST_HANA_PP_STRINGIZE(m35), BOOST_HANA_PP_STRINGIZE(m36), BOOST_HANA_PP_STRINGIZE(m37), BOOST_HANA_PP_STRINGIZE(m38), BOOST_HANA_PP_STRINGIZE(m39), BOOST_HANA_PP_STRINGIZE(m40), BOOST_HANA_PP_STRINGIZE(m41), BOOST_HANA_PP_STRINGIZE(m42), BOOST_HANA_PP_STRINGIZE(m43), BOOST_HANA_PP_STRINGIZE(m44), BOOST_HANA_PP_STRINGIZE(m45)   \
                      );                                                                          \
                  }                                                                               \
                };                                                                                \
                return ::boost::hana::make_tuple(                                                 \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m1), &TYPE::m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m2), &TYPE::m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m3), &TYPE::m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m4), &TYPE::m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m5), &TYPE::m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m6), &TYPE::m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m7), &TYPE::m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m8), &TYPE::m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m9), &TYPE::m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m10), &TYPE::m10>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m11), &TYPE::m11>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m12), &TYPE::m12>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m13), &TYPE::m13>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m14), &TYPE::m14>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m15), &TYPE::m15>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m16), &TYPE::m16>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m17), &TYPE::m17>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m18), &TYPE::m18>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<18, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m19), &TYPE::m19>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<19, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m20), &TYPE::m20>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<20, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m21), &TYPE::m21>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<21, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m22), &TYPE::m22>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<22, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m23), &TYPE::m23>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<23, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m24), &TYPE::m24>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<24, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m25), &TYPE::m25>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<25, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m26), &TYPE::m26>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<26, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m27), &TYPE::m27>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<27, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m28), &TYPE::m28>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<28, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m29), &TYPE::m29>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<29, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m30), &TYPE::m30>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<30, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m31), &TYPE::m31>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<31, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m32), &TYPE::m32>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<32, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m33), &TYPE::m33>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<33, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m34), &TYPE::m34>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<34, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m35), &TYPE::m35>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<35, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m36), &TYPE::m36>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<36, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m37), &TYPE::m37>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<37, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m38), &TYPE::m38>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<38, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m39), &TYPE::m39>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<39, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m40), &TYPE::m40>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<40, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m41), &TYPE::m41>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<41, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m42), &TYPE::m42>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<42, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m43), &TYPE::m43>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<43, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m44), &TYPE::m44>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<44, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m45), &TYPE::m45>{})\
                );                                                                                \
            }                                                                                     \
        };                                                                                        \
    }}                                                                                            \
/**/

#define BOOST_HANA_ADAPT_STRUCT_IMPL_47(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21, m22, m23, m24, m25, m26, m27, m28, m29, m30, m31, m32, m33, m34, m35, m36, m37, m38, m39, m40, m41, m42, m43, m44, m45, m46)    \
    namespace boost { namespace hana {                                                            \
        template <>                                                                               \
        struct accessors_impl<TYPE> {                                                             \
            static constexpr auto apply() {                                                       \
                struct member_names {                                                             \
                  static constexpr auto get() {                                                   \
                      return ::boost::hana::make_tuple(                                           \
                          BOOST_HANA_PP_STRINGIZE(m1), BOOST_HANA_PP_STRINGIZE(m2), BOOST_HANA_PP_STRINGIZE(m3), BOOST_HANA_PP_STRINGIZE(m4), BOOST_HANA_PP_STRINGIZE(m5), BOOST_HANA_PP_STRINGIZE(m6), BOOST_HANA_PP_STRINGIZE(m7), BOOST_HANA_PP_STRINGIZE(m8), BOOST_HANA_PP_STRINGIZE(m9), BOOST_HANA_PP_STRINGIZE(m10), BOOST_HANA_PP_STRINGIZE(m11), BOOST_HANA_PP_STRINGIZE(m12), BOOST_HANA_PP_STRINGIZE(m13), BOOST_HANA_PP_STRINGIZE(m14), BOOST_HANA_PP_STRINGIZE(m15), BOOST_HANA_PP_STRINGIZE(m16), BOOST_HANA_PP_STRINGIZE(m17), BOOST_HANA_PP_STRINGIZE(m18), BOOST_HANA_PP_STRINGIZE(m19), BOOST_HANA_PP_STRINGIZE(m20), BOOST_HANA_PP_STRINGIZE(m21), BOOST_HANA_PP_STRINGIZE(m22), BOOST_HANA_PP_STRINGIZE(m23), BOOST_HANA_PP_STRINGIZE(m24), BOOST_HANA_PP_STRINGIZE(m25), BOOST_HANA_PP_STRINGIZE(m26), BOOST_HANA_PP_STRINGIZE(m27), BOOST_HANA_PP_STRINGIZE(m28), BOOST_HANA_PP_STRINGIZE(m29), BOOST_HANA_PP_STRINGIZE(m30), BOOST_HANA_PP_STRINGIZE(m31), BOOST_HANA_PP_STRINGIZE(m32), BOOST_HANA_PP_STRINGIZE(m33), BOOST_HANA_PP_STRINGIZE(m34), BOOST_HANA_PP_STRINGIZE(m35), BOOST_HANA_PP_STRINGIZE(m36), BOOST_HANA_PP_STRINGIZE(m37), BOOST_HANA_PP_STRINGIZE(m38), BOOST_HANA_PP_STRINGIZE(m39), BOOST_HANA_PP_STRINGIZE(m40), BOOST_HANA_PP_STRINGIZE(m41), BOOST_HANA_PP_STRINGIZE(m42), BOOST_HANA_PP_STRINGIZE(m43), BOOST_HANA_PP_STRINGIZE(m44), BOOST_HANA_PP_STRINGIZE(m45), BOOST_HANA_PP_STRINGIZE(m46)   \
                      );                                                                          \
                  }                                                                               \
                };                                                                                \
                return ::boost::hana::make_tuple(                                                 \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m1), &TYPE::m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m2), &TYPE::m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m3), &TYPE::m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m4), &TYPE::m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m5), &TYPE::m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m6), &TYPE::m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m7), &TYPE::m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m8), &TYPE::m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m9), &TYPE::m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m10), &TYPE::m10>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m11), &TYPE::m11>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m12), &TYPE::m12>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m13), &TYPE::m13>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m14), &TYPE::m14>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m15), &TYPE::m15>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m16), &TYPE::m16>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m17), &TYPE::m17>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m18), &TYPE::m18>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<18, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m19), &TYPE::m19>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<19, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m20), &TYPE::m20>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<20, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m21), &TYPE::m21>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<21, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m22), &TYPE::m22>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<22, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m23), &TYPE::m23>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<23, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m24), &TYPE::m24>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<24, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m25), &TYPE::m25>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<25, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m26), &TYPE::m26>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<26, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m27), &TYPE::m27>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<27, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m28), &TYPE::m28>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<28, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m29), &TYPE::m29>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<29, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m30), &TYPE::m30>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<30, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m31), &TYPE::m31>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<31, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m32), &TYPE::m32>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<32, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m33), &TYPE::m33>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<33, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m34), &TYPE::m34>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<34, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m35), &TYPE::m35>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<35, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m36), &TYPE::m36>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<36, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m37), &TYPE::m37>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<37, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m38), &TYPE::m38>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<38, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m39), &TYPE::m39>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<39, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m40), &TYPE::m40>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<40, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m41), &TYPE::m41>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<41, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m42), &TYPE::m42>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<42, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m43), &TYPE::m43>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<43, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m44), &TYPE::m44>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<44, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m45), &TYPE::m45>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<45, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m46), &TYPE::m46>{})\
                );                                                                                \
            }                                                                                     \
        };                                                                                        \
    }}                                                                                            \
/**/

#define BOOST_HANA_ADAPT_STRUCT_IMPL_48(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21, m22, m23, m24, m25, m26, m27, m28, m29, m30, m31, m32, m33, m34, m35, m36, m37, m38, m39, m40, m41, m42, m43, m44, m45, m46, m47)    \
    namespace boost { namespace hana {                                                            \
        template <>                                                                               \
        struct accessors_impl<TYPE> {                                                             \
            static constexpr auto apply() {                                                       \
                struct member_names {                                                             \
                  static constexpr auto get() {                                                   \
                      return ::boost::hana::make_tuple(                                           \
                          BOOST_HANA_PP_STRINGIZE(m1), BOOST_HANA_PP_STRINGIZE(m2), BOOST_HANA_PP_STRINGIZE(m3), BOOST_HANA_PP_STRINGIZE(m4), BOOST_HANA_PP_STRINGIZE(m5), BOOST_HANA_PP_STRINGIZE(m6), BOOST_HANA_PP_STRINGIZE(m7), BOOST_HANA_PP_STRINGIZE(m8), BOOST_HANA_PP_STRINGIZE(m9), BOOST_HANA_PP_STRINGIZE(m10), BOOST_HANA_PP_STRINGIZE(m11), BOOST_HANA_PP_STRINGIZE(m12), BOOST_HANA_PP_STRINGIZE(m13), BOOST_HANA_PP_STRINGIZE(m14), BOOST_HANA_PP_STRINGIZE(m15), BOOST_HANA_PP_STRINGIZE(m16), BOOST_HANA_PP_STRINGIZE(m17), BOOST_HANA_PP_STRINGIZE(m18), BOOST_HANA_PP_STRINGIZE(m19), BOOST_HANA_PP_STRINGIZE(m20), BOOST_HANA_PP_STRINGIZE(m21), BOOST_HANA_PP_STRINGIZE(m22), BOOST_HANA_PP_STRINGIZE(m23), BOOST_HANA_PP_STRINGIZE(m24), BOOST_HANA_PP_STRINGIZE(m25), BOOST_HANA_PP_STRINGIZE(m26), BOOST_HANA_PP_STRINGIZE(m27), BOOST_HANA_PP_STRINGIZE(m28), BOOST_HANA_PP_STRINGIZE(m29), BOOST_HANA_PP_STRINGIZE(m30), BOOST_HANA_PP_STRINGIZE(m31), BOOST_HANA_PP_STRINGIZE(m32), BOOST_HANA_PP_STRINGIZE(m33), BOOST_HANA_PP_STRINGIZE(m34), BOOST_HANA_PP_STRINGIZE(m35), BOOST_HANA_PP_STRINGIZE(m36), BOOST_HANA_PP_STRINGIZE(m37), BOOST_HANA_PP_STRINGIZE(m38), BOOST_HANA_PP_STRINGIZE(m39), BOOST_HANA_PP_STRINGIZE(m40), BOOST_HANA_PP_STRINGIZE(m41), BOOST_HANA_PP_STRINGIZE(m42), BOOST_HANA_PP_STRINGIZE(m43), BOOST_HANA_PP_STRINGIZE(m44), BOOST_HANA_PP_STRINGIZE(m45), BOOST_HANA_PP_STRINGIZE(m46), BOOST_HANA_PP_STRINGIZE(m47)   \
                      );                                                                          \
                  }                                                                               \
                };                                                                                \
                return ::boost::hana::make_tuple(                                                 \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m1), &TYPE::m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m2), &TYPE::m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m3), &TYPE::m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m4), &TYPE::m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m5), &TYPE::m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m6), &TYPE::m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m7), &TYPE::m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m8), &TYPE::m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m9), &TYPE::m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m10), &TYPE::m10>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m11), &TYPE::m11>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m12), &TYPE::m12>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m13), &TYPE::m13>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m14), &TYPE::m14>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m15), &TYPE::m15>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m16), &TYPE::m16>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m17), &TYPE::m17>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m18), &TYPE::m18>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<18, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m19), &TYPE::m19>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<19, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m20), &TYPE::m20>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<20, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m21), &TYPE::m21>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<21, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m22), &TYPE::m22>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<22, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m23), &TYPE::m23>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<23, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m24), &TYPE::m24>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<24, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m25), &TYPE::m25>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<25, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m26), &TYPE::m26>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<26, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m27), &TYPE::m27>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<27, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m28), &TYPE::m28>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<28, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m29), &TYPE::m29>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<29, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m30), &TYPE::m30>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<30, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m31), &TYPE::m31>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<31, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m32), &TYPE::m32>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<32, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m33), &TYPE::m33>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<33, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m34), &TYPE::m34>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<34, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m35), &TYPE::m35>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<35, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m36), &TYPE::m36>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<36, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m37), &TYPE::m37>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<37, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m38), &TYPE::m38>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<38, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m39), &TYPE::m39>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<39, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m40), &TYPE::m40>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<40, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m41), &TYPE::m41>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<41, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m42), &TYPE::m42>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<42, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m43), &TYPE::m43>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<43, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m44), &TYPE::m44>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<44, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m45), &TYPE::m45>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<45, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m46), &TYPE::m46>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<46, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m47), &TYPE::m47>{})\
                );                                                                                \
            }                                                                                     \
        };                                                                                        \
    }}                                                                                            \
/**/

#define BOOST_HANA_ADAPT_STRUCT_IMPL_49(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21, m22, m23, m24, m25, m26, m27, m28, m29, m30, m31, m32, m33, m34, m35, m36, m37, m38, m39, m40, m41, m42, m43, m44, m45, m46, m47, m48)    \
    namespace boost { namespace hana {                                                            \
        template <>                                                                               \
        struct accessors_impl<TYPE> {                                                             \
            static constexpr auto apply() {                                                       \
                struct member_names {                                                             \
                  static constexpr auto get() {                                                   \
                      return ::boost::hana::make_tuple(                                           \
                          BOOST_HANA_PP_STRINGIZE(m1), BOOST_HANA_PP_STRINGIZE(m2), BOOST_HANA_PP_STRINGIZE(m3), BOOST_HANA_PP_STRINGIZE(m4), BOOST_HANA_PP_STRINGIZE(m5), BOOST_HANA_PP_STRINGIZE(m6), BOOST_HANA_PP_STRINGIZE(m7), BOOST_HANA_PP_STRINGIZE(m8), BOOST_HANA_PP_STRINGIZE(m9), BOOST_HANA_PP_STRINGIZE(m10), BOOST_HANA_PP_STRINGIZE(m11), BOOST_HANA_PP_STRINGIZE(m12), BOOST_HANA_PP_STRINGIZE(m13), BOOST_HANA_PP_STRINGIZE(m14), BOOST_HANA_PP_STRINGIZE(m15), BOOST_HANA_PP_STRINGIZE(m16), BOOST_HANA_PP_STRINGIZE(m17), BOOST_HANA_PP_STRINGIZE(m18), BOOST_HANA_PP_STRINGIZE(m19), BOOST_HANA_PP_STRINGIZE(m20), BOOST_HANA_PP_STRINGIZE(m21), BOOST_HANA_PP_STRINGIZE(m22), BOOST_HANA_PP_STRINGIZE(m23), BOOST_HANA_PP_STRINGIZE(m24), BOOST_HANA_PP_STRINGIZE(m25), BOOST_HANA_PP_STRINGIZE(m26), BOOST_HANA_PP_STRINGIZE(m27), BOOST_HANA_PP_STRINGIZE(m28), BOOST_HANA_PP_STRINGIZE(m29), BOOST_HANA_PP_STRINGIZE(m30), BOOST_HANA_PP_STRINGIZE(m31), BOOST_HANA_PP_STRINGIZE(m32), BOOST_HANA_PP_STRINGIZE(m33), BOOST_HANA_PP_STRINGIZE(m34), BOOST_HANA_PP_STRINGIZE(m35), BOOST_HANA_PP_STRINGIZE(m36), BOOST_HANA_PP_STRINGIZE(m37), BOOST_HANA_PP_STRINGIZE(m38), BOOST_HANA_PP_STRINGIZE(m39), BOOST_HANA_PP_STRINGIZE(m40), BOOST_HANA_PP_STRINGIZE(m41), BOOST_HANA_PP_STRINGIZE(m42), BOOST_HANA_PP_STRINGIZE(m43), BOOST_HANA_PP_STRINGIZE(m44), BOOST_HANA_PP_STRINGIZE(m45), BOOST_HANA_PP_STRINGIZE(m46), BOOST_HANA_PP_STRINGIZE(m47), BOOST_HANA_PP_STRINGIZE(m48)   \
                      );                                                                          \
                  }                                                                               \
                };                                                                                \
                return ::boost::hana::make_tuple(                                                 \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m1), &TYPE::m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m2), &TYPE::m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m3), &TYPE::m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m4), &TYPE::m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m5), &TYPE::m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m6), &TYPE::m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m7), &TYPE::m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m8), &TYPE::m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m9), &TYPE::m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m10), &TYPE::m10>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m11), &TYPE::m11>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m12), &TYPE::m12>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m13), &TYPE::m13>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m14), &TYPE::m14>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m15), &TYPE::m15>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m16), &TYPE::m16>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m17), &TYPE::m17>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m18), &TYPE::m18>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<18, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m19), &TYPE::m19>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<19, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m20), &TYPE::m20>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<20, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m21), &TYPE::m21>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<21, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m22), &TYPE::m22>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<22, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m23), &TYPE::m23>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<23, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m24), &TYPE::m24>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<24, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m25), &TYPE::m25>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<25, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m26), &TYPE::m26>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<26, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m27), &TYPE::m27>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<27, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m28), &TYPE::m28>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<28, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m29), &TYPE::m29>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<29, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m30), &TYPE::m30>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<30, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m31), &TYPE::m31>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<31, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m32), &TYPE::m32>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<32, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m33), &TYPE::m33>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<33, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m34), &TYPE::m34>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<34, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m35), &TYPE::m35>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<35, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m36), &TYPE::m36>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<36, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m37), &TYPE::m37>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<37, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m38), &TYPE::m38>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<38, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m39), &TYPE::m39>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<39, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m40), &TYPE::m40>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<40, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m41), &TYPE::m41>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<41, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m42), &TYPE::m42>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<42, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m43), &TYPE::m43>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<43, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m44), &TYPE::m44>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<44, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m45), &TYPE::m45>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<45, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m46), &TYPE::m46>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<46, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m47), &TYPE::m47>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<47, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m48), &TYPE::m48>{})\
                );                                                                                \
            }                                                                                     \
        };                                                                                        \
    }}                                                                                            \
/**/

#define BOOST_HANA_ADAPT_STRUCT_IMPL_50(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21, m22, m23, m24, m25, m26, m27, m28, m29, m30, m31, m32, m33, m34, m35, m36, m37, m38, m39, m40, m41, m42, m43, m44, m45, m46, m47, m48, m49)    \
    namespace boost { namespace hana {                                                            \
        template <>                                                                               \
        struct accessors_impl<TYPE> {                                                             \
            static constexpr auto apply() {                                                       \
                struct member_names {                                                             \
                  static constexpr auto get() {                                                   \
                      return ::boost::hana::make_tuple(                                           \
                          BOOST_HANA_PP_STRINGIZE(m1), BOOST_HANA_PP_STRINGIZE(m2), BOOST_HANA_PP_STRINGIZE(m3), BOOST_HANA_PP_STRINGIZE(m4), BOOST_HANA_PP_STRINGIZE(m5), BOOST_HANA_PP_STRINGIZE(m6), BOOST_HANA_PP_STRINGIZE(m7), BOOST_HANA_PP_STRINGIZE(m8), BOOST_HANA_PP_STRINGIZE(m9), BOOST_HANA_PP_STRINGIZE(m10), BOOST_HANA_PP_STRINGIZE(m11), BOOST_HANA_PP_STRINGIZE(m12), BOOST_HANA_PP_STRINGIZE(m13), BOOST_HANA_PP_STRINGIZE(m14), BOOST_HANA_PP_STRINGIZE(m15), BOOST_HANA_PP_STRINGIZE(m16), BOOST_HANA_PP_STRINGIZE(m17), BOOST_HANA_PP_STRINGIZE(m18), BOOST_HANA_PP_STRINGIZE(m19), BOOST_HANA_PP_STRINGIZE(m20), BOOST_HANA_PP_STRINGIZE(m21), BOOST_HANA_PP_STRINGIZE(m22), BOOST_HANA_PP_STRINGIZE(m23), BOOST_HANA_PP_STRINGIZE(m24), BOOST_HANA_PP_STRINGIZE(m25), BOOST_HANA_PP_STRINGIZE(m26), BOOST_HANA_PP_STRINGIZE(m27), BOOST_HANA_PP_STRINGIZE(m28), BOOST_HANA_PP_STRINGIZE(m29), BOOST_HANA_PP_STRINGIZE(m30), BOOST_HANA_PP_STRINGIZE(m31), BOOST_HANA_PP_STRINGIZE(m32), BOOST_HANA_PP_STRINGIZE(m33), BOOST_HANA_PP_STRINGIZE(m34), BOOST_HANA_PP_STRINGIZE(m35), BOOST_HANA_PP_STRINGIZE(m36), BOOST_HANA_PP_STRINGIZE(m37), BOOST_HANA_PP_STRINGIZE(m38), BOOST_HANA_PP_STRINGIZE(m39), BOOST_HANA_PP_STRINGIZE(m40), BOOST_HANA_PP_STRINGIZE(m41), BOOST_HANA_PP_STRINGIZE(m42), BOOST_HANA_PP_STRINGIZE(m43), BOOST_HANA_PP_STRINGIZE(m44), BOOST_HANA_PP_STRINGIZE(m45), BOOST_HANA_PP_STRINGIZE(m46), BOOST_HANA_PP_STRINGIZE(m47), BOOST_HANA_PP_STRINGIZE(m48), BOOST_HANA_PP_STRINGIZE(m49)   \
                      );                                                                          \
                  }                                                                               \
                };                                                                                \
                return ::boost::hana::make_tuple(                                                 \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m1), &TYPE::m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m2), &TYPE::m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m3), &TYPE::m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m4), &TYPE::m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m5), &TYPE::m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m6), &TYPE::m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m7), &TYPE::m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m8), &TYPE::m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m9), &TYPE::m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m10), &TYPE::m10>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m11), &TYPE::m11>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m12), &TYPE::m12>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m13), &TYPE::m13>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m14), &TYPE::m14>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m15), &TYPE::m15>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m16), &TYPE::m16>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m17), &TYPE::m17>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m18), &TYPE::m18>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<18, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m19), &TYPE::m19>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<19, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m20), &TYPE::m20>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<20, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m21), &TYPE::m21>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<21, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m22), &TYPE::m22>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<22, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m23), &TYPE::m23>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<23, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m24), &TYPE::m24>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<24, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m25), &TYPE::m25>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<25, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m26), &TYPE::m26>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<26, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m27), &TYPE::m27>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<27, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m28), &TYPE::m28>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<28, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m29), &TYPE::m29>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<29, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m30), &TYPE::m30>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<30, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m31), &TYPE::m31>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<31, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m32), &TYPE::m32>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<32, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m33), &TYPE::m33>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<33, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m34), &TYPE::m34>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<34, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m35), &TYPE::m35>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<35, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m36), &TYPE::m36>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<36, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m37), &TYPE::m37>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<37, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m38), &TYPE::m38>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<38, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m39), &TYPE::m39>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<39, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m40), &TYPE::m40>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<40, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m41), &TYPE::m41>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<41, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m42), &TYPE::m42>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<42, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m43), &TYPE::m43>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<43, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m44), &TYPE::m44>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<44, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m45), &TYPE::m45>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<45, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m46), &TYPE::m46>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<46, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m47), &TYPE::m47>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<47, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m48), &TYPE::m48>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<48, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m49), &TYPE::m49>{})\
                );                                                                                \
            }                                                                                     \
        };                                                                                        \
    }}                                                                                            \
/**/

#define BOOST_HANA_ADAPT_STRUCT_IMPL_51(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21, m22, m23, m24, m25, m26, m27, m28, m29, m30, m31, m32, m33, m34, m35, m36, m37, m38, m39, m40, m41, m42, m43, m44, m45, m46, m47, m48, m49, m50)    \
    namespace boost { namespace hana {                                                            \
        template <>                                                                               \
        struct accessors_impl<TYPE> {                                                             \
            static constexpr auto apply() {                                                       \
                struct member_names {                                                             \
                  static constexpr auto get() {                                                   \
                      return ::boost::hana::make_tuple(                                           \
                          BOOST_HANA_PP_STRINGIZE(m1), BOOST_HANA_PP_STRINGIZE(m2), BOOST_HANA_PP_STRINGIZE(m3), BOOST_HANA_PP_STRINGIZE(m4), BOOST_HANA_PP_STRINGIZE(m5), BOOST_HANA_PP_STRINGIZE(m6), BOOST_HANA_PP_STRINGIZE(m7), BOOST_HANA_PP_STRINGIZE(m8), BOOST_HANA_PP_STRINGIZE(m9), BOOST_HANA_PP_STRINGIZE(m10), BOOST_HANA_PP_STRINGIZE(m11), BOOST_HANA_PP_STRINGIZE(m12), BOOST_HANA_PP_STRINGIZE(m13), BOOST_HANA_PP_STRINGIZE(m14), BOOST_HANA_PP_STRINGIZE(m15), BOOST_HANA_PP_STRINGIZE(m16), BOOST_HANA_PP_STRINGIZE(m17), BOOST_HANA_PP_STRINGIZE(m18), BOOST_HANA_PP_STRINGIZE(m19), BOOST_HANA_PP_STRINGIZE(m20), BOOST_HANA_PP_STRINGIZE(m21), BOOST_HANA_PP_STRINGIZE(m22), BOOST_HANA_PP_STRINGIZE(m23), BOOST_HANA_PP_STRINGIZE(m24), BOOST_HANA_PP_STRINGIZE(m25), BOOST_HANA_PP_STRINGIZE(m26), BOOST_HANA_PP_STRINGIZE(m27), BOOST_HANA_PP_STRINGIZE(m28), BOOST_HANA_PP_STRINGIZE(m29), BOOST_HANA_PP_STRINGIZE(m30), BOOST_HANA_PP_STRINGIZE(m31), BOOST_HANA_PP_STRINGIZE(m32), BOOST_HANA_PP_STRINGIZE(m33), BOOST_HANA_PP_STRINGIZE(m34), BOOST_HANA_PP_STRINGIZE(m35), BOOST_HANA_PP_STRINGIZE(m36), BOOST_HANA_PP_STRINGIZE(m37), BOOST_HANA_PP_STRINGIZE(m38), BOOST_HANA_PP_STRINGIZE(m39), BOOST_HANA_PP_STRINGIZE(m40), BOOST_HANA_PP_STRINGIZE(m41), BOOST_HANA_PP_STRINGIZE(m42), BOOST_HANA_PP_STRINGIZE(m43), BOOST_HANA_PP_STRINGIZE(m44), BOOST_HANA_PP_STRINGIZE(m45), BOOST_HANA_PP_STRINGIZE(m46), BOOST_HANA_PP_STRINGIZE(m47), BOOST_HANA_PP_STRINGIZE(m48), BOOST_HANA_PP_STRINGIZE(m49), BOOST_HANA_PP_STRINGIZE(m50)   \
                      );                                                                          \
                  }                                                                               \
                };                                                                                \
                return ::boost::hana::make_tuple(                                                 \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m1), &TYPE::m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m2), &TYPE::m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m3), &TYPE::m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m4), &TYPE::m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m5), &TYPE::m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m6), &TYPE::m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m7), &TYPE::m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m8), &TYPE::m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m9), &TYPE::m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m10), &TYPE::m10>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m11), &TYPE::m11>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m12), &TYPE::m12>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m13), &TYPE::m13>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m14), &TYPE::m14>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m15), &TYPE::m15>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m16), &TYPE::m16>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m17), &TYPE::m17>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m18), &TYPE::m18>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<18, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m19), &TYPE::m19>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<19, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m20), &TYPE::m20>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<20, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m21), &TYPE::m21>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<21, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m22), &TYPE::m22>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<22, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m23), &TYPE::m23>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<23, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m24), &TYPE::m24>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<24, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m25), &TYPE::m25>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<25, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m26), &TYPE::m26>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<26, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m27), &TYPE::m27>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<27, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m28), &TYPE::m28>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<28, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m29), &TYPE::m29>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<29, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m30), &TYPE::m30>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<30, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m31), &TYPE::m31>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<31, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m32), &TYPE::m32>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<32, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m33), &TYPE::m33>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<33, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m34), &TYPE::m34>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<34, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m35), &TYPE::m35>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<35, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m36), &TYPE::m36>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<36, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m37), &TYPE::m37>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<37, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m38), &TYPE::m38>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<38, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m39), &TYPE::m39>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<39, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m40), &TYPE::m40>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<40, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m41), &TYPE::m41>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<41, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m42), &TYPE::m42>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<42, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m43), &TYPE::m43>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<43, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m44), &TYPE::m44>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<44, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m45), &TYPE::m45>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<45, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m46), &TYPE::m46>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<46, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m47), &TYPE::m47>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<47, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m48), &TYPE::m48>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<48, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m49), &TYPE::m49>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<49, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m50), &TYPE::m50>{})\
                );                                                                                \
            }                                                                                     \
        };                                                                                        \
    }}                                                                                            \
/**/

#define BOOST_HANA_ADAPT_STRUCT_IMPL_52(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21, m22, m23, m24, m25, m26, m27, m28, m29, m30, m31, m32, m33, m34, m35, m36, m37, m38, m39, m40, m41, m42, m43, m44, m45, m46, m47, m48, m49, m50, m51)    \
    namespace boost { namespace hana {                                                            \
        template <>                                                                               \
        struct accessors_impl<TYPE> {                                                             \
            static constexpr auto apply() {                                                       \
                struct member_names {                                                             \
                  static constexpr auto get() {                                                   \
                      return ::boost::hana::make_tuple(                                           \
                          BOOST_HANA_PP_STRINGIZE(m1), BOOST_HANA_PP_STRINGIZE(m2), BOOST_HANA_PP_STRINGIZE(m3), BOOST_HANA_PP_STRINGIZE(m4), BOOST_HANA_PP_STRINGIZE(m5), BOOST_HANA_PP_STRINGIZE(m6), BOOST_HANA_PP_STRINGIZE(m7), BOOST_HANA_PP_STRINGIZE(m8), BOOST_HANA_PP_STRINGIZE(m9), BOOST_HANA_PP_STRINGIZE(m10), BOOST_HANA_PP_STRINGIZE(m11), BOOST_HANA_PP_STRINGIZE(m12), BOOST_HANA_PP_STRINGIZE(m13), BOOST_HANA_PP_STRINGIZE(m14), BOOST_HANA_PP_STRINGIZE(m15), BOOST_HANA_PP_STRINGIZE(m16), BOOST_HANA_PP_STRINGIZE(m17), BOOST_HANA_PP_STRINGIZE(m18), BOOST_HANA_PP_STRINGIZE(m19), BOOST_HANA_PP_STRINGIZE(m20), BOOST_HANA_PP_STRINGIZE(m21), BOOST_HANA_PP_STRINGIZE(m22), BOOST_HANA_PP_STRINGIZE(m23), BOOST_HANA_PP_STRINGIZE(m24), BOOST_HANA_PP_STRINGIZE(m25), BOOST_HANA_PP_STRINGIZE(m26), BOOST_HANA_PP_STRINGIZE(m27), BOOST_HANA_PP_STRINGIZE(m28), BOOST_HANA_PP_STRINGIZE(m29), BOOST_HANA_PP_STRINGIZE(m30), BOOST_HANA_PP_STRINGIZE(m31), BOOST_HANA_PP_STRINGIZE(m32), BOOST_HANA_PP_STRINGIZE(m33), BOOST_HANA_PP_STRINGIZE(m34), BOOST_HANA_PP_STRINGIZE(m35), BOOST_HANA_PP_STRINGIZE(m36), BOOST_HANA_PP_STRINGIZE(m37), BOOST_HANA_PP_STRINGIZE(m38), BOOST_HANA_PP_STRINGIZE(m39), BOOST_HANA_PP_STRINGIZE(m40), BOOST_HANA_PP_STRINGIZE(m41), BOOST_HANA_PP_STRINGIZE(m42), BOOST_HANA_PP_STRINGIZE(m43), BOOST_HANA_PP_STRINGIZE(m44), BOOST_HANA_PP_STRINGIZE(m45), BOOST_HANA_PP_STRINGIZE(m46), BOOST_HANA_PP_STRINGIZE(m47), BOOST_HANA_PP_STRINGIZE(m48), BOOST_HANA_PP_STRINGIZE(m49), BOOST_HANA_PP_STRINGIZE(m50), BOOST_HANA_PP_STRINGIZE(m51)   \
                      );                                                                          \
                  }                                                                               \
                };                                                                                \
                return ::boost::hana::make_tuple(                                                 \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m1), &TYPE::m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m2), &TYPE::m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m3), &TYPE::m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m4), &TYPE::m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m5), &TYPE::m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m6), &TYPE::m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m7), &TYPE::m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m8), &TYPE::m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m9), &TYPE::m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m10), &TYPE::m10>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m11), &TYPE::m11>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m12), &TYPE::m12>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m13), &TYPE::m13>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m14), &TYPE::m14>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m15), &TYPE::m15>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m16), &TYPE::m16>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m17), &TYPE::m17>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m18), &TYPE::m18>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<18, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m19), &TYPE::m19>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<19, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m20), &TYPE::m20>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<20, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m21), &TYPE::m21>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<21, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m22), &TYPE::m22>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<22, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m23), &TYPE::m23>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<23, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m24), &TYPE::m24>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<24, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m25), &TYPE::m25>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<25, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m26), &TYPE::m26>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<26, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m27), &TYPE::m27>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<27, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m28), &TYPE::m28>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<28, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m29), &TYPE::m29>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<29, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m30), &TYPE::m30>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<30, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m31), &TYPE::m31>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<31, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m32), &TYPE::m32>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<32, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m33), &TYPE::m33>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<33, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m34), &TYPE::m34>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<34, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m35), &TYPE::m35>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<35, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m36), &TYPE::m36>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<36, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m37), &TYPE::m37>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<37, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m38), &TYPE::m38>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<38, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m39), &TYPE::m39>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<39, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m40), &TYPE::m40>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<40, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m41), &TYPE::m41>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<41, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m42), &TYPE::m42>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<42, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m43), &TYPE::m43>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<43, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m44), &TYPE::m44>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<44, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m45), &TYPE::m45>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<45, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m46), &TYPE::m46>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<46, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m47), &TYPE::m47>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<47, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m48), &TYPE::m48>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<48, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m49), &TYPE::m49>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<49, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m50), &TYPE::m50>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<50, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m51), &TYPE::m51>{})\
                );                                                                                \
            }                                                                                     \
        };                                                                                        \
    }}                                                                                            \
/**/

#define BOOST_HANA_ADAPT_STRUCT_IMPL_53(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21, m22, m23, m24, m25, m26, m27, m28, m29, m30, m31, m32, m33, m34, m35, m36, m37, m38, m39, m40, m41, m42, m43, m44, m45, m46, m47, m48, m49, m50, m51, m52)    \
    namespace boost { namespace hana {                                                            \
        template <>                                                                               \
        struct accessors_impl<TYPE> {                                                             \
            static constexpr auto apply() {                                                       \
                struct member_names {                                                             \
                  static constexpr auto get() {                                                   \
                      return ::boost::hana::make_tuple(                                           \
                          BOOST_HANA_PP_STRINGIZE(m1), BOOST_HANA_PP_STRINGIZE(m2), BOOST_HANA_PP_STRINGIZE(m3), BOOST_HANA_PP_STRINGIZE(m4), BOOST_HANA_PP_STRINGIZE(m5), BOOST_HANA_PP_STRINGIZE(m6), BOOST_HANA_PP_STRINGIZE(m7), BOOST_HANA_PP_STRINGIZE(m8), BOOST_HANA_PP_STRINGIZE(m9), BOOST_HANA_PP_STRINGIZE(m10), BOOST_HANA_PP_STRINGIZE(m11), BOOST_HANA_PP_STRINGIZE(m12), BOOST_HANA_PP_STRINGIZE(m13), BOOST_HANA_PP_STRINGIZE(m14), BOOST_HANA_PP_STRINGIZE(m15), BOOST_HANA_PP_STRINGIZE(m16), BOOST_HANA_PP_STRINGIZE(m17), BOOST_HANA_PP_STRINGIZE(m18), BOOST_HANA_PP_STRINGIZE(m19), BOOST_HANA_PP_STRINGIZE(m20), BOOST_HANA_PP_STRINGIZE(m21), BOOST_HANA_PP_STRINGIZE(m22), BOOST_HANA_PP_STRINGIZE(m23), BOOST_HANA_PP_STRINGIZE(m24), BOOST_HANA_PP_STRINGIZE(m25), BOOST_HANA_PP_STRINGIZE(m26), BOOST_HANA_PP_STRINGIZE(m27), BOOST_HANA_PP_STRINGIZE(m28), BOOST_HANA_PP_STRINGIZE(m29), BOOST_HANA_PP_STRINGIZE(m30), BOOST_HANA_PP_STRINGIZE(m31), BOOST_HANA_PP_STRINGIZE(m32), BOOST_HANA_PP_STRINGIZE(m33), BOOST_HANA_PP_STRINGIZE(m34), BOOST_HANA_PP_STRINGIZE(m35), BOOST_HANA_PP_STRINGIZE(m36), BOOST_HANA_PP_STRINGIZE(m37), BOOST_HANA_PP_STRINGIZE(m38), BOOST_HANA_PP_STRINGIZE(m39), BOOST_HANA_PP_STRINGIZE(m40), BOOST_HANA_PP_STRINGIZE(m41), BOOST_HANA_PP_STRINGIZE(m42), BOOST_HANA_PP_STRINGIZE(m43), BOOST_HANA_PP_STRINGIZE(m44), BOOST_HANA_PP_STRINGIZE(m45), BOOST_HANA_PP_STRINGIZE(m46), BOOST_HANA_PP_STRINGIZE(m47), BOOST_HANA_PP_STRINGIZE(m48), BOOST_HANA_PP_STRINGIZE(m49), BOOST_HANA_PP_STRINGIZE(m50), BOOST_HANA_PP_STRINGIZE(m51), BOOST_HANA_PP_STRINGIZE(m52)   \
                      );                                                                          \
                  }                                                                               \
                };                                                                                \
                return ::boost::hana::make_tuple(                                                 \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m1), &TYPE::m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m2), &TYPE::m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m3), &TYPE::m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m4), &TYPE::m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m5), &TYPE::m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m6), &TYPE::m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m7), &TYPE::m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m8), &TYPE::m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m9), &TYPE::m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m10), &TYPE::m10>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m11), &TYPE::m11>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m12), &TYPE::m12>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m13), &TYPE::m13>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m14), &TYPE::m14>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m15), &TYPE::m15>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m16), &TYPE::m16>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m17), &TYPE::m17>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m18), &TYPE::m18>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<18, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m19), &TYPE::m19>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<19, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m20), &TYPE::m20>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<20, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m21), &TYPE::m21>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<21, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m22), &TYPE::m22>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<22, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m23), &TYPE::m23>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<23, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m24), &TYPE::m24>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<24, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m25), &TYPE::m25>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<25, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m26), &TYPE::m26>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<26, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m27), &TYPE::m27>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<27, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m28), &TYPE::m28>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<28, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m29), &TYPE::m29>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<29, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m30), &TYPE::m30>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<30, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m31), &TYPE::m31>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<31, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m32), &TYPE::m32>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<32, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m33), &TYPE::m33>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<33, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m34), &TYPE::m34>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<34, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m35), &TYPE::m35>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<35, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m36), &TYPE::m36>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<36, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m37), &TYPE::m37>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<37, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m38), &TYPE::m38>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<38, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m39), &TYPE::m39>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<39, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m40), &TYPE::m40>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<40, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m41), &TYPE::m41>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<41, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m42), &TYPE::m42>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<42, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m43), &TYPE::m43>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<43, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m44), &TYPE::m44>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<44, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m45), &TYPE::m45>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<45, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m46), &TYPE::m46>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<46, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m47), &TYPE::m47>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<47, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m48), &TYPE::m48>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<48, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m49), &TYPE::m49>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<49, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m50), &TYPE::m50>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<50, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m51), &TYPE::m51>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<51, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m52), &TYPE::m52>{})\
                );                                                                                \
            }                                                                                     \
        };                                                                                        \
    }}                                                                                            \
/**/

#define BOOST_HANA_ADAPT_STRUCT_IMPL_54(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21, m22, m23, m24, m25, m26, m27, m28, m29, m30, m31, m32, m33, m34, m35, m36, m37, m38, m39, m40, m41, m42, m43, m44, m45, m46, m47, m48, m49, m50, m51, m52, m53)    \
    namespace boost { namespace hana {                                                            \
        template <>                                                                               \
        struct accessors_impl<TYPE> {                                                             \
            static constexpr auto apply() {                                                       \
                struct member_names {                                                             \
                  static constexpr auto get() {                                                   \
                      return ::boost::hana::make_tuple(                                           \
                          BOOST_HANA_PP_STRINGIZE(m1), BOOST_HANA_PP_STRINGIZE(m2), BOOST_HANA_PP_STRINGIZE(m3), BOOST_HANA_PP_STRINGIZE(m4), BOOST_HANA_PP_STRINGIZE(m5), BOOST_HANA_PP_STRINGIZE(m6), BOOST_HANA_PP_STRINGIZE(m7), BOOST_HANA_PP_STRINGIZE(m8), BOOST_HANA_PP_STRINGIZE(m9), BOOST_HANA_PP_STRINGIZE(m10), BOOST_HANA_PP_STRINGIZE(m11), BOOST_HANA_PP_STRINGIZE(m12), BOOST_HANA_PP_STRINGIZE(m13), BOOST_HANA_PP_STRINGIZE(m14), BOOST_HANA_PP_STRINGIZE(m15), BOOST_HANA_PP_STRINGIZE(m16), BOOST_HANA_PP_STRINGIZE(m17), BOOST_HANA_PP_STRINGIZE(m18), BOOST_HANA_PP_STRINGIZE(m19), BOOST_HANA_PP_STRINGIZE(m20), BOOST_HANA_PP_STRINGIZE(m21), BOOST_HANA_PP_STRINGIZE(m22), BOOST_HANA_PP_STRINGIZE(m23), BOOST_HANA_PP_STRINGIZE(m24), BOOST_HANA_PP_STRINGIZE(m25), BOOST_HANA_PP_STRINGIZE(m26), BOOST_HANA_PP_STRINGIZE(m27), BOOST_HANA_PP_STRINGIZE(m28), BOOST_HANA_PP_STRINGIZE(m29), BOOST_HANA_PP_STRINGIZE(m30), BOOST_HANA_PP_STRINGIZE(m31), BOOST_HANA_PP_STRINGIZE(m32), BOOST_HANA_PP_STRINGIZE(m33), BOOST_HANA_PP_STRINGIZE(m34), BOOST_HANA_PP_STRINGIZE(m35), BOOST_HANA_PP_STRINGIZE(m36), BOOST_HANA_PP_STRINGIZE(m37), BOOST_HANA_PP_STRINGIZE(m38), BOOST_HANA_PP_STRINGIZE(m39), BOOST_HANA_PP_STRINGIZE(m40), BOOST_HANA_PP_STRINGIZE(m41), BOOST_HANA_PP_STRINGIZE(m42), BOOST_HANA_PP_STRINGIZE(m43), BOOST_HANA_PP_STRINGIZE(m44), BOOST_HANA_PP_STRINGIZE(m45), BOOST_HANA_PP_STRINGIZE(m46), BOOST_HANA_PP_STRINGIZE(m47), BOOST_HANA_PP_STRINGIZE(m48), BOOST_HANA_PP_STRINGIZE(m49), BOOST_HANA_PP_STRINGIZE(m50), BOOST_HANA_PP_STRINGIZE(m51), BOOST_HANA_PP_STRINGIZE(m52), BOOST_HANA_PP_STRINGIZE(m53)   \
                      );                                                                          \
                  }                                                                               \
                };                                                                                \
                return ::boost::hana::make_tuple(                                                 \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m1), &TYPE::m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m2), &TYPE::m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m3), &TYPE::m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m4), &TYPE::m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m5), &TYPE::m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m6), &TYPE::m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m7), &TYPE::m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m8), &TYPE::m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m9), &TYPE::m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m10), &TYPE::m10>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m11), &TYPE::m11>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m12), &TYPE::m12>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m13), &TYPE::m13>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m14), &TYPE::m14>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m15), &TYPE::m15>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m16), &TYPE::m16>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m17), &TYPE::m17>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m18), &TYPE::m18>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<18, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m19), &TYPE::m19>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<19, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m20), &TYPE::m20>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<20, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m21), &TYPE::m21>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<21, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m22), &TYPE::m22>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<22, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m23), &TYPE::m23>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<23, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m24), &TYPE::m24>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<24, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m25), &TYPE::m25>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<25, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m26), &TYPE::m26>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<26, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m27), &TYPE::m27>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<27, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m28), &TYPE::m28>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<28, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m29), &TYPE::m29>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<29, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m30), &TYPE::m30>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<30, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m31), &TYPE::m31>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<31, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m32), &TYPE::m32>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<32, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m33), &TYPE::m33>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<33, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m34), &TYPE::m34>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<34, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m35), &TYPE::m35>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<35, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m36), &TYPE::m36>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<36, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m37), &TYPE::m37>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<37, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m38), &TYPE::m38>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<38, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m39), &TYPE::m39>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<39, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m40), &TYPE::m40>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<40, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m41), &TYPE::m41>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<41, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m42), &TYPE::m42>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<42, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m43), &TYPE::m43>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<43, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m44), &TYPE::m44>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<44, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m45), &TYPE::m45>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<45, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m46), &TYPE::m46>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<46, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m47), &TYPE::m47>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<47, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m48), &TYPE::m48>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<48, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m49), &TYPE::m49>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<49, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m50), &TYPE::m50>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<50, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m51), &TYPE::m51>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<51, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m52), &TYPE::m52>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<52, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m53), &TYPE::m53>{})\
                );                                                                                \
            }                                                                                     \
        };                                                                                        \
    }}                                                                                            \
/**/

#define BOOST_HANA_ADAPT_STRUCT_IMPL_55(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21, m22, m23, m24, m25, m26, m27, m28, m29, m30, m31, m32, m33, m34, m35, m36, m37, m38, m39, m40, m41, m42, m43, m44, m45, m46, m47, m48, m49, m50, m51, m52, m53, m54)    \
    namespace boost { namespace hana {                                                            \
        template <>                                                                               \
        struct accessors_impl<TYPE> {                                                             \
            static constexpr auto apply() {                                                       \
                struct member_names {                                                             \
                  static constexpr auto get() {                                                   \
                      return ::boost::hana::make_tuple(                                           \
                          BOOST_HANA_PP_STRINGIZE(m1), BOOST_HANA_PP_STRINGIZE(m2), BOOST_HANA_PP_STRINGIZE(m3), BOOST_HANA_PP_STRINGIZE(m4), BOOST_HANA_PP_STRINGIZE(m5), BOOST_HANA_PP_STRINGIZE(m6), BOOST_HANA_PP_STRINGIZE(m7), BOOST_HANA_PP_STRINGIZE(m8), BOOST_HANA_PP_STRINGIZE(m9), BOOST_HANA_PP_STRINGIZE(m10), BOOST_HANA_PP_STRINGIZE(m11), BOOST_HANA_PP_STRINGIZE(m12), BOOST_HANA_PP_STRINGIZE(m13), BOOST_HANA_PP_STRINGIZE(m14), BOOST_HANA_PP_STRINGIZE(m15), BOOST_HANA_PP_STRINGIZE(m16), BOOST_HANA_PP_STRINGIZE(m17), BOOST_HANA_PP_STRINGIZE(m18), BOOST_HANA_PP_STRINGIZE(m19), BOOST_HANA_PP_STRINGIZE(m20), BOOST_HANA_PP_STRINGIZE(m21), BOOST_HANA_PP_STRINGIZE(m22), BOOST_HANA_PP_STRINGIZE(m23), BOOST_HANA_PP_STRINGIZE(m24), BOOST_HANA_PP_STRINGIZE(m25), BOOST_HANA_PP_STRINGIZE(m26), BOOST_HANA_PP_STRINGIZE(m27), BOOST_HANA_PP_STRINGIZE(m28), BOOST_HANA_PP_STRINGIZE(m29), BOOST_HANA_PP_STRINGIZE(m30), BOOST_HANA_PP_STRINGIZE(m31), BOOST_HANA_PP_STRINGIZE(m32), BOOST_HANA_PP_STRINGIZE(m33), BOOST_HANA_PP_STRINGIZE(m34), BOOST_HANA_PP_STRINGIZE(m35), BOOST_HANA_PP_STRINGIZE(m36), BOOST_HANA_PP_STRINGIZE(m37), BOOST_HANA_PP_STRINGIZE(m38), BOOST_HANA_PP_STRINGIZE(m39), BOOST_HANA_PP_STRINGIZE(m40), BOOST_HANA_PP_STRINGIZE(m41), BOOST_HANA_PP_STRINGIZE(m42), BOOST_HANA_PP_STRINGIZE(m43), BOOST_HANA_PP_STRINGIZE(m44), BOOST_HANA_PP_STRINGIZE(m45), BOOST_HANA_PP_STRINGIZE(m46), BOOST_HANA_PP_STRINGIZE(m47), BOOST_HANA_PP_STRINGIZE(m48), BOOST_HANA_PP_STRINGIZE(m49), BOOST_HANA_PP_STRINGIZE(m50), BOOST_HANA_PP_STRINGIZE(m51), BOOST_HANA_PP_STRINGIZE(m52), BOOST_HANA_PP_STRINGIZE(m53), BOOST_HANA_PP_STRINGIZE(m54)   \
                      );                                                                          \
                  }                                                                               \
                };                                                                                \
                return ::boost::hana::make_tuple(                                                 \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m1), &TYPE::m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m2), &TYPE::m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m3), &TYPE::m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m4), &TYPE::m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m5), &TYPE::m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m6), &TYPE::m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m7), &TYPE::m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m8), &TYPE::m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m9), &TYPE::m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m10), &TYPE::m10>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m11), &TYPE::m11>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m12), &TYPE::m12>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m13), &TYPE::m13>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m14), &TYPE::m14>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m15), &TYPE::m15>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m16), &TYPE::m16>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m17), &TYPE::m17>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m18), &TYPE::m18>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<18, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m19), &TYPE::m19>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<19, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m20), &TYPE::m20>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<20, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m21), &TYPE::m21>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<21, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m22), &TYPE::m22>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<22, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m23), &TYPE::m23>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<23, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m24), &TYPE::m24>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<24, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m25), &TYPE::m25>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<25, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m26), &TYPE::m26>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<26, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m27), &TYPE::m27>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<27, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m28), &TYPE::m28>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<28, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m29), &TYPE::m29>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<29, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m30), &TYPE::m30>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<30, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m31), &TYPE::m31>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<31, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m32), &TYPE::m32>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<32, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m33), &TYPE::m33>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<33, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m34), &TYPE::m34>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<34, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m35), &TYPE::m35>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<35, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m36), &TYPE::m36>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<36, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m37), &TYPE::m37>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<37, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m38), &TYPE::m38>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<38, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m39), &TYPE::m39>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<39, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m40), &TYPE::m40>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<40, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m41), &TYPE::m41>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<41, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m42), &TYPE::m42>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<42, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m43), &TYPE::m43>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<43, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m44), &TYPE::m44>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<44, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m45), &TYPE::m45>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<45, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m46), &TYPE::m46>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<46, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m47), &TYPE::m47>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<47, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m48), &TYPE::m48>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<48, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m49), &TYPE::m49>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<49, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m50), &TYPE::m50>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<50, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m51), &TYPE::m51>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<51, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m52), &TYPE::m52>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<52, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m53), &TYPE::m53>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<53, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m54), &TYPE::m54>{})\
                );                                                                                \
            }                                                                                     \
        };                                                                                        \
    }}                                                                                            \
/**/

#define BOOST_HANA_ADAPT_STRUCT_IMPL_56(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21, m22, m23, m24, m25, m26, m27, m28, m29, m30, m31, m32, m33, m34, m35, m36, m37, m38, m39, m40, m41, m42, m43, m44, m45, m46, m47, m48, m49, m50, m51, m52, m53, m54, m55)    \
    namespace boost { namespace hana {                                                            \
        template <>                                                                               \
        struct accessors_impl<TYPE> {                                                             \
            static constexpr auto apply() {                                                       \
                struct member_names {                                                             \
                  static constexpr auto get() {                                                   \
                      return ::boost::hana::make_tuple(                                           \
                          BOOST_HANA_PP_STRINGIZE(m1), BOOST_HANA_PP_STRINGIZE(m2), BOOST_HANA_PP_STRINGIZE(m3), BOOST_HANA_PP_STRINGIZE(m4), BOOST_HANA_PP_STRINGIZE(m5), BOOST_HANA_PP_STRINGIZE(m6), BOOST_HANA_PP_STRINGIZE(m7), BOOST_HANA_PP_STRINGIZE(m8), BOOST_HANA_PP_STRINGIZE(m9), BOOST_HANA_PP_STRINGIZE(m10), BOOST_HANA_PP_STRINGIZE(m11), BOOST_HANA_PP_STRINGIZE(m12), BOOST_HANA_PP_STRINGIZE(m13), BOOST_HANA_PP_STRINGIZE(m14), BOOST_HANA_PP_STRINGIZE(m15), BOOST_HANA_PP_STRINGIZE(m16), BOOST_HANA_PP_STRINGIZE(m17), BOOST_HANA_PP_STRINGIZE(m18), BOOST_HANA_PP_STRINGIZE(m19), BOOST_HANA_PP_STRINGIZE(m20), BOOST_HANA_PP_STRINGIZE(m21), BOOST_HANA_PP_STRINGIZE(m22), BOOST_HANA_PP_STRINGIZE(m23), BOOST_HANA_PP_STRINGIZE(m24), BOOST_HANA_PP_STRINGIZE(m25), BOOST_HANA_PP_STRINGIZE(m26), BOOST_HANA_PP_STRINGIZE(m27), BOOST_HANA_PP_STRINGIZE(m28), BOOST_HANA_PP_STRINGIZE(m29), BOOST_HANA_PP_STRINGIZE(m30), BOOST_HANA_PP_STRINGIZE(m31), BOOST_HANA_PP_STRINGIZE(m32), BOOST_HANA_PP_STRINGIZE(m33), BOOST_HANA_PP_STRINGIZE(m34), BOOST_HANA_PP_STRINGIZE(m35), BOOST_HANA_PP_STRINGIZE(m36), BOOST_HANA_PP_STRINGIZE(m37), BOOST_HANA_PP_STRINGIZE(m38), BOOST_HANA_PP_STRINGIZE(m39), BOOST_HANA_PP_STRINGIZE(m40), BOOST_HANA_PP_STRINGIZE(m41), BOOST_HANA_PP_STRINGIZE(m42), BOOST_HANA_PP_STRINGIZE(m43), BOOST_HANA_PP_STRINGIZE(m44), BOOST_HANA_PP_STRINGIZE(m45), BOOST_HANA_PP_STRINGIZE(m46), BOOST_HANA_PP_STRINGIZE(m47), BOOST_HANA_PP_STRINGIZE(m48), BOOST_HANA_PP_STRINGIZE(m49), BOOST_HANA_PP_STRINGIZE(m50), BOOST_HANA_PP_STRINGIZE(m51), BOOST_HANA_PP_STRINGIZE(m52), BOOST_HANA_PP_STRINGIZE(m53), BOOST_HANA_PP_STRINGIZE(m54), BOOST_HANA_PP_STRINGIZE(m55)   \
                      );                                                                          \
                  }                                                                               \
                };                                                                                \
                return ::boost::hana::make_tuple(                                                 \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m1), &TYPE::m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m2), &TYPE::m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m3), &TYPE::m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m4), &TYPE::m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m5), &TYPE::m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m6), &TYPE::m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m7), &TYPE::m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m8), &TYPE::m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m9), &TYPE::m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m10), &TYPE::m10>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m11), &TYPE::m11>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m12), &TYPE::m12>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m13), &TYPE::m13>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m14), &TYPE::m14>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m15), &TYPE::m15>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m16), &TYPE::m16>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m17), &TYPE::m17>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m18), &TYPE::m18>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<18, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m19), &TYPE::m19>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<19, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m20), &TYPE::m20>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<20, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m21), &TYPE::m21>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<21, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m22), &TYPE::m22>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<22, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m23), &TYPE::m23>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<23, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m24), &TYPE::m24>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<24, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m25), &TYPE::m25>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<25, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m26), &TYPE::m26>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<26, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m27), &TYPE::m27>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<27, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m28), &TYPE::m28>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<28, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m29), &TYPE::m29>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<29, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m30), &TYPE::m30>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<30, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m31), &TYPE::m31>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<31, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m32), &TYPE::m32>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<32, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m33), &TYPE::m33>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<33, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m34), &TYPE::m34>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<34, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m35), &TYPE::m35>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<35, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m36), &TYPE::m36>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<36, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m37), &TYPE::m37>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<37, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m38), &TYPE::m38>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<38, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m39), &TYPE::m39>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<39, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m40), &TYPE::m40>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<40, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m41), &TYPE::m41>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<41, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m42), &TYPE::m42>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<42, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m43), &TYPE::m43>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<43, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m44), &TYPE::m44>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<44, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m45), &TYPE::m45>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<45, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m46), &TYPE::m46>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<46, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m47), &TYPE::m47>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<47, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m48), &TYPE::m48>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<48, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m49), &TYPE::m49>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<49, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m50), &TYPE::m50>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<50, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m51), &TYPE::m51>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<51, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m52), &TYPE::m52>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<52, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m53), &TYPE::m53>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<53, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m54), &TYPE::m54>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<54, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m55), &TYPE::m55>{})\
                );                                                                                \
            }                                                                                     \
        };                                                                                        \
    }}                                                                                            \
/**/

#define BOOST_HANA_ADAPT_STRUCT_IMPL_57(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21, m22, m23, m24, m25, m26, m27, m28, m29, m30, m31, m32, m33, m34, m35, m36, m37, m38, m39, m40, m41, m42, m43, m44, m45, m46, m47, m48, m49, m50, m51, m52, m53, m54, m55, m56)    \
    namespace boost { namespace hana {                                                            \
        template <>                                                                               \
        struct accessors_impl<TYPE> {                                                             \
            static constexpr auto apply() {                                                       \
                struct member_names {                                                             \
                  static constexpr auto get() {                                                   \
                      return ::boost::hana::make_tuple(                                           \
                          BOOST_HANA_PP_STRINGIZE(m1), BOOST_HANA_PP_STRINGIZE(m2), BOOST_HANA_PP_STRINGIZE(m3), BOOST_HANA_PP_STRINGIZE(m4), BOOST_HANA_PP_STRINGIZE(m5), BOOST_HANA_PP_STRINGIZE(m6), BOOST_HANA_PP_STRINGIZE(m7), BOOST_HANA_PP_STRINGIZE(m8), BOOST_HANA_PP_STRINGIZE(m9), BOOST_HANA_PP_STRINGIZE(m10), BOOST_HANA_PP_STRINGIZE(m11), BOOST_HANA_PP_STRINGIZE(m12), BOOST_HANA_PP_STRINGIZE(m13), BOOST_HANA_PP_STRINGIZE(m14), BOOST_HANA_PP_STRINGIZE(m15), BOOST_HANA_PP_STRINGIZE(m16), BOOST_HANA_PP_STRINGIZE(m17), BOOST_HANA_PP_STRINGIZE(m18), BOOST_HANA_PP_STRINGIZE(m19), BOOST_HANA_PP_STRINGIZE(m20), BOOST_HANA_PP_STRINGIZE(m21), BOOST_HANA_PP_STRINGIZE(m22), BOOST_HANA_PP_STRINGIZE(m23), BOOST_HANA_PP_STRINGIZE(m24), BOOST_HANA_PP_STRINGIZE(m25), BOOST_HANA_PP_STRINGIZE(m26), BOOST_HANA_PP_STRINGIZE(m27), BOOST_HANA_PP_STRINGIZE(m28), BOOST_HANA_PP_STRINGIZE(m29), BOOST_HANA_PP_STRINGIZE(m30), BOOST_HANA_PP_STRINGIZE(m31), BOOST_HANA_PP_STRINGIZE(m32), BOOST_HANA_PP_STRINGIZE(m33), BOOST_HANA_PP_STRINGIZE(m34), BOOST_HANA_PP_STRINGIZE(m35), BOOST_HANA_PP_STRINGIZE(m36), BOOST_HANA_PP_STRINGIZE(m37), BOOST_HANA_PP_STRINGIZE(m38), BOOST_HANA_PP_STRINGIZE(m39), BOOST_HANA_PP_STRINGIZE(m40), BOOST_HANA_PP_STRINGIZE(m41), BOOST_HANA_PP_STRINGIZE(m42), BOOST_HANA_PP_STRINGIZE(m43), BOOST_HANA_PP_STRINGIZE(m44), BOOST_HANA_PP_STRINGIZE(m45), BOOST_HANA_PP_STRINGIZE(m46), BOOST_HANA_PP_STRINGIZE(m47), BOOST_HANA_PP_STRINGIZE(m48), BOOST_HANA_PP_STRINGIZE(m49), BOOST_HANA_PP_STRINGIZE(m50), BOOST_HANA_PP_STRINGIZE(m51), BOOST_HANA_PP_STRINGIZE(m52), BOOST_HANA_PP_STRINGIZE(m53), BOOST_HANA_PP_STRINGIZE(m54), BOOST_HANA_PP_STRINGIZE(m55), BOOST_HANA_PP_STRINGIZE(m56)   \
                      );                                                                          \
                  }                                                                               \
                };                                                                                \
                return ::boost::hana::make_tuple(                                                 \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m1), &TYPE::m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m2), &TYPE::m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m3), &TYPE::m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m4), &TYPE::m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m5), &TYPE::m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m6), &TYPE::m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m7), &TYPE::m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m8), &TYPE::m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m9), &TYPE::m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m10), &TYPE::m10>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m11), &TYPE::m11>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m12), &TYPE::m12>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m13), &TYPE::m13>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m14), &TYPE::m14>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m15), &TYPE::m15>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m16), &TYPE::m16>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m17), &TYPE::m17>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m18), &TYPE::m18>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<18, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m19), &TYPE::m19>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<19, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m20), &TYPE::m20>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<20, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m21), &TYPE::m21>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<21, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m22), &TYPE::m22>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<22, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m23), &TYPE::m23>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<23, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m24), &TYPE::m24>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<24, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m25), &TYPE::m25>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<25, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m26), &TYPE::m26>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<26, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m27), &TYPE::m27>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<27, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m28), &TYPE::m28>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<28, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m29), &TYPE::m29>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<29, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m30), &TYPE::m30>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<30, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m31), &TYPE::m31>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<31, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m32), &TYPE::m32>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<32, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m33), &TYPE::m33>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<33, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m34), &TYPE::m34>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<34, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m35), &TYPE::m35>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<35, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m36), &TYPE::m36>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<36, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m37), &TYPE::m37>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<37, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m38), &TYPE::m38>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<38, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m39), &TYPE::m39>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<39, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m40), &TYPE::m40>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<40, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m41), &TYPE::m41>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<41, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m42), &TYPE::m42>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<42, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m43), &TYPE::m43>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<43, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m44), &TYPE::m44>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<44, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m45), &TYPE::m45>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<45, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m46), &TYPE::m46>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<46, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m47), &TYPE::m47>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<47, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m48), &TYPE::m48>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<48, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m49), &TYPE::m49>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<49, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m50), &TYPE::m50>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<50, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m51), &TYPE::m51>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<51, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m52), &TYPE::m52>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<52, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m53), &TYPE::m53>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<53, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m54), &TYPE::m54>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<54, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m55), &TYPE::m55>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<55, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m56), &TYPE::m56>{})\
                );                                                                                \
            }                                                                                     \
        };                                                                                        \
    }}                                                                                            \
/**/

#define BOOST_HANA_ADAPT_STRUCT_IMPL_58(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21, m22, m23, m24, m25, m26, m27, m28, m29, m30, m31, m32, m33, m34, m35, m36, m37, m38, m39, m40, m41, m42, m43, m44, m45, m46, m47, m48, m49, m50, m51, m52, m53, m54, m55, m56, m57)    \
    namespace boost { namespace hana {                                                            \
        template <>                                                                               \
        struct accessors_impl<TYPE> {                                                             \
            static constexpr auto apply() {                                                       \
                struct member_names {                                                             \
                  static constexpr auto get() {                                                   \
                      return ::boost::hana::make_tuple(                                           \
                          BOOST_HANA_PP_STRINGIZE(m1), BOOST_HANA_PP_STRINGIZE(m2), BOOST_HANA_PP_STRINGIZE(m3), BOOST_HANA_PP_STRINGIZE(m4), BOOST_HANA_PP_STRINGIZE(m5), BOOST_HANA_PP_STRINGIZE(m6), BOOST_HANA_PP_STRINGIZE(m7), BOOST_HANA_PP_STRINGIZE(m8), BOOST_HANA_PP_STRINGIZE(m9), BOOST_HANA_PP_STRINGIZE(m10), BOOST_HANA_PP_STRINGIZE(m11), BOOST_HANA_PP_STRINGIZE(m12), BOOST_HANA_PP_STRINGIZE(m13), BOOST_HANA_PP_STRINGIZE(m14), BOOST_HANA_PP_STRINGIZE(m15), BOOST_HANA_PP_STRINGIZE(m16), BOOST_HANA_PP_STRINGIZE(m17), BOOST_HANA_PP_STRINGIZE(m18), BOOST_HANA_PP_STRINGIZE(m19), BOOST_HANA_PP_STRINGIZE(m20), BOOST_HANA_PP_STRINGIZE(m21), BOOST_HANA_PP_STRINGIZE(m22), BOOST_HANA_PP_STRINGIZE(m23), BOOST_HANA_PP_STRINGIZE(m24), BOOST_HANA_PP_STRINGIZE(m25), BOOST_HANA_PP_STRINGIZE(m26), BOOST_HANA_PP_STRINGIZE(m27), BOOST_HANA_PP_STRINGIZE(m28), BOOST_HANA_PP_STRINGIZE(m29), BOOST_HANA_PP_STRINGIZE(m30), BOOST_HANA_PP_STRINGIZE(m31), BOOST_HANA_PP_STRINGIZE(m32), BOOST_HANA_PP_STRINGIZE(m33), BOOST_HANA_PP_STRINGIZE(m34), BOOST_HANA_PP_STRINGIZE(m35), BOOST_HANA_PP_STRINGIZE(m36), BOOST_HANA_PP_STRINGIZE(m37), BOOST_HANA_PP_STRINGIZE(m38), BOOST_HANA_PP_STRINGIZE(m39), BOOST_HANA_PP_STRINGIZE(m40), BOOST_HANA_PP_STRINGIZE(m41), BOOST_HANA_PP_STRINGIZE(m42), BOOST_HANA_PP_STRINGIZE(m43), BOOST_HANA_PP_STRINGIZE(m44), BOOST_HANA_PP_STRINGIZE(m45), BOOST_HANA_PP_STRINGIZE(m46), BOOST_HANA_PP_STRINGIZE(m47), BOOST_HANA_PP_STRINGIZE(m48), BOOST_HANA_PP_STRINGIZE(m49), BOOST_HANA_PP_STRINGIZE(m50), BOOST_HANA_PP_STRINGIZE(m51), BOOST_HANA_PP_STRINGIZE(m52), BOOST_HANA_PP_STRINGIZE(m53), BOOST_HANA_PP_STRINGIZE(m54), BOOST_HANA_PP_STRINGIZE(m55), BOOST_HANA_PP_STRINGIZE(m56), BOOST_HANA_PP_STRINGIZE(m57)   \
                      );                                                                          \
                  }                                                                               \
                };                                                                                \
                return ::boost::hana::make_tuple(                                                 \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m1), &TYPE::m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m2), &TYPE::m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m3), &TYPE::m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m4), &TYPE::m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m5), &TYPE::m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m6), &TYPE::m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m7), &TYPE::m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m8), &TYPE::m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m9), &TYPE::m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m10), &TYPE::m10>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m11), &TYPE::m11>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m12), &TYPE::m12>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m13), &TYPE::m13>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m14), &TYPE::m14>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m15), &TYPE::m15>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m16), &TYPE::m16>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m17), &TYPE::m17>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m18), &TYPE::m18>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<18, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m19), &TYPE::m19>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<19, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m20), &TYPE::m20>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<20, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m21), &TYPE::m21>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<21, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m22), &TYPE::m22>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<22, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m23), &TYPE::m23>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<23, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m24), &TYPE::m24>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<24, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m25), &TYPE::m25>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<25, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m26), &TYPE::m26>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<26, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m27), &TYPE::m27>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<27, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m28), &TYPE::m28>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<28, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m29), &TYPE::m29>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<29, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m30), &TYPE::m30>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<30, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m31), &TYPE::m31>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<31, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m32), &TYPE::m32>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<32, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m33), &TYPE::m33>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<33, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m34), &TYPE::m34>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<34, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m35), &TYPE::m35>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<35, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m36), &TYPE::m36>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<36, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m37), &TYPE::m37>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<37, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m38), &TYPE::m38>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<38, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m39), &TYPE::m39>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<39, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m40), &TYPE::m40>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<40, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m41), &TYPE::m41>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<41, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m42), &TYPE::m42>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<42, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m43), &TYPE::m43>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<43, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m44), &TYPE::m44>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<44, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m45), &TYPE::m45>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<45, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m46), &TYPE::m46>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<46, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m47), &TYPE::m47>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<47, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m48), &TYPE::m48>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<48, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m49), &TYPE::m49>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<49, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m50), &TYPE::m50>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<50, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m51), &TYPE::m51>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<51, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m52), &TYPE::m52>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<52, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m53), &TYPE::m53>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<53, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m54), &TYPE::m54>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<54, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m55), &TYPE::m55>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<55, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m56), &TYPE::m56>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<56, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m57), &TYPE::m57>{})\
                );                                                                                \
            }                                                                                     \
        };                                                                                        \
    }}                                                                                            \
/**/

#define BOOST_HANA_ADAPT_STRUCT_IMPL_59(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21, m22, m23, m24, m25, m26, m27, m28, m29, m30, m31, m32, m33, m34, m35, m36, m37, m38, m39, m40, m41, m42, m43, m44, m45, m46, m47, m48, m49, m50, m51, m52, m53, m54, m55, m56, m57, m58)    \
    namespace boost { namespace hana {                                                            \
        template <>                                                                               \
        struct accessors_impl<TYPE> {                                                             \
            static constexpr auto apply() {                                                       \
                struct member_names {                                                             \
                  static constexpr auto get() {                                                   \
                      return ::boost::hana::make_tuple(                                           \
                          BOOST_HANA_PP_STRINGIZE(m1), BOOST_HANA_PP_STRINGIZE(m2), BOOST_HANA_PP_STRINGIZE(m3), BOOST_HANA_PP_STRINGIZE(m4), BOOST_HANA_PP_STRINGIZE(m5), BOOST_HANA_PP_STRINGIZE(m6), BOOST_HANA_PP_STRINGIZE(m7), BOOST_HANA_PP_STRINGIZE(m8), BOOST_HANA_PP_STRINGIZE(m9), BOOST_HANA_PP_STRINGIZE(m10), BOOST_HANA_PP_STRINGIZE(m11), BOOST_HANA_PP_STRINGIZE(m12), BOOST_HANA_PP_STRINGIZE(m13), BOOST_HANA_PP_STRINGIZE(m14), BOOST_HANA_PP_STRINGIZE(m15), BOOST_HANA_PP_STRINGIZE(m16), BOOST_HANA_PP_STRINGIZE(m17), BOOST_HANA_PP_STRINGIZE(m18), BOOST_HANA_PP_STRINGIZE(m19), BOOST_HANA_PP_STRINGIZE(m20), BOOST_HANA_PP_STRINGIZE(m21), BOOST_HANA_PP_STRINGIZE(m22), BOOST_HANA_PP_STRINGIZE(m23), BOOST_HANA_PP_STRINGIZE(m24), BOOST_HANA_PP_STRINGIZE(m25), BOOST_HANA_PP_STRINGIZE(m26), BOOST_HANA_PP_STRINGIZE(m27), BOOST_HANA_PP_STRINGIZE(m28), BOOST_HANA_PP_STRINGIZE(m29), BOOST_HANA_PP_STRINGIZE(m30), BOOST_HANA_PP_STRINGIZE(m31), BOOST_HANA_PP_STRINGIZE(m32), BOOST_HANA_PP_STRINGIZE(m33), BOOST_HANA_PP_STRINGIZE(m34), BOOST_HANA_PP_STRINGIZE(m35), BOOST_HANA_PP_STRINGIZE(m36), BOOST_HANA_PP_STRINGIZE(m37), BOOST_HANA_PP_STRINGIZE(m38), BOOST_HANA_PP_STRINGIZE(m39), BOOST_HANA_PP_STRINGIZE(m40), BOOST_HANA_PP_STRINGIZE(m41), BOOST_HANA_PP_STRINGIZE(m42), BOOST_HANA_PP_STRINGIZE(m43), BOOST_HANA_PP_STRINGIZE(m44), BOOST_HANA_PP_STRINGIZE(m45), BOOST_HANA_PP_STRINGIZE(m46), BOOST_HANA_PP_STRINGIZE(m47), BOOST_HANA_PP_STRINGIZE(m48), BOOST_HANA_PP_STRINGIZE(m49), BOOST_HANA_PP_STRINGIZE(m50), BOOST_HANA_PP_STRINGIZE(m51), BOOST_HANA_PP_STRINGIZE(m52), BOOST_HANA_PP_STRINGIZE(m53), BOOST_HANA_PP_STRINGIZE(m54), BOOST_HANA_PP_STRINGIZE(m55), BOOST_HANA_PP_STRINGIZE(m56), BOOST_HANA_PP_STRINGIZE(m57), BOOST_HANA_PP_STRINGIZE(m58)   \
                      );                                                                          \
                  }                                                                               \
                };                                                                                \
                return ::boost::hana::make_tuple(                                                 \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m1), &TYPE::m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m2), &TYPE::m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m3), &TYPE::m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m4), &TYPE::m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m5), &TYPE::m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m6), &TYPE::m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m7), &TYPE::m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m8), &TYPE::m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m9), &TYPE::m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m10), &TYPE::m10>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m11), &TYPE::m11>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m12), &TYPE::m12>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m13), &TYPE::m13>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m14), &TYPE::m14>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m15), &TYPE::m15>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m16), &TYPE::m16>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m17), &TYPE::m17>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m18), &TYPE::m18>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<18, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m19), &TYPE::m19>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<19, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m20), &TYPE::m20>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<20, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m21), &TYPE::m21>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<21, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m22), &TYPE::m22>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<22, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m23), &TYPE::m23>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<23, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m24), &TYPE::m24>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<24, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m25), &TYPE::m25>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<25, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m26), &TYPE::m26>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<26, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m27), &TYPE::m27>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<27, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m28), &TYPE::m28>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<28, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m29), &TYPE::m29>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<29, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m30), &TYPE::m30>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<30, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m31), &TYPE::m31>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<31, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m32), &TYPE::m32>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<32, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m33), &TYPE::m33>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<33, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m34), &TYPE::m34>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<34, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m35), &TYPE::m35>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<35, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m36), &TYPE::m36>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<36, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m37), &TYPE::m37>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<37, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m38), &TYPE::m38>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<38, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m39), &TYPE::m39>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<39, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m40), &TYPE::m40>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<40, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m41), &TYPE::m41>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<41, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m42), &TYPE::m42>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<42, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m43), &TYPE::m43>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<43, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m44), &TYPE::m44>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<44, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m45), &TYPE::m45>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<45, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m46), &TYPE::m46>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<46, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m47), &TYPE::m47>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<47, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m48), &TYPE::m48>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<48, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m49), &TYPE::m49>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<49, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m50), &TYPE::m50>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<50, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m51), &TYPE::m51>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<51, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m52), &TYPE::m52>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<52, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m53), &TYPE::m53>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<53, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m54), &TYPE::m54>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<54, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m55), &TYPE::m55>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<55, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m56), &TYPE::m56>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<56, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m57), &TYPE::m57>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<57, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m58), &TYPE::m58>{})\
                );                                                                                \
            }                                                                                     \
        };                                                                                        \
    }}                                                                                            \
/**/

#define BOOST_HANA_ADAPT_STRUCT_IMPL_60(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21, m22, m23, m24, m25, m26, m27, m28, m29, m30, m31, m32, m33, m34, m35, m36, m37, m38, m39, m40, m41, m42, m43, m44, m45, m46, m47, m48, m49, m50, m51, m52, m53, m54, m55, m56, m57, m58, m59)    \
    namespace boost { namespace hana {                                                            \
        template <>                                                                               \
        struct accessors_impl<TYPE> {                                                             \
            static constexpr auto apply() {                                                       \
                struct member_names {                                                             \
                  static constexpr auto get() {                                                   \
                      return ::boost::hana::make_tuple(                                           \
                          BOOST_HANA_PP_STRINGIZE(m1), BOOST_HANA_PP_STRINGIZE(m2), BOOST_HANA_PP_STRINGIZE(m3), BOOST_HANA_PP_STRINGIZE(m4), BOOST_HANA_PP_STRINGIZE(m5), BOOST_HANA_PP_STRINGIZE(m6), BOOST_HANA_PP_STRINGIZE(m7), BOOST_HANA_PP_STRINGIZE(m8), BOOST_HANA_PP_STRINGIZE(m9), BOOST_HANA_PP_STRINGIZE(m10), BOOST_HANA_PP_STRINGIZE(m11), BOOST_HANA_PP_STRINGIZE(m12), BOOST_HANA_PP_STRINGIZE(m13), BOOST_HANA_PP_STRINGIZE(m14), BOOST_HANA_PP_STRINGIZE(m15), BOOST_HANA_PP_STRINGIZE(m16), BOOST_HANA_PP_STRINGIZE(m17), BOOST_HANA_PP_STRINGIZE(m18), BOOST_HANA_PP_STRINGIZE(m19), BOOST_HANA_PP_STRINGIZE(m20), BOOST_HANA_PP_STRINGIZE(m21), BOOST_HANA_PP_STRINGIZE(m22), BOOST_HANA_PP_STRINGIZE(m23), BOOST_HANA_PP_STRINGIZE(m24), BOOST_HANA_PP_STRINGIZE(m25), BOOST_HANA_PP_STRINGIZE(m26), BOOST_HANA_PP_STRINGIZE(m27), BOOST_HANA_PP_STRINGIZE(m28), BOOST_HANA_PP_STRINGIZE(m29), BOOST_HANA_PP_STRINGIZE(m30), BOOST_HANA_PP_STRINGIZE(m31), BOOST_HANA_PP_STRINGIZE(m32), BOOST_HANA_PP_STRINGIZE(m33), BOOST_HANA_PP_STRINGIZE(m34), BOOST_HANA_PP_STRINGIZE(m35), BOOST_HANA_PP_STRINGIZE(m36), BOOST_HANA_PP_STRINGIZE(m37), BOOST_HANA_PP_STRINGIZE(m38), BOOST_HANA_PP_STRINGIZE(m39), BOOST_HANA_PP_STRINGIZE(m40), BOOST_HANA_PP_STRINGIZE(m41), BOOST_HANA_PP_STRINGIZE(m42), BOOST_HANA_PP_STRINGIZE(m43), BOOST_HANA_PP_STRINGIZE(m44), BOOST_HANA_PP_STRINGIZE(m45), BOOST_HANA_PP_STRINGIZE(m46), BOOST_HANA_PP_STRINGIZE(m47), BOOST_HANA_PP_STRINGIZE(m48), BOOST_HANA_PP_STRINGIZE(m49), BOOST_HANA_PP_STRINGIZE(m50), BOOST_HANA_PP_STRINGIZE(m51), BOOST_HANA_PP_STRINGIZE(m52), BOOST_HANA_PP_STRINGIZE(m53), BOOST_HANA_PP_STRINGIZE(m54), BOOST_HANA_PP_STRINGIZE(m55), BOOST_HANA_PP_STRINGIZE(m56), BOOST_HANA_PP_STRINGIZE(m57), BOOST_HANA_PP_STRINGIZE(m58), BOOST_HANA_PP_STRINGIZE(m59)   \
                      );                                                                          \
                  }                                                                               \
                };                                                                                \
                return ::boost::hana::make_tuple(                                                 \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m1), &TYPE::m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m2), &TYPE::m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m3), &TYPE::m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m4), &TYPE::m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m5), &TYPE::m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m6), &TYPE::m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m7), &TYPE::m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m8), &TYPE::m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m9), &TYPE::m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m10), &TYPE::m10>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m11), &TYPE::m11>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m12), &TYPE::m12>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m13), &TYPE::m13>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m14), &TYPE::m14>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m15), &TYPE::m15>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m16), &TYPE::m16>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m17), &TYPE::m17>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m18), &TYPE::m18>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<18, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m19), &TYPE::m19>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<19, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m20), &TYPE::m20>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<20, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m21), &TYPE::m21>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<21, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m22), &TYPE::m22>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<22, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m23), &TYPE::m23>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<23, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m24), &TYPE::m24>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<24, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m25), &TYPE::m25>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<25, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m26), &TYPE::m26>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<26, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m27), &TYPE::m27>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<27, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m28), &TYPE::m28>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<28, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m29), &TYPE::m29>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<29, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m30), &TYPE::m30>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<30, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m31), &TYPE::m31>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<31, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m32), &TYPE::m32>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<32, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m33), &TYPE::m33>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<33, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m34), &TYPE::m34>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<34, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m35), &TYPE::m35>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<35, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m36), &TYPE::m36>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<36, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m37), &TYPE::m37>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<37, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m38), &TYPE::m38>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<38, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m39), &TYPE::m39>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<39, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m40), &TYPE::m40>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<40, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m41), &TYPE::m41>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<41, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m42), &TYPE::m42>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<42, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m43), &TYPE::m43>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<43, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m44), &TYPE::m44>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<44, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m45), &TYPE::m45>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<45, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m46), &TYPE::m46>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<46, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m47), &TYPE::m47>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<47, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m48), &TYPE::m48>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<48, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m49), &TYPE::m49>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<49, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m50), &TYPE::m50>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<50, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m51), &TYPE::m51>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<51, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m52), &TYPE::m52>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<52, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m53), &TYPE::m53>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<53, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m54), &TYPE::m54>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<54, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m55), &TYPE::m55>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<55, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m56), &TYPE::m56>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<56, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m57), &TYPE::m57>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<57, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m58), &TYPE::m58>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<58, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m59), &TYPE::m59>{})\
                );                                                                                \
            }                                                                                     \
        };                                                                                        \
    }}                                                                                            \
/**/

#define BOOST_HANA_ADAPT_STRUCT_IMPL_61(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21, m22, m23, m24, m25, m26, m27, m28, m29, m30, m31, m32, m33, m34, m35, m36, m37, m38, m39, m40, m41, m42, m43, m44, m45, m46, m47, m48, m49, m50, m51, m52, m53, m54, m55, m56, m57, m58, m59, m60)    \
    namespace boost { namespace hana {                                                            \
        template <>                                                                               \
        struct accessors_impl<TYPE> {                                                             \
            static constexpr auto apply() {                                                       \
                struct member_names {                                                             \
                  static constexpr auto get() {                                                   \
                      return ::boost::hana::make_tuple(                                           \
                          BOOST_HANA_PP_STRINGIZE(m1), BOOST_HANA_PP_STRINGIZE(m2), BOOST_HANA_PP_STRINGIZE(m3), BOOST_HANA_PP_STRINGIZE(m4), BOOST_HANA_PP_STRINGIZE(m5), BOOST_HANA_PP_STRINGIZE(m6), BOOST_HANA_PP_STRINGIZE(m7), BOOST_HANA_PP_STRINGIZE(m8), BOOST_HANA_PP_STRINGIZE(m9), BOOST_HANA_PP_STRINGIZE(m10), BOOST_HANA_PP_STRINGIZE(m11), BOOST_HANA_PP_STRINGIZE(m12), BOOST_HANA_PP_STRINGIZE(m13), BOOST_HANA_PP_STRINGIZE(m14), BOOST_HANA_PP_STRINGIZE(m15), BOOST_HANA_PP_STRINGIZE(m16), BOOST_HANA_PP_STRINGIZE(m17), BOOST_HANA_PP_STRINGIZE(m18), BOOST_HANA_PP_STRINGIZE(m19), BOOST_HANA_PP_STRINGIZE(m20), BOOST_HANA_PP_STRINGIZE(m21), BOOST_HANA_PP_STRINGIZE(m22), BOOST_HANA_PP_STRINGIZE(m23), BOOST_HANA_PP_STRINGIZE(m24), BOOST_HANA_PP_STRINGIZE(m25), BOOST_HANA_PP_STRINGIZE(m26), BOOST_HANA_PP_STRINGIZE(m27), BOOST_HANA_PP_STRINGIZE(m28), BOOST_HANA_PP_STRINGIZE(m29), BOOST_HANA_PP_STRINGIZE(m30), BOOST_HANA_PP_STRINGIZE(m31), BOOST_HANA_PP_STRINGIZE(m32), BOOST_HANA_PP_STRINGIZE(m33), BOOST_HANA_PP_STRINGIZE(m34), BOOST_HANA_PP_STRINGIZE(m35), BOOST_HANA_PP_STRINGIZE(m36), BOOST_HANA_PP_STRINGIZE(m37), BOOST_HANA_PP_STRINGIZE(m38), BOOST_HANA_PP_STRINGIZE(m39), BOOST_HANA_PP_STRINGIZE(m40), BOOST_HANA_PP_STRINGIZE(m41), BOOST_HANA_PP_STRINGIZE(m42), BOOST_HANA_PP_STRINGIZE(m43), BOOST_HANA_PP_STRINGIZE(m44), BOOST_HANA_PP_STRINGIZE(m45), BOOST_HANA_PP_STRINGIZE(m46), BOOST_HANA_PP_STRINGIZE(m47), BOOST_HANA_PP_STRINGIZE(m48), BOOST_HANA_PP_STRINGIZE(m49), BOOST_HANA_PP_STRINGIZE(m50), BOOST_HANA_PP_STRINGIZE(m51), BOOST_HANA_PP_STRINGIZE(m52), BOOST_HANA_PP_STRINGIZE(m53), BOOST_HANA_PP_STRINGIZE(m54), BOOST_HANA_PP_STRINGIZE(m55), BOOST_HANA_PP_STRINGIZE(m56), BOOST_HANA_PP_STRINGIZE(m57), BOOST_HANA_PP_STRINGIZE(m58), BOOST_HANA_PP_STRINGIZE(m59), BOOST_HANA_PP_STRINGIZE(m60)   \
                      );                                                                          \
                  }                                                                               \
                };                                                                                \
                return ::boost::hana::make_tuple(                                                 \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m1), &TYPE::m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m2), &TYPE::m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m3), &TYPE::m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m4), &TYPE::m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m5), &TYPE::m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m6), &TYPE::m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m7), &TYPE::m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m8), &TYPE::m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m9), &TYPE::m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m10), &TYPE::m10>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m11), &TYPE::m11>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m12), &TYPE::m12>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m13), &TYPE::m13>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m14), &TYPE::m14>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m15), &TYPE::m15>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m16), &TYPE::m16>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m17), &TYPE::m17>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m18), &TYPE::m18>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<18, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m19), &TYPE::m19>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<19, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m20), &TYPE::m20>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<20, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m21), &TYPE::m21>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<21, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m22), &TYPE::m22>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<22, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m23), &TYPE::m23>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<23, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m24), &TYPE::m24>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<24, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m25), &TYPE::m25>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<25, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m26), &TYPE::m26>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<26, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m27), &TYPE::m27>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<27, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m28), &TYPE::m28>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<28, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m29), &TYPE::m29>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<29, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m30), &TYPE::m30>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<30, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m31), &TYPE::m31>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<31, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m32), &TYPE::m32>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<32, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m33), &TYPE::m33>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<33, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m34), &TYPE::m34>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<34, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m35), &TYPE::m35>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<35, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m36), &TYPE::m36>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<36, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m37), &TYPE::m37>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<37, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m38), &TYPE::m38>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<38, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m39), &TYPE::m39>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<39, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m40), &TYPE::m40>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<40, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m41), &TYPE::m41>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<41, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m42), &TYPE::m42>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<42, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m43), &TYPE::m43>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<43, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m44), &TYPE::m44>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<44, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m45), &TYPE::m45>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<45, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m46), &TYPE::m46>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<46, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m47), &TYPE::m47>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<47, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m48), &TYPE::m48>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<48, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m49), &TYPE::m49>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<49, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m50), &TYPE::m50>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<50, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m51), &TYPE::m51>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<51, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m52), &TYPE::m52>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<52, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m53), &TYPE::m53>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<53, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m54), &TYPE::m54>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<54, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m55), &TYPE::m55>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<55, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m56), &TYPE::m56>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<56, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m57), &TYPE::m57>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<57, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m58), &TYPE::m58>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<58, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m59), &TYPE::m59>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<59, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m60), &TYPE::m60>{})\
                );                                                                                \
            }                                                                                     \
        };                                                                                        \
    }}                                                                                            \
/**/

#define BOOST_HANA_ADAPT_STRUCT_IMPL_62(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21, m22, m23, m24, m25, m26, m27, m28, m29, m30, m31, m32, m33, m34, m35, m36, m37, m38, m39, m40, m41, m42, m43, m44, m45, m46, m47, m48, m49, m50, m51, m52, m53, m54, m55, m56, m57, m58, m59, m60, m61)    \
    namespace boost { namespace hana {                                                            \
        template <>                                                                               \
        struct accessors_impl<TYPE> {                                                             \
            static constexpr auto apply() {                                                       \
                struct member_names {                                                             \
                  static constexpr auto get() {                                                   \
                      return ::boost::hana::make_tuple(                                           \
                          BOOST_HANA_PP_STRINGIZE(m1), BOOST_HANA_PP_STRINGIZE(m2), BOOST_HANA_PP_STRINGIZE(m3), BOOST_HANA_PP_STRINGIZE(m4), BOOST_HANA_PP_STRINGIZE(m5), BOOST_HANA_PP_STRINGIZE(m6), BOOST_HANA_PP_STRINGIZE(m7), BOOST_HANA_PP_STRINGIZE(m8), BOOST_HANA_PP_STRINGIZE(m9), BOOST_HANA_PP_STRINGIZE(m10), BOOST_HANA_PP_STRINGIZE(m11), BOOST_HANA_PP_STRINGIZE(m12), BOOST_HANA_PP_STRINGIZE(m13), BOOST_HANA_PP_STRINGIZE(m14), BOOST_HANA_PP_STRINGIZE(m15), BOOST_HANA_PP_STRINGIZE(m16), BOOST_HANA_PP_STRINGIZE(m17), BOOST_HANA_PP_STRINGIZE(m18), BOOST_HANA_PP_STRINGIZE(m19), BOOST_HANA_PP_STRINGIZE(m20), BOOST_HANA_PP_STRINGIZE(m21), BOOST_HANA_PP_STRINGIZE(m22), BOOST_HANA_PP_STRINGIZE(m23), BOOST_HANA_PP_STRINGIZE(m24), BOOST_HANA_PP_STRINGIZE(m25), BOOST_HANA_PP_STRINGIZE(m26), BOOST_HANA_PP_STRINGIZE(m27), BOOST_HANA_PP_STRINGIZE(m28), BOOST_HANA_PP_STRINGIZE(m29), BOOST_HANA_PP_STRINGIZE(m30), BOOST_HANA_PP_STRINGIZE(m31), BOOST_HANA_PP_STRINGIZE(m32), BOOST_HANA_PP_STRINGIZE(m33), BOOST_HANA_PP_STRINGIZE(m34), BOOST_HANA_PP_STRINGIZE(m35), BOOST_HANA_PP_STRINGIZE(m36), BOOST_HANA_PP_STRINGIZE(m37), BOOST_HANA_PP_STRINGIZE(m38), BOOST_HANA_PP_STRINGIZE(m39), BOOST_HANA_PP_STRINGIZE(m40), BOOST_HANA_PP_STRINGIZE(m41), BOOST_HANA_PP_STRINGIZE(m42), BOOST_HANA_PP_STRINGIZE(m43), BOOST_HANA_PP_STRINGIZE(m44), BOOST_HANA_PP_STRINGIZE(m45), BOOST_HANA_PP_STRINGIZE(m46), BOOST_HANA_PP_STRINGIZE(m47), BOOST_HANA_PP_STRINGIZE(m48), BOOST_HANA_PP_STRINGIZE(m49), BOOST_HANA_PP_STRINGIZE(m50), BOOST_HANA_PP_STRINGIZE(m51), BOOST_HANA_PP_STRINGIZE(m52), BOOST_HANA_PP_STRINGIZE(m53), BOOST_HANA_PP_STRINGIZE(m54), BOOST_HANA_PP_STRINGIZE(m55), BOOST_HANA_PP_STRINGIZE(m56), BOOST_HANA_PP_STRINGIZE(m57), BOOST_HANA_PP_STRINGIZE(m58), BOOST_HANA_PP_STRINGIZE(m59), BOOST_HANA_PP_STRINGIZE(m60), BOOST_HANA_PP_STRINGIZE(m61)   \
                      );                                                                          \
                  }                                                                               \
                };                                                                                \
                return ::boost::hana::make_tuple(                                                 \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m1), &TYPE::m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m2), &TYPE::m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m3), &TYPE::m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m4), &TYPE::m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m5), &TYPE::m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m6), &TYPE::m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m7), &TYPE::m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m8), &TYPE::m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m9), &TYPE::m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m10), &TYPE::m10>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m11), &TYPE::m11>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m12), &TYPE::m12>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m13), &TYPE::m13>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m14), &TYPE::m14>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m15), &TYPE::m15>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m16), &TYPE::m16>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m17), &TYPE::m17>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m18), &TYPE::m18>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<18, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m19), &TYPE::m19>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<19, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m20), &TYPE::m20>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<20, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m21), &TYPE::m21>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<21, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m22), &TYPE::m22>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<22, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m23), &TYPE::m23>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<23, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m24), &TYPE::m24>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<24, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m25), &TYPE::m25>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<25, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m26), &TYPE::m26>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<26, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m27), &TYPE::m27>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<27, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m28), &TYPE::m28>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<28, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m29), &TYPE::m29>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<29, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m30), &TYPE::m30>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<30, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m31), &TYPE::m31>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<31, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m32), &TYPE::m32>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<32, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m33), &TYPE::m33>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<33, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m34), &TYPE::m34>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<34, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m35), &TYPE::m35>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<35, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m36), &TYPE::m36>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<36, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m37), &TYPE::m37>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<37, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m38), &TYPE::m38>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<38, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m39), &TYPE::m39>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<39, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m40), &TYPE::m40>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<40, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m41), &TYPE::m41>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<41, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m42), &TYPE::m42>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<42, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m43), &TYPE::m43>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<43, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m44), &TYPE::m44>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<44, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m45), &TYPE::m45>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<45, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m46), &TYPE::m46>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<46, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m47), &TYPE::m47>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<47, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m48), &TYPE::m48>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<48, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m49), &TYPE::m49>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<49, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m50), &TYPE::m50>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<50, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m51), &TYPE::m51>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<51, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m52), &TYPE::m52>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<52, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m53), &TYPE::m53>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<53, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m54), &TYPE::m54>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<54, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m55), &TYPE::m55>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<55, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m56), &TYPE::m56>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<56, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m57), &TYPE::m57>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<57, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m58), &TYPE::m58>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<58, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m59), &TYPE::m59>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<59, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m60), &TYPE::m60>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<60, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m61), &TYPE::m61>{})\
                );                                                                                \
            }                                                                                     \
        };                                                                                        \
    }}                                                                                            \
/**/

#define BOOST_HANA_ADAPT_STRUCT_IMPL_63(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21, m22, m23, m24, m25, m26, m27, m28, m29, m30, m31, m32, m33, m34, m35, m36, m37, m38, m39, m40, m41, m42, m43, m44, m45, m46, m47, m48, m49, m50, m51, m52, m53, m54, m55, m56, m57, m58, m59, m60, m61, m62)    \
    namespace boost { namespace hana {                                                            \
        template <>                                                                               \
        struct accessors_impl<TYPE> {                                                             \
            static constexpr auto apply() {                                                       \
                struct member_names {                                                             \
                  static constexpr auto get() {                                                   \
                      return ::boost::hana::make_tuple(                                           \
                          BOOST_HANA_PP_STRINGIZE(m1), BOOST_HANA_PP_STRINGIZE(m2), BOOST_HANA_PP_STRINGIZE(m3), BOOST_HANA_PP_STRINGIZE(m4), BOOST_HANA_PP_STRINGIZE(m5), BOOST_HANA_PP_STRINGIZE(m6), BOOST_HANA_PP_STRINGIZE(m7), BOOST_HANA_PP_STRINGIZE(m8), BOOST_HANA_PP_STRINGIZE(m9), BOOST_HANA_PP_STRINGIZE(m10), BOOST_HANA_PP_STRINGIZE(m11), BOOST_HANA_PP_STRINGIZE(m12), BOOST_HANA_PP_STRINGIZE(m13), BOOST_HANA_PP_STRINGIZE(m14), BOOST_HANA_PP_STRINGIZE(m15), BOOST_HANA_PP_STRINGIZE(m16), BOOST_HANA_PP_STRINGIZE(m17), BOOST_HANA_PP_STRINGIZE(m18), BOOST_HANA_PP_STRINGIZE(m19), BOOST_HANA_PP_STRINGIZE(m20), BOOST_HANA_PP_STRINGIZE(m21), BOOST_HANA_PP_STRINGIZE(m22), BOOST_HANA_PP_STRINGIZE(m23), BOOST_HANA_PP_STRINGIZE(m24), BOOST_HANA_PP_STRINGIZE(m25), BOOST_HANA_PP_STRINGIZE(m26), BOOST_HANA_PP_STRINGIZE(m27), BOOST_HANA_PP_STRINGIZE(m28), BOOST_HANA_PP_STRINGIZE(m29), BOOST_HANA_PP_STRINGIZE(m30), BOOST_HANA_PP_STRINGIZE(m31), BOOST_HANA_PP_STRINGIZE(m32), BOOST_HANA_PP_STRINGIZE(m33), BOOST_HANA_PP_STRINGIZE(m34), BOOST_HANA_PP_STRINGIZE(m35), BOOST_HANA_PP_STRINGIZE(m36), BOOST_HANA_PP_STRINGIZE(m37), BOOST_HANA_PP_STRINGIZE(m38), BOOST_HANA_PP_STRINGIZE(m39), BOOST_HANA_PP_STRINGIZE(m40), BOOST_HANA_PP_STRINGIZE(m41), BOOST_HANA_PP_STRINGIZE(m42), BOOST_HANA_PP_STRINGIZE(m43), BOOST_HANA_PP_STRINGIZE(m44), BOOST_HANA_PP_STRINGIZE(m45), BOOST_HANA_PP_STRINGIZE(m46), BOOST_HANA_PP_STRINGIZE(m47), BOOST_HANA_PP_STRINGIZE(m48), BOOST_HANA_PP_STRINGIZE(m49), BOOST_HANA_PP_STRINGIZE(m50), BOOST_HANA_PP_STRINGIZE(m51), BOOST_HANA_PP_STRINGIZE(m52), BOOST_HANA_PP_STRINGIZE(m53), BOOST_HANA_PP_STRINGIZE(m54), BOOST_HANA_PP_STRINGIZE(m55), BOOST_HANA_PP_STRINGIZE(m56), BOOST_HANA_PP_STRINGIZE(m57), BOOST_HANA_PP_STRINGIZE(m58), BOOST_HANA_PP_STRINGIZE(m59), BOOST_HANA_PP_STRINGIZE(m60), BOOST_HANA_PP_STRINGIZE(m61), BOOST_HANA_PP_STRINGIZE(m62)   \
                      );                                                                          \
                  }                                                                               \
                };                                                                                \
                return ::boost::hana::make_tuple(                                                 \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m1), &TYPE::m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m2), &TYPE::m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m3), &TYPE::m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m4), &TYPE::m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m5), &TYPE::m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m6), &TYPE::m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m7), &TYPE::m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m8), &TYPE::m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m9), &TYPE::m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m10), &TYPE::m10>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m11), &TYPE::m11>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m12), &TYPE::m12>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m13), &TYPE::m13>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m14), &TYPE::m14>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m15), &TYPE::m15>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m16), &TYPE::m16>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m17), &TYPE::m17>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m18), &TYPE::m18>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<18, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m19), &TYPE::m19>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<19, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m20), &TYPE::m20>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<20, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m21), &TYPE::m21>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<21, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m22), &TYPE::m22>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<22, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m23), &TYPE::m23>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<23, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m24), &TYPE::m24>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<24, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m25), &TYPE::m25>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<25, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m26), &TYPE::m26>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<26, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m27), &TYPE::m27>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<27, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m28), &TYPE::m28>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<28, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m29), &TYPE::m29>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<29, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m30), &TYPE::m30>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<30, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m31), &TYPE::m31>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<31, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m32), &TYPE::m32>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<32, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m33), &TYPE::m33>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<33, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m34), &TYPE::m34>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<34, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m35), &TYPE::m35>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<35, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m36), &TYPE::m36>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<36, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m37), &TYPE::m37>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<37, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m38), &TYPE::m38>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<38, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m39), &TYPE::m39>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<39, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m40), &TYPE::m40>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<40, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m41), &TYPE::m41>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<41, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m42), &TYPE::m42>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<42, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m43), &TYPE::m43>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<43, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m44), &TYPE::m44>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<44, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m45), &TYPE::m45>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<45, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m46), &TYPE::m46>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<46, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m47), &TYPE::m47>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<47, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m48), &TYPE::m48>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<48, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m49), &TYPE::m49>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<49, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m50), &TYPE::m50>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<50, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m51), &TYPE::m51>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<51, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m52), &TYPE::m52>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<52, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m53), &TYPE::m53>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<53, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m54), &TYPE::m54>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<54, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m55), &TYPE::m55>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<55, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m56), &TYPE::m56>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<56, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m57), &TYPE::m57>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<57, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m58), &TYPE::m58>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<58, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m59), &TYPE::m59>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<59, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m60), &TYPE::m60>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<60, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m61), &TYPE::m61>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<61, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m62), &TYPE::m62>{})\
                );                                                                                \
            }                                                                                     \
        };                                                                                        \
    }}                                                                                            \
/**/

#define BOOST_HANA_ADAPT_STRUCT_IMPL_64(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21, m22, m23, m24, m25, m26, m27, m28, m29, m30, m31, m32, m33, m34, m35, m36, m37, m38, m39, m40, m41, m42, m43, m44, m45, m46, m47, m48, m49, m50, m51, m52, m53, m54, m55, m56, m57, m58, m59, m60, m61, m62, m63)    \
    namespace boost { namespace hana {                                                            \
        template <>                                                                               \
        struct accessors_impl<TYPE> {                                                             \
            static constexpr auto apply() {                                                       \
                struct member_names {                                                             \
                  static constexpr auto get() {                                                   \
                      return ::boost::hana::make_tuple(                                           \
                          BOOST_HANA_PP_STRINGIZE(m1), BOOST_HANA_PP_STRINGIZE(m2), BOOST_HANA_PP_STRINGIZE(m3), BOOST_HANA_PP_STRINGIZE(m4), BOOST_HANA_PP_STRINGIZE(m5), BOOST_HANA_PP_STRINGIZE(m6), BOOST_HANA_PP_STRINGIZE(m7), BOOST_HANA_PP_STRINGIZE(m8), BOOST_HANA_PP_STRINGIZE(m9), BOOST_HANA_PP_STRINGIZE(m10), BOOST_HANA_PP_STRINGIZE(m11), BOOST_HANA_PP_STRINGIZE(m12), BOOST_HANA_PP_STRINGIZE(m13), BOOST_HANA_PP_STRINGIZE(m14), BOOST_HANA_PP_STRINGIZE(m15), BOOST_HANA_PP_STRINGIZE(m16), BOOST_HANA_PP_STRINGIZE(m17), BOOST_HANA_PP_STRINGIZE(m18), BOOST_HANA_PP_STRINGIZE(m19), BOOST_HANA_PP_STRINGIZE(m20), BOOST_HANA_PP_STRINGIZE(m21), BOOST_HANA_PP_STRINGIZE(m22), BOOST_HANA_PP_STRINGIZE(m23), BOOST_HANA_PP_STRINGIZE(m24), BOOST_HANA_PP_STRINGIZE(m25), BOOST_HANA_PP_STRINGIZE(m26), BOOST_HANA_PP_STRINGIZE(m27), BOOST_HANA_PP_STRINGIZE(m28), BOOST_HANA_PP_STRINGIZE(m29), BOOST_HANA_PP_STRINGIZE(m30), BOOST_HANA_PP_STRINGIZE(m31), BOOST_HANA_PP_STRINGIZE(m32), BOOST_HANA_PP_STRINGIZE(m33), BOOST_HANA_PP_STRINGIZE(m34), BOOST_HANA_PP_STRINGIZE(m35), BOOST_HANA_PP_STRINGIZE(m36), BOOST_HANA_PP_STRINGIZE(m37), BOOST_HANA_PP_STRINGIZE(m38), BOOST_HANA_PP_STRINGIZE(m39), BOOST_HANA_PP_STRINGIZE(m40), BOOST_HANA_PP_STRINGIZE(m41), BOOST_HANA_PP_STRINGIZE(m42), BOOST_HANA_PP_STRINGIZE(m43), BOOST_HANA_PP_STRINGIZE(m44), BOOST_HANA_PP_STRINGIZE(m45), BOOST_HANA_PP_STRINGIZE(m46), BOOST_HANA_PP_STRINGIZE(m47), BOOST_HANA_PP_STRINGIZE(m48), BOOST_HANA_PP_STRINGIZE(m49), BOOST_HANA_PP_STRINGIZE(m50), BOOST_HANA_PP_STRINGIZE(m51), BOOST_HANA_PP_STRINGIZE(m52), BOOST_HANA_PP_STRINGIZE(m53), BOOST_HANA_PP_STRINGIZE(m54), BOOST_HANA_PP_STRINGIZE(m55), BOOST_HANA_PP_STRINGIZE(m56), BOOST_HANA_PP_STRINGIZE(m57), BOOST_HANA_PP_STRINGIZE(m58), BOOST_HANA_PP_STRINGIZE(m59), BOOST_HANA_PP_STRINGIZE(m60), BOOST_HANA_PP_STRINGIZE(m61), BOOST_HANA_PP_STRINGIZE(m62), BOOST_HANA_PP_STRINGIZE(m63)   \
                      );                                                                          \
                  }                                                                               \
                };                                                                                \
                return ::boost::hana::make_tuple(                                                 \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m1), &TYPE::m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m2), &TYPE::m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m3), &TYPE::m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m4), &TYPE::m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m5), &TYPE::m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m6), &TYPE::m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m7), &TYPE::m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m8), &TYPE::m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m9), &TYPE::m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m10), &TYPE::m10>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m11), &TYPE::m11>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m12), &TYPE::m12>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m13), &TYPE::m13>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m14), &TYPE::m14>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m15), &TYPE::m15>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m16), &TYPE::m16>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m17), &TYPE::m17>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m18), &TYPE::m18>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<18, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m19), &TYPE::m19>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<19, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m20), &TYPE::m20>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<20, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m21), &TYPE::m21>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<21, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m22), &TYPE::m22>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<22, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m23), &TYPE::m23>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<23, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m24), &TYPE::m24>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<24, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m25), &TYPE::m25>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<25, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m26), &TYPE::m26>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<26, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m27), &TYPE::m27>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<27, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m28), &TYPE::m28>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<28, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m29), &TYPE::m29>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<29, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m30), &TYPE::m30>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<30, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m31), &TYPE::m31>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<31, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m32), &TYPE::m32>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<32, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m33), &TYPE::m33>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<33, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m34), &TYPE::m34>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<34, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m35), &TYPE::m35>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<35, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m36), &TYPE::m36>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<36, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m37), &TYPE::m37>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<37, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m38), &TYPE::m38>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<38, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m39), &TYPE::m39>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<39, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m40), &TYPE::m40>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<40, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m41), &TYPE::m41>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<41, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m42), &TYPE::m42>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<42, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m43), &TYPE::m43>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<43, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m44), &TYPE::m44>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<44, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m45), &TYPE::m45>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<45, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m46), &TYPE::m46>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<46, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m47), &TYPE::m47>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<47, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m48), &TYPE::m48>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<48, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m49), &TYPE::m49>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<49, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m50), &TYPE::m50>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<50, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m51), &TYPE::m51>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<51, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m52), &TYPE::m52>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<52, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m53), &TYPE::m53>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<53, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m54), &TYPE::m54>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<54, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m55), &TYPE::m55>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<55, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m56), &TYPE::m56>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<56, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m57), &TYPE::m57>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<57, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m58), &TYPE::m58>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<58, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m59), &TYPE::m59>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<59, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m60), &TYPE::m60>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<60, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m61), &TYPE::m61>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<61, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m62), &TYPE::m62>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<62, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m63), &TYPE::m63>{})\
                );                                                                                \
            }                                                                                     \
        };                                                                                        \
    }}                                                                                            \
/**/

#define BOOST_HANA_ADAPT_STRUCT_IMPL_65(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21, m22, m23, m24, m25, m26, m27, m28, m29, m30, m31, m32, m33, m34, m35, m36, m37, m38, m39, m40, m41, m42, m43, m44, m45, m46, m47, m48, m49, m50, m51, m52, m53, m54, m55, m56, m57, m58, m59, m60, m61, m62, m63, m64)    \
    namespace boost { namespace hana {                                                            \
        template <>                                                                               \
        struct accessors_impl<TYPE> {                                                             \
            static constexpr auto apply() {                                                       \
                struct member_names {                                                             \
                  static constexpr auto get() {                                                   \
                      return ::boost::hana::make_tuple(                                           \
                          BOOST_HANA_PP_STRINGIZE(m1), BOOST_HANA_PP_STRINGIZE(m2), BOOST_HANA_PP_STRINGIZE(m3), BOOST_HANA_PP_STRINGIZE(m4), BOOST_HANA_PP_STRINGIZE(m5), BOOST_HANA_PP_STRINGIZE(m6), BOOST_HANA_PP_STRINGIZE(m7), BOOST_HANA_PP_STRINGIZE(m8), BOOST_HANA_PP_STRINGIZE(m9), BOOST_HANA_PP_STRINGIZE(m10), BOOST_HANA_PP_STRINGIZE(m11), BOOST_HANA_PP_STRINGIZE(m12), BOOST_HANA_PP_STRINGIZE(m13), BOOST_HANA_PP_STRINGIZE(m14), BOOST_HANA_PP_STRINGIZE(m15), BOOST_HANA_PP_STRINGIZE(m16), BOOST_HANA_PP_STRINGIZE(m17), BOOST_HANA_PP_STRINGIZE(m18), BOOST_HANA_PP_STRINGIZE(m19), BOOST_HANA_PP_STRINGIZE(m20), BOOST_HANA_PP_STRINGIZE(m21), BOOST_HANA_PP_STRINGIZE(m22), BOOST_HANA_PP_STRINGIZE(m23), BOOST_HANA_PP_STRINGIZE(m24), BOOST_HANA_PP_STRINGIZE(m25), BOOST_HANA_PP_STRINGIZE(m26), BOOST_HANA_PP_STRINGIZE(m27), BOOST_HANA_PP_STRINGIZE(m28), BOOST_HANA_PP_STRINGIZE(m29), BOOST_HANA_PP_STRINGIZE(m30), BOOST_HANA_PP_STRINGIZE(m31), BOOST_HANA_PP_STRINGIZE(m32), BOOST_HANA_PP_STRINGIZE(m33), BOOST_HANA_PP_STRINGIZE(m34), BOOST_HANA_PP_STRINGIZE(m35), BOOST_HANA_PP_STRINGIZE(m36), BOOST_HANA_PP_STRINGIZE(m37), BOOST_HANA_PP_STRINGIZE(m38), BOOST_HANA_PP_STRINGIZE(m39), BOOST_HANA_PP_STRINGIZE(m40), BOOST_HANA_PP_STRINGIZE(m41), BOOST_HANA_PP_STRINGIZE(m42), BOOST_HANA_PP_STRINGIZE(m43), BOOST_HANA_PP_STRINGIZE(m44), BOOST_HANA_PP_STRINGIZE(m45), BOOST_HANA_PP_STRINGIZE(m46), BOOST_HANA_PP_STRINGIZE(m47), BOOST_HANA_PP_STRINGIZE(m48), BOOST_HANA_PP_STRINGIZE(m49), BOOST_HANA_PP_STRINGIZE(m50), BOOST_HANA_PP_STRINGIZE(m51), BOOST_HANA_PP_STRINGIZE(m52), BOOST_HANA_PP_STRINGIZE(m53), BOOST_HANA_PP_STRINGIZE(m54), BOOST_HANA_PP_STRINGIZE(m55), BOOST_HANA_PP_STRINGIZE(m56), BOOST_HANA_PP_STRINGIZE(m57), BOOST_HANA_PP_STRINGIZE(m58), BOOST_HANA_PP_STRINGIZE(m59), BOOST_HANA_PP_STRINGIZE(m60), BOOST_HANA_PP_STRINGIZE(m61), BOOST_HANA_PP_STRINGIZE(m62), BOOST_HANA_PP_STRINGIZE(m63), BOOST_HANA_PP_STRINGIZE(m64)   \
                      );                                                                          \
                  }                                                                               \
                };                                                                                \
                return ::boost::hana::make_tuple(                                                 \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m1), &TYPE::m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m2), &TYPE::m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m3), &TYPE::m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m4), &TYPE::m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m5), &TYPE::m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m6), &TYPE::m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m7), &TYPE::m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m8), &TYPE::m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m9), &TYPE::m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m10), &TYPE::m10>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m11), &TYPE::m11>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m12), &TYPE::m12>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m13), &TYPE::m13>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m14), &TYPE::m14>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m15), &TYPE::m15>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m16), &TYPE::m16>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m17), &TYPE::m17>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m18), &TYPE::m18>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<18, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m19), &TYPE::m19>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<19, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m20), &TYPE::m20>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<20, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m21), &TYPE::m21>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<21, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m22), &TYPE::m22>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<22, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m23), &TYPE::m23>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<23, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m24), &TYPE::m24>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<24, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m25), &TYPE::m25>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<25, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m26), &TYPE::m26>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<26, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m27), &TYPE::m27>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<27, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m28), &TYPE::m28>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<28, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m29), &TYPE::m29>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<29, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m30), &TYPE::m30>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<30, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m31), &TYPE::m31>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<31, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m32), &TYPE::m32>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<32, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m33), &TYPE::m33>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<33, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m34), &TYPE::m34>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<34, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m35), &TYPE::m35>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<35, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m36), &TYPE::m36>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<36, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m37), &TYPE::m37>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<37, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m38), &TYPE::m38>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<38, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m39), &TYPE::m39>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<39, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m40), &TYPE::m40>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<40, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m41), &TYPE::m41>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<41, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m42), &TYPE::m42>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<42, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m43), &TYPE::m43>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<43, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m44), &TYPE::m44>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<44, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m45), &TYPE::m45>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<45, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m46), &TYPE::m46>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<46, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m47), &TYPE::m47>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<47, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m48), &TYPE::m48>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<48, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m49), &TYPE::m49>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<49, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m50), &TYPE::m50>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<50, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m51), &TYPE::m51>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<51, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m52), &TYPE::m52>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<52, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m53), &TYPE::m53>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<53, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m54), &TYPE::m54>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<54, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m55), &TYPE::m55>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<55, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m56), &TYPE::m56>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<56, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m57), &TYPE::m57>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<57, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m58), &TYPE::m58>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<58, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m59), &TYPE::m59>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<59, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m60), &TYPE::m60>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<60, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m61), &TYPE::m61>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<61, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m62), &TYPE::m62>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<62, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m63), &TYPE::m63>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<63, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m64), &TYPE::m64>{})\
                );                                                                                \
            }                                                                                     \
        };                                                                                        \
    }}                                                                                            \
/**/

#define BOOST_HANA_ADAPT_STRUCT_IMPL_66(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21, m22, m23, m24, m25, m26, m27, m28, m29, m30, m31, m32, m33, m34, m35, m36, m37, m38, m39, m40, m41, m42, m43, m44, m45, m46, m47, m48, m49, m50, m51, m52, m53, m54, m55, m56, m57, m58, m59, m60, m61, m62, m63, m64, m65)    \
    namespace boost { namespace hana {                                                            \
        template <>                                                                               \
        struct accessors_impl<TYPE> {                                                             \
            static constexpr auto apply() {                                                       \
                struct member_names {                                                             \
                  static constexpr auto get() {                                                   \
                      return ::boost::hana::make_tuple(                                           \
                          BOOST_HANA_PP_STRINGIZE(m1), BOOST_HANA_PP_STRINGIZE(m2), BOOST_HANA_PP_STRINGIZE(m3), BOOST_HANA_PP_STRINGIZE(m4), BOOST_HANA_PP_STRINGIZE(m5), BOOST_HANA_PP_STRINGIZE(m6), BOOST_HANA_PP_STRINGIZE(m7), BOOST_HANA_PP_STRINGIZE(m8), BOOST_HANA_PP_STRINGIZE(m9), BOOST_HANA_PP_STRINGIZE(m10), BOOST_HANA_PP_STRINGIZE(m11), BOOST_HANA_PP_STRINGIZE(m12), BOOST_HANA_PP_STRINGIZE(m13), BOOST_HANA_PP_STRINGIZE(m14), BOOST_HANA_PP_STRINGIZE(m15), BOOST_HANA_PP_STRINGIZE(m16), BOOST_HANA_PP_STRINGIZE(m17), BOOST_HANA_PP_STRINGIZE(m18), BOOST_HANA_PP_STRINGIZE(m19), BOOST_HANA_PP_STRINGIZE(m20), BOOST_HANA_PP_STRINGIZE(m21), BOOST_HANA_PP_STRINGIZE(m22), BOOST_HANA_PP_STRINGIZE(m23), BOOST_HANA_PP_STRINGIZE(m24), BOOST_HANA_PP_STRINGIZE(m25), BOOST_HANA_PP_STRINGIZE(m26), BOOST_HANA_PP_STRINGIZE(m27), BOOST_HANA_PP_STRINGIZE(m28), BOOST_HANA_PP_STRINGIZE(m29), BOOST_HANA_PP_STRINGIZE(m30), BOOST_HANA_PP_STRINGIZE(m31), BOOST_HANA_PP_STRINGIZE(m32), BOOST_HANA_PP_STRINGIZE(m33), BOOST_HANA_PP_STRINGIZE(m34), BOOST_HANA_PP_STRINGIZE(m35), BOOST_HANA_PP_STRINGIZE(m36), BOOST_HANA_PP_STRINGIZE(m37), BOOST_HANA_PP_STRINGIZE(m38), BOOST_HANA_PP_STRINGIZE(m39), BOOST_HANA_PP_STRINGIZE(m40), BOOST_HANA_PP_STRINGIZE(m41), BOOST_HANA_PP_STRINGIZE(m42), BOOST_HANA_PP_STRINGIZE(m43), BOOST_HANA_PP_STRINGIZE(m44), BOOST_HANA_PP_STRINGIZE(m45), BOOST_HANA_PP_STRINGIZE(m46), BOOST_HANA_PP_STRINGIZE(m47), BOOST_HANA_PP_STRINGIZE(m48), BOOST_HANA_PP_STRINGIZE(m49), BOOST_HANA_PP_STRINGIZE(m50), BOOST_HANA_PP_STRINGIZE(m51), BOOST_HANA_PP_STRINGIZE(m52), BOOST_HANA_PP_STRINGIZE(m53), BOOST_HANA_PP_STRINGIZE(m54), BOOST_HANA_PP_STRINGIZE(m55), BOOST_HANA_PP_STRINGIZE(m56), BOOST_HANA_PP_STRINGIZE(m57), BOOST_HANA_PP_STRINGIZE(m58), BOOST_HANA_PP_STRINGIZE(m59), BOOST_HANA_PP_STRINGIZE(m60), BOOST_HANA_PP_STRINGIZE(m61), BOOST_HANA_PP_STRINGIZE(m62), BOOST_HANA_PP_STRINGIZE(m63), BOOST_HANA_PP_STRINGIZE(m64), BOOST_HANA_PP_STRINGIZE(m65)   \
                      );                                                                          \
                  }                                                                               \
                };                                                                                \
                return ::boost::hana::make_tuple(                                                 \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m1), &TYPE::m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m2), &TYPE::m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m3), &TYPE::m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m4), &TYPE::m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m5), &TYPE::m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m6), &TYPE::m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m7), &TYPE::m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m8), &TYPE::m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m9), &TYPE::m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m10), &TYPE::m10>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m11), &TYPE::m11>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m12), &TYPE::m12>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m13), &TYPE::m13>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m14), &TYPE::m14>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m15), &TYPE::m15>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m16), &TYPE::m16>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m17), &TYPE::m17>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m18), &TYPE::m18>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<18, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m19), &TYPE::m19>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<19, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m20), &TYPE::m20>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<20, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m21), &TYPE::m21>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<21, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m22), &TYPE::m22>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<22, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m23), &TYPE::m23>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<23, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m24), &TYPE::m24>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<24, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m25), &TYPE::m25>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<25, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m26), &TYPE::m26>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<26, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m27), &TYPE::m27>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<27, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m28), &TYPE::m28>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<28, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m29), &TYPE::m29>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<29, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m30), &TYPE::m30>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<30, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m31), &TYPE::m31>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<31, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m32), &TYPE::m32>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<32, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m33), &TYPE::m33>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<33, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m34), &TYPE::m34>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<34, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m35), &TYPE::m35>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<35, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m36), &TYPE::m36>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<36, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m37), &TYPE::m37>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<37, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m38), &TYPE::m38>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<38, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m39), &TYPE::m39>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<39, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m40), &TYPE::m40>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<40, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m41), &TYPE::m41>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<41, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m42), &TYPE::m42>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<42, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m43), &TYPE::m43>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<43, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m44), &TYPE::m44>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<44, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m45), &TYPE::m45>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<45, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m46), &TYPE::m46>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<46, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m47), &TYPE::m47>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<47, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m48), &TYPE::m48>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<48, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m49), &TYPE::m49>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<49, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m50), &TYPE::m50>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<50, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m51), &TYPE::m51>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<51, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m52), &TYPE::m52>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<52, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m53), &TYPE::m53>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<53, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m54), &TYPE::m54>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<54, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m55), &TYPE::m55>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<55, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m56), &TYPE::m56>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<56, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m57), &TYPE::m57>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<57, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m58), &TYPE::m58>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<58, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m59), &TYPE::m59>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<59, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m60), &TYPE::m60>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<60, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m61), &TYPE::m61>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<61, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m62), &TYPE::m62>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<62, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m63), &TYPE::m63>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<63, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m64), &TYPE::m64>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<64, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m65), &TYPE::m65>{})\
                );                                                                                \
            }                                                                                     \
        };                                                                                        \
    }}                                                                                            \
/**/

#define BOOST_HANA_ADAPT_STRUCT_IMPL_67(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21, m22, m23, m24, m25, m26, m27, m28, m29, m30, m31, m32, m33, m34, m35, m36, m37, m38, m39, m40, m41, m42, m43, m44, m45, m46, m47, m48, m49, m50, m51, m52, m53, m54, m55, m56, m57, m58, m59, m60, m61, m62, m63, m64, m65, m66)    \
    namespace boost { namespace hana {                                                            \
        template <>                                                                               \
        struct accessors_impl<TYPE> {                                                             \
            static constexpr auto apply() {                                                       \
                struct member_names {                                                             \
                  static constexpr auto get() {                                                   \
                      return ::boost::hana::make_tuple(                                           \
                          BOOST_HANA_PP_STRINGIZE(m1), BOOST_HANA_PP_STRINGIZE(m2), BOOST_HANA_PP_STRINGIZE(m3), BOOST_HANA_PP_STRINGIZE(m4), BOOST_HANA_PP_STRINGIZE(m5), BOOST_HANA_PP_STRINGIZE(m6), BOOST_HANA_PP_STRINGIZE(m7), BOOST_HANA_PP_STRINGIZE(m8), BOOST_HANA_PP_STRINGIZE(m9), BOOST_HANA_PP_STRINGIZE(m10), BOOST_HANA_PP_STRINGIZE(m11), BOOST_HANA_PP_STRINGIZE(m12), BOOST_HANA_PP_STRINGIZE(m13), BOOST_HANA_PP_STRINGIZE(m14), BOOST_HANA_PP_STRINGIZE(m15), BOOST_HANA_PP_STRINGIZE(m16), BOOST_HANA_PP_STRINGIZE(m17), BOOST_HANA_PP_STRINGIZE(m18), BOOST_HANA_PP_STRINGIZE(m19), BOOST_HANA_PP_STRINGIZE(m20), BOOST_HANA_PP_STRINGIZE(m21), BOOST_HANA_PP_STRINGIZE(m22), BOOST_HANA_PP_STRINGIZE(m23), BOOST_HANA_PP_STRINGIZE(m24), BOOST_HANA_PP_STRINGIZE(m25), BOOST_HANA_PP_STRINGIZE(m26), BOOST_HANA_PP_STRINGIZE(m27), BOOST_HANA_PP_STRINGIZE(m28), BOOST_HANA_PP_STRINGIZE(m29), BOOST_HANA_PP_STRINGIZE(m30), BOOST_HANA_PP_STRINGIZE(m31), BOOST_HANA_PP_STRINGIZE(m32), BOOST_HANA_PP_STRINGIZE(m33), BOOST_HANA_PP_STRINGIZE(m34), BOOST_HANA_PP_STRINGIZE(m35), BOOST_HANA_PP_STRINGIZE(m36), BOOST_HANA_PP_STRINGIZE(m37), BOOST_HANA_PP_STRINGIZE(m38), BOOST_HANA_PP_STRINGIZE(m39), BOOST_HANA_PP_STRINGIZE(m40), BOOST_HANA_PP_STRINGIZE(m41), BOOST_HANA_PP_STRINGIZE(m42), BOOST_HANA_PP_STRINGIZE(m43), BOOST_HANA_PP_STRINGIZE(m44), BOOST_HANA_PP_STRINGIZE(m45), BOOST_HANA_PP_STRINGIZE(m46), BOOST_HANA_PP_STRINGIZE(m47), BOOST_HANA_PP_STRINGIZE(m48), BOOST_HANA_PP_STRINGIZE(m49), BOOST_HANA_PP_STRINGIZE(m50), BOOST_HANA_PP_STRINGIZE(m51), BOOST_HANA_PP_STRINGIZE(m52), BOOST_HANA_PP_STRINGIZE(m53), BOOST_HANA_PP_STRINGIZE(m54), BOOST_HANA_PP_STRINGIZE(m55), BOOST_HANA_PP_STRINGIZE(m56), BOOST_HANA_PP_STRINGIZE(m57), BOOST_HANA_PP_STRINGIZE(m58), BOOST_HANA_PP_STRINGIZE(m59), BOOST_HANA_PP_STRINGIZE(m60), BOOST_HANA_PP_STRINGIZE(m61), BOOST_HANA_PP_STRINGIZE(m62), BOOST_HANA_PP_STRINGIZE(m63), BOOST_HANA_PP_STRINGIZE(m64), BOOST_HANA_PP_STRINGIZE(m65), BOOST_HANA_PP_STRINGIZE(m66)   \
                      );                                                                          \
                  }                                                                               \
                };                                                                                \
                return ::boost::hana::make_tuple(                                                 \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m1), &TYPE::m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m2), &TYPE::m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m3), &TYPE::m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m4), &TYPE::m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m5), &TYPE::m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m6), &TYPE::m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m7), &TYPE::m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m8), &TYPE::m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m9), &TYPE::m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m10), &TYPE::m10>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m11), &TYPE::m11>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m12), &TYPE::m12>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m13), &TYPE::m13>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m14), &TYPE::m14>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m15), &TYPE::m15>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m16), &TYPE::m16>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m17), &TYPE::m17>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m18), &TYPE::m18>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<18, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m19), &TYPE::m19>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<19, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m20), &TYPE::m20>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<20, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m21), &TYPE::m21>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<21, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m22), &TYPE::m22>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<22, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m23), &TYPE::m23>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<23, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m24), &TYPE::m24>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<24, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m25), &TYPE::m25>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<25, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m26), &TYPE::m26>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<26, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m27), &TYPE::m27>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<27, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m28), &TYPE::m28>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<28, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m29), &TYPE::m29>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<29, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m30), &TYPE::m30>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<30, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m31), &TYPE::m31>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<31, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m32), &TYPE::m32>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<32, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m33), &TYPE::m33>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<33, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m34), &TYPE::m34>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<34, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m35), &TYPE::m35>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<35, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m36), &TYPE::m36>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<36, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m37), &TYPE::m37>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<37, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m38), &TYPE::m38>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<38, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m39), &TYPE::m39>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<39, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m40), &TYPE::m40>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<40, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m41), &TYPE::m41>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<41, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m42), &TYPE::m42>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<42, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m43), &TYPE::m43>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<43, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m44), &TYPE::m44>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<44, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m45), &TYPE::m45>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<45, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m46), &TYPE::m46>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<46, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m47), &TYPE::m47>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<47, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m48), &TYPE::m48>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<48, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m49), &TYPE::m49>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<49, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m50), &TYPE::m50>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<50, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m51), &TYPE::m51>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<51, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m52), &TYPE::m52>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<52, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m53), &TYPE::m53>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<53, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m54), &TYPE::m54>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<54, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m55), &TYPE::m55>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<55, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m56), &TYPE::m56>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<56, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m57), &TYPE::m57>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<57, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m58), &TYPE::m58>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<58, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m59), &TYPE::m59>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<59, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m60), &TYPE::m60>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<60, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m61), &TYPE::m61>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<61, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m62), &TYPE::m62>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<62, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m63), &TYPE::m63>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<63, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m64), &TYPE::m64>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<64, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m65), &TYPE::m65>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<65, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m66), &TYPE::m66>{})\
                );                                                                                \
            }                                                                                     \
        };                                                                                        \
    }}                                                                                            \
/**/

#define BOOST_HANA_ADAPT_STRUCT_IMPL_68(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21, m22, m23, m24, m25, m26, m27, m28, m29, m30, m31, m32, m33, m34, m35, m36, m37, m38, m39, m40, m41, m42, m43, m44, m45, m46, m47, m48, m49, m50, m51, m52, m53, m54, m55, m56, m57, m58, m59, m60, m61, m62, m63, m64, m65, m66, m67)    \
    namespace boost { namespace hana {                                                            \
        template <>                                                                               \
        struct accessors_impl<TYPE> {                                                             \
            static constexpr auto apply() {                                                       \
                struct member_names {                                                             \
                  static constexpr auto get() {                                                   \
                      return ::boost::hana::make_tuple(                                           \
                          BOOST_HANA_PP_STRINGIZE(m1), BOOST_HANA_PP_STRINGIZE(m2), BOOST_HANA_PP_STRINGIZE(m3), BOOST_HANA_PP_STRINGIZE(m4), BOOST_HANA_PP_STRINGIZE(m5), BOOST_HANA_PP_STRINGIZE(m6), BOOST_HANA_PP_STRINGIZE(m7), BOOST_HANA_PP_STRINGIZE(m8), BOOST_HANA_PP_STRINGIZE(m9), BOOST_HANA_PP_STRINGIZE(m10), BOOST_HANA_PP_STRINGIZE(m11), BOOST_HANA_PP_STRINGIZE(m12), BOOST_HANA_PP_STRINGIZE(m13), BOOST_HANA_PP_STRINGIZE(m14), BOOST_HANA_PP_STRINGIZE(m15), BOOST_HANA_PP_STRINGIZE(m16), BOOST_HANA_PP_STRINGIZE(m17), BOOST_HANA_PP_STRINGIZE(m18), BOOST_HANA_PP_STRINGIZE(m19), BOOST_HANA_PP_STRINGIZE(m20), BOOST_HANA_PP_STRINGIZE(m21), BOOST_HANA_PP_STRINGIZE(m22), BOOST_HANA_PP_STRINGIZE(m23), BOOST_HANA_PP_STRINGIZE(m24), BOOST_HANA_PP_STRINGIZE(m25), BOOST_HANA_PP_STRINGIZE(m26), BOOST_HANA_PP_STRINGIZE(m27), BOOST_HANA_PP_STRINGIZE(m28), BOOST_HANA_PP_STRINGIZE(m29), BOOST_HANA_PP_STRINGIZE(m30), BOOST_HANA_PP_STRINGIZE(m31), BOOST_HANA_PP_STRINGIZE(m32), BOOST_HANA_PP_STRINGIZE(m33), BOOST_HANA_PP_STRINGIZE(m34), BOOST_HANA_PP_STRINGIZE(m35), BOOST_HANA_PP_STRINGIZE(m36), BOOST_HANA_PP_STRINGIZE(m37), BOOST_HANA_PP_STRINGIZE(m38), BOOST_HANA_PP_STRINGIZE(m39), BOOST_HANA_PP_STRINGIZE(m40), BOOST_HANA_PP_STRINGIZE(m41), BOOST_HANA_PP_STRINGIZE(m42), BOOST_HANA_PP_STRINGIZE(m43), BOOST_HANA_PP_STRINGIZE(m44), BOOST_HANA_PP_STRINGIZE(m45), BOOST_HANA_PP_STRINGIZE(m46), BOOST_HANA_PP_STRINGIZE(m47), BOOST_HANA_PP_STRINGIZE(m48), BOOST_HANA_PP_STRINGIZE(m49), BOOST_HANA_PP_STRINGIZE(m50), BOOST_HANA_PP_STRINGIZE(m51), BOOST_HANA_PP_STRINGIZE(m52), BOOST_HANA_PP_STRINGIZE(m53), BOOST_HANA_PP_STRINGIZE(m54), BOOST_HANA_PP_STRINGIZE(m55), BOOST_HANA_PP_STRINGIZE(m56), BOOST_HANA_PP_STRINGIZE(m57), BOOST_HANA_PP_STRINGIZE(m58), BOOST_HANA_PP_STRINGIZE(m59), BOOST_HANA_PP_STRINGIZE(m60), BOOST_HANA_PP_STRINGIZE(m61), BOOST_HANA_PP_STRINGIZE(m62), BOOST_HANA_PP_STRINGIZE(m63), BOOST_HANA_PP_STRINGIZE(m64), BOOST_HANA_PP_STRINGIZE(m65), BOOST_HANA_PP_STRINGIZE(m66), BOOST_HANA_PP_STRINGIZE(m67)   \
                      );                                                                          \
                  }                                                                               \
                };                                                                                \
                return ::boost::hana::make_tuple(                                                 \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m1), &TYPE::m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m2), &TYPE::m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m3), &TYPE::m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m4), &TYPE::m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m5), &TYPE::m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m6), &TYPE::m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m7), &TYPE::m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m8), &TYPE::m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m9), &TYPE::m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m10), &TYPE::m10>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m11), &TYPE::m11>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m12), &TYPE::m12>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m13), &TYPE::m13>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m14), &TYPE::m14>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m15), &TYPE::m15>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m16), &TYPE::m16>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m17), &TYPE::m17>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m18), &TYPE::m18>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<18, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m19), &TYPE::m19>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<19, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m20), &TYPE::m20>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<20, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m21), &TYPE::m21>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<21, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m22), &TYPE::m22>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<22, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m23), &TYPE::m23>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<23, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m24), &TYPE::m24>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<24, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m25), &TYPE::m25>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<25, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m26), &TYPE::m26>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<26, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m27), &TYPE::m27>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<27, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m28), &TYPE::m28>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<28, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m29), &TYPE::m29>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<29, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m30), &TYPE::m30>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<30, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m31), &TYPE::m31>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<31, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m32), &TYPE::m32>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<32, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m33), &TYPE::m33>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<33, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m34), &TYPE::m34>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<34, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m35), &TYPE::m35>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<35, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m36), &TYPE::m36>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<36, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m37), &TYPE::m37>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<37, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m38), &TYPE::m38>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<38, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m39), &TYPE::m39>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<39, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m40), &TYPE::m40>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<40, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m41), &TYPE::m41>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<41, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m42), &TYPE::m42>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<42, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m43), &TYPE::m43>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<43, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m44), &TYPE::m44>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<44, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m45), &TYPE::m45>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<45, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m46), &TYPE::m46>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<46, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m47), &TYPE::m47>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<47, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m48), &TYPE::m48>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<48, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m49), &TYPE::m49>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<49, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m50), &TYPE::m50>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<50, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m51), &TYPE::m51>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<51, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m52), &TYPE::m52>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<52, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m53), &TYPE::m53>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<53, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m54), &TYPE::m54>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<54, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m55), &TYPE::m55>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<55, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m56), &TYPE::m56>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<56, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m57), &TYPE::m57>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<57, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m58), &TYPE::m58>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<58, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m59), &TYPE::m59>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<59, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m60), &TYPE::m60>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<60, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m61), &TYPE::m61>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<61, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m62), &TYPE::m62>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<62, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m63), &TYPE::m63>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<63, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m64), &TYPE::m64>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<64, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m65), &TYPE::m65>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<65, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m66), &TYPE::m66>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<66, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m67), &TYPE::m67>{})\
                );                                                                                \
            }                                                                                     \
        };                                                                                        \
    }}                                                                                            \
/**/

#define BOOST_HANA_ADAPT_STRUCT_IMPL_69(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21, m22, m23, m24, m25, m26, m27, m28, m29, m30, m31, m32, m33, m34, m35, m36, m37, m38, m39, m40, m41, m42, m43, m44, m45, m46, m47, m48, m49, m50, m51, m52, m53, m54, m55, m56, m57, m58, m59, m60, m61, m62, m63, m64, m65, m66, m67, m68)    \
    namespace boost { namespace hana {                                                            \
        template <>                                                                               \
        struct accessors_impl<TYPE> {                                                             \
            static constexpr auto apply() {                                                       \
                struct member_names {                                                             \
                  static constexpr auto get() {                                                   \
                      return ::boost::hana::make_tuple(                                           \
                          BOOST_HANA_PP_STRINGIZE(m1), BOOST_HANA_PP_STRINGIZE(m2), BOOST_HANA_PP_STRINGIZE(m3), BOOST_HANA_PP_STRINGIZE(m4), BOOST_HANA_PP_STRINGIZE(m5), BOOST_HANA_PP_STRINGIZE(m6), BOOST_HANA_PP_STRINGIZE(m7), BOOST_HANA_PP_STRINGIZE(m8), BOOST_HANA_PP_STRINGIZE(m9), BOOST_HANA_PP_STRINGIZE(m10), BOOST_HANA_PP_STRINGIZE(m11), BOOST_HANA_PP_STRINGIZE(m12), BOOST_HANA_PP_STRINGIZE(m13), BOOST_HANA_PP_STRINGIZE(m14), BOOST_HANA_PP_STRINGIZE(m15), BOOST_HANA_PP_STRINGIZE(m16), BOOST_HANA_PP_STRINGIZE(m17), BOOST_HANA_PP_STRINGIZE(m18), BOOST_HANA_PP_STRINGIZE(m19), BOOST_HANA_PP_STRINGIZE(m20), BOOST_HANA_PP_STRINGIZE(m21), BOOST_HANA_PP_STRINGIZE(m22), BOOST_HANA_PP_STRINGIZE(m23), BOOST_HANA_PP_STRINGIZE(m24), BOOST_HANA_PP_STRINGIZE(m25), BOOST_HANA_PP_STRINGIZE(m26), BOOST_HANA_PP_STRINGIZE(m27), BOOST_HANA_PP_STRINGIZE(m28), BOOST_HANA_PP_STRINGIZE(m29), BOOST_HANA_PP_STRINGIZE(m30), BOOST_HANA_PP_STRINGIZE(m31), BOOST_HANA_PP_STRINGIZE(m32), BOOST_HANA_PP_STRINGIZE(m33), BOOST_HANA_PP_STRINGIZE(m34), BOOST_HANA_PP_STRINGIZE(m35), BOOST_HANA_PP_STRINGIZE(m36), BOOST_HANA_PP_STRINGIZE(m37), BOOST_HANA_PP_STRINGIZE(m38), BOOST_HANA_PP_STRINGIZE(m39), BOOST_HANA_PP_STRINGIZE(m40), BOOST_HANA_PP_STRINGIZE(m41), BOOST_HANA_PP_STRINGIZE(m42), BOOST_HANA_PP_STRINGIZE(m43), BOOST_HANA_PP_STRINGIZE(m44), BOOST_HANA_PP_STRINGIZE(m45), BOOST_HANA_PP_STRINGIZE(m46), BOOST_HANA_PP_STRINGIZE(m47), BOOST_HANA_PP_STRINGIZE(m48), BOOST_HANA_PP_STRINGIZE(m49), BOOST_HANA_PP_STRINGIZE(m50), BOOST_HANA_PP_STRINGIZE(m51), BOOST_HANA_PP_STRINGIZE(m52), BOOST_HANA_PP_STRINGIZE(m53), BOOST_HANA_PP_STRINGIZE(m54), BOOST_HANA_PP_STRINGIZE(m55), BOOST_HANA_PP_STRINGIZE(m56), BOOST_HANA_PP_STRINGIZE(m57), BOOST_HANA_PP_STRINGIZE(m58), BOOST_HANA_PP_STRINGIZE(m59), BOOST_HANA_PP_STRINGIZE(m60), BOOST_HANA_PP_STRINGIZE(m61), BOOST_HANA_PP_STRINGIZE(m62), BOOST_HANA_PP_STRINGIZE(m63), BOOST_HANA_PP_STRINGIZE(m64), BOOST_HANA_PP_STRINGIZE(m65), BOOST_HANA_PP_STRINGIZE(m66), BOOST_HANA_PP_STRINGIZE(m67), BOOST_HANA_PP_STRINGIZE(m68)   \
                      );                                                                          \
                  }                                                                               \
                };                                                                                \
                return ::boost::hana::make_tuple(                                                 \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m1), &TYPE::m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m2), &TYPE::m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m3), &TYPE::m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m4), &TYPE::m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m5), &TYPE::m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m6), &TYPE::m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m7), &TYPE::m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m8), &TYPE::m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m9), &TYPE::m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m10), &TYPE::m10>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m11), &TYPE::m11>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m12), &TYPE::m12>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m13), &TYPE::m13>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m14), &TYPE::m14>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m15), &TYPE::m15>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m16), &TYPE::m16>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m17), &TYPE::m17>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m18), &TYPE::m18>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<18, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m19), &TYPE::m19>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<19, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m20), &TYPE::m20>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<20, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m21), &TYPE::m21>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<21, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m22), &TYPE::m22>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<22, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m23), &TYPE::m23>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<23, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m24), &TYPE::m24>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<24, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m25), &TYPE::m25>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<25, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m26), &TYPE::m26>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<26, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m27), &TYPE::m27>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<27, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m28), &TYPE::m28>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<28, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m29), &TYPE::m29>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<29, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m30), &TYPE::m30>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<30, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m31), &TYPE::m31>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<31, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m32), &TYPE::m32>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<32, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m33), &TYPE::m33>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<33, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m34), &TYPE::m34>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<34, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m35), &TYPE::m35>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<35, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m36), &TYPE::m36>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<36, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m37), &TYPE::m37>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<37, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m38), &TYPE::m38>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<38, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m39), &TYPE::m39>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<39, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m40), &TYPE::m40>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<40, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m41), &TYPE::m41>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<41, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m42), &TYPE::m42>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<42, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m43), &TYPE::m43>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<43, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m44), &TYPE::m44>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<44, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m45), &TYPE::m45>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<45, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m46), &TYPE::m46>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<46, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m47), &TYPE::m47>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<47, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m48), &TYPE::m48>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<48, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m49), &TYPE::m49>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<49, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m50), &TYPE::m50>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<50, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m51), &TYPE::m51>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<51, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m52), &TYPE::m52>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<52, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m53), &TYPE::m53>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<53, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m54), &TYPE::m54>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<54, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m55), &TYPE::m55>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<55, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m56), &TYPE::m56>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<56, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m57), &TYPE::m57>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<57, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m58), &TYPE::m58>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<58, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m59), &TYPE::m59>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<59, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m60), &TYPE::m60>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<60, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m61), &TYPE::m61>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<61, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m62), &TYPE::m62>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<62, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m63), &TYPE::m63>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<63, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m64), &TYPE::m64>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<64, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m65), &TYPE::m65>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<65, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m66), &TYPE::m66>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<66, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m67), &TYPE::m67>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<67, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m68), &TYPE::m68>{})\
                );                                                                                \
            }                                                                                     \
        };                                                                                        \
    }}                                                                                            \
/**/

#define BOOST_HANA_ADAPT_STRUCT_IMPL_70(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21, m22, m23, m24, m25, m26, m27, m28, m29, m30, m31, m32, m33, m34, m35, m36, m37, m38, m39, m40, m41, m42, m43, m44, m45, m46, m47, m48, m49, m50, m51, m52, m53, m54, m55, m56, m57, m58, m59, m60, m61, m62, m63, m64, m65, m66, m67, m68, m69)    \
    namespace boost { namespace hana {                                                            \
        template <>                                                                               \
        struct accessors_impl<TYPE> {                                                             \
            static constexpr auto apply() {                                                       \
                struct member_names {                                                             \
                  static constexpr auto get() {                                                   \
                      return ::boost::hana::make_tuple(                                           \
                          BOOST_HANA_PP_STRINGIZE(m1), BOOST_HANA_PP_STRINGIZE(m2), BOOST_HANA_PP_STRINGIZE(m3), BOOST_HANA_PP_STRINGIZE(m4), BOOST_HANA_PP_STRINGIZE(m5), BOOST_HANA_PP_STRINGIZE(m6), BOOST_HANA_PP_STRINGIZE(m7), BOOST_HANA_PP_STRINGIZE(m8), BOOST_HANA_PP_STRINGIZE(m9), BOOST_HANA_PP_STRINGIZE(m10), BOOST_HANA_PP_STRINGIZE(m11), BOOST_HANA_PP_STRINGIZE(m12), BOOST_HANA_PP_STRINGIZE(m13), BOOST_HANA_PP_STRINGIZE(m14), BOOST_HANA_PP_STRINGIZE(m15), BOOST_HANA_PP_STRINGIZE(m16), BOOST_HANA_PP_STRINGIZE(m17), BOOST_HANA_PP_STRINGIZE(m18), BOOST_HANA_PP_STRINGIZE(m19), BOOST_HANA_PP_STRINGIZE(m20), BOOST_HANA_PP_STRINGIZE(m21), BOOST_HANA_PP_STRINGIZE(m22), BOOST_HANA_PP_STRINGIZE(m23), BOOST_HANA_PP_STRINGIZE(m24), BOOST_HANA_PP_STRINGIZE(m25), BOOST_HANA_PP_STRINGIZE(m26), BOOST_HANA_PP_STRINGIZE(m27), BOOST_HANA_PP_STRINGIZE(m28), BOOST_HANA_PP_STRINGIZE(m29), BOOST_HANA_PP_STRINGIZE(m30), BOOST_HANA_PP_STRINGIZE(m31), BOOST_HANA_PP_STRINGIZE(m32), BOOST_HANA_PP_STRINGIZE(m33), BOOST_HANA_PP_STRINGIZE(m34), BOOST_HANA_PP_STRINGIZE(m35), BOOST_HANA_PP_STRINGIZE(m36), BOOST_HANA_PP_STRINGIZE(m37), BOOST_HANA_PP_STRINGIZE(m38), BOOST_HANA_PP_STRINGIZE(m39), BOOST_HANA_PP_STRINGIZE(m40), BOOST_HANA_PP_STRINGIZE(m41), BOOST_HANA_PP_STRINGIZE(m42), BOOST_HANA_PP_STRINGIZE(m43), BOOST_HANA_PP_STRINGIZE(m44), BOOST_HANA_PP_STRINGIZE(m45), BOOST_HANA_PP_STRINGIZE(m46), BOOST_HANA_PP_STRINGIZE(m47), BOOST_HANA_PP_STRINGIZE(m48), BOOST_HANA_PP_STRINGIZE(m49), BOOST_HANA_PP_STRINGIZE(m50), BOOST_HANA_PP_STRINGIZE(m51), BOOST_HANA_PP_STRINGIZE(m52), BOOST_HANA_PP_STRINGIZE(m53), BOOST_HANA_PP_STRINGIZE(m54), BOOST_HANA_PP_STRINGIZE(m55), BOOST_HANA_PP_STRINGIZE(m56), BOOST_HANA_PP_STRINGIZE(m57), BOOST_HANA_PP_STRINGIZE(m58), BOOST_HANA_PP_STRINGIZE(m59), BOOST_HANA_PP_STRINGIZE(m60), BOOST_HANA_PP_STRINGIZE(m61), BOOST_HANA_PP_STRINGIZE(m62), BOOST_HANA_PP_STRINGIZE(m63), BOOST_HANA_PP_STRINGIZE(m64), BOOST_HANA_PP_STRINGIZE(m65), BOOST_HANA_PP_STRINGIZE(m66), BOOST_HANA_PP_STRINGIZE(m67), BOOST_HANA_PP_STRINGIZE(m68), BOOST_HANA_PP_STRINGIZE(m69)   \
                      );                                                                          \
                  }                                                                               \
                };                                                                                \
                return ::boost::hana::make_tuple(                                                 \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m1), &TYPE::m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m2), &TYPE::m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m3), &TYPE::m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m4), &TYPE::m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m5), &TYPE::m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m6), &TYPE::m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m7), &TYPE::m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m8), &TYPE::m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m9), &TYPE::m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m10), &TYPE::m10>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m11), &TYPE::m11>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m12), &TYPE::m12>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m13), &TYPE::m13>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m14), &TYPE::m14>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m15), &TYPE::m15>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m16), &TYPE::m16>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m17), &TYPE::m17>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m18), &TYPE::m18>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<18, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m19), &TYPE::m19>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<19, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m20), &TYPE::m20>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<20, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m21), &TYPE::m21>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<21, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m22), &TYPE::m22>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<22, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m23), &TYPE::m23>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<23, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m24), &TYPE::m24>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<24, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m25), &TYPE::m25>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<25, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m26), &TYPE::m26>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<26, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m27), &TYPE::m27>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<27, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m28), &TYPE::m28>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<28, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m29), &TYPE::m29>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<29, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m30), &TYPE::m30>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<30, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m31), &TYPE::m31>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<31, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m32), &TYPE::m32>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<32, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m33), &TYPE::m33>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<33, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m34), &TYPE::m34>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<34, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m35), &TYPE::m35>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<35, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m36), &TYPE::m36>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<36, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m37), &TYPE::m37>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<37, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m38), &TYPE::m38>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<38, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m39), &TYPE::m39>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<39, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m40), &TYPE::m40>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<40, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m41), &TYPE::m41>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<41, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m42), &TYPE::m42>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<42, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m43), &TYPE::m43>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<43, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m44), &TYPE::m44>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<44, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m45), &TYPE::m45>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<45, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m46), &TYPE::m46>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<46, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m47), &TYPE::m47>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<47, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m48), &TYPE::m48>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<48, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m49), &TYPE::m49>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<49, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m50), &TYPE::m50>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<50, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m51), &TYPE::m51>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<51, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m52), &TYPE::m52>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<52, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m53), &TYPE::m53>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<53, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m54), &TYPE::m54>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<54, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m55), &TYPE::m55>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<55, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m56), &TYPE::m56>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<56, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m57), &TYPE::m57>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<57, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m58), &TYPE::m58>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<58, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m59), &TYPE::m59>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<59, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m60), &TYPE::m60>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<60, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m61), &TYPE::m61>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<61, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m62), &TYPE::m62>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<62, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m63), &TYPE::m63>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<63, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m64), &TYPE::m64>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<64, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m65), &TYPE::m65>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<65, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m66), &TYPE::m66>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<66, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m67), &TYPE::m67>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<67, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m68), &TYPE::m68>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<68, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m69), &TYPE::m69>{})\
                );                                                                                \
            }                                                                                     \
        };                                                                                        \
    }}                                                                                            \
/**/

#define BOOST_HANA_ADAPT_STRUCT_IMPL_71(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21, m22, m23, m24, m25, m26, m27, m28, m29, m30, m31, m32, m33, m34, m35, m36, m37, m38, m39, m40, m41, m42, m43, m44, m45, m46, m47, m48, m49, m50, m51, m52, m53, m54, m55, m56, m57, m58, m59, m60, m61, m62, m63, m64, m65, m66, m67, m68, m69, m70)    \
    namespace boost { namespace hana {                                                            \
        template <>                                                                               \
        struct accessors_impl<TYPE> {                                                             \
            static constexpr auto apply() {                                                       \
                struct member_names {                                                             \
                  static constexpr auto get() {                                                   \
                      return ::boost::hana::make_tuple(                                           \
                          BOOST_HANA_PP_STRINGIZE(m1), BOOST_HANA_PP_STRINGIZE(m2), BOOST_HANA_PP_STRINGIZE(m3), BOOST_HANA_PP_STRINGIZE(m4), BOOST_HANA_PP_STRINGIZE(m5), BOOST_HANA_PP_STRINGIZE(m6), BOOST_HANA_PP_STRINGIZE(m7), BOOST_HANA_PP_STRINGIZE(m8), BOOST_HANA_PP_STRINGIZE(m9), BOOST_HANA_PP_STRINGIZE(m10), BOOST_HANA_PP_STRINGIZE(m11), BOOST_HANA_PP_STRINGIZE(m12), BOOST_HANA_PP_STRINGIZE(m13), BOOST_HANA_PP_STRINGIZE(m14), BOOST_HANA_PP_STRINGIZE(m15), BOOST_HANA_PP_STRINGIZE(m16), BOOST_HANA_PP_STRINGIZE(m17), BOOST_HANA_PP_STRINGIZE(m18), BOOST_HANA_PP_STRINGIZE(m19), BOOST_HANA_PP_STRINGIZE(m20), BOOST_HANA_PP_STRINGIZE(m21), BOOST_HANA_PP_STRINGIZE(m22), BOOST_HANA_PP_STRINGIZE(m23), BOOST_HANA_PP_STRINGIZE(m24), BOOST_HANA_PP_STRINGIZE(m25), BOOST_HANA_PP_STRINGIZE(m26), BOOST_HANA_PP_STRINGIZE(m27), BOOST_HANA_PP_STRINGIZE(m28), BOOST_HANA_PP_STRINGIZE(m29), BOOST_HANA_PP_STRINGIZE(m30), BOOST_HANA_PP_STRINGIZE(m31), BOOST_HANA_PP_STRINGIZE(m32), BOOST_HANA_PP_STRINGIZE(m33), BOOST_HANA_PP_STRINGIZE(m34), BOOST_HANA_PP_STRINGIZE(m35), BOOST_HANA_PP_STRINGIZE(m36), BOOST_HANA_PP_STRINGIZE(m37), BOOST_HANA_PP_STRINGIZE(m38), BOOST_HANA_PP_STRINGIZE(m39), BOOST_HANA_PP_STRINGIZE(m40), BOOST_HANA_PP_STRINGIZE(m41), BOOST_HANA_PP_STRINGIZE(m42), BOOST_HANA_PP_STRINGIZE(m43), BOOST_HANA_PP_STRINGIZE(m44), BOOST_HANA_PP_STRINGIZE(m45), BOOST_HANA_PP_STRINGIZE(m46), BOOST_HANA_PP_STRINGIZE(m47), BOOST_HANA_PP_STRINGIZE(m48), BOOST_HANA_PP_STRINGIZE(m49), BOOST_HANA_PP_STRINGIZE(m50), BOOST_HANA_PP_STRINGIZE(m51), BOOST_HANA_PP_STRINGIZE(m52), BOOST_HANA_PP_STRINGIZE(m53), BOOST_HANA_PP_STRINGIZE(m54), BOOST_HANA_PP_STRINGIZE(m55), BOOST_HANA_PP_STRINGIZE(m56), BOOST_HANA_PP_STRINGIZE(m57), BOOST_HANA_PP_STRINGIZE(m58), BOOST_HANA_PP_STRINGIZE(m59), BOOST_HANA_PP_STRINGIZE(m60), BOOST_HANA_PP_STRINGIZE(m61), BOOST_HANA_PP_STRINGIZE(m62), BOOST_HANA_PP_STRINGIZE(m63), BOOST_HANA_PP_STRINGIZE(m64), BOOST_HANA_PP_STRINGIZE(m65), BOOST_HANA_PP_STRINGIZE(m66), BOOST_HANA_PP_STRINGIZE(m67), BOOST_HANA_PP_STRINGIZE(m68), BOOST_HANA_PP_STRINGIZE(m69), BOOST_HANA_PP_STRINGIZE(m70)   \
                      );                                                                          \
                  }                                                                               \
                };                                                                                \
                return ::boost::hana::make_tuple(                                                 \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m1), &TYPE::m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m2), &TYPE::m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m3), &TYPE::m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m4), &TYPE::m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m5), &TYPE::m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m6), &TYPE::m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m7), &TYPE::m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m8), &TYPE::m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m9), &TYPE::m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m10), &TYPE::m10>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m11), &TYPE::m11>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m12), &TYPE::m12>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m13), &TYPE::m13>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m14), &TYPE::m14>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m15), &TYPE::m15>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m16), &TYPE::m16>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m17), &TYPE::m17>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m18), &TYPE::m18>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<18, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m19), &TYPE::m19>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<19, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m20), &TYPE::m20>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<20, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m21), &TYPE::m21>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<21, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m22), &TYPE::m22>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<22, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m23), &TYPE::m23>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<23, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m24), &TYPE::m24>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<24, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m25), &TYPE::m25>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<25, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m26), &TYPE::m26>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<26, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m27), &TYPE::m27>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<27, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m28), &TYPE::m28>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<28, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m29), &TYPE::m29>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<29, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m30), &TYPE::m30>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<30, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m31), &TYPE::m31>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<31, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m32), &TYPE::m32>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<32, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m33), &TYPE::m33>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<33, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m34), &TYPE::m34>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<34, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m35), &TYPE::m35>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<35, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m36), &TYPE::m36>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<36, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m37), &TYPE::m37>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<37, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m38), &TYPE::m38>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<38, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m39), &TYPE::m39>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<39, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m40), &TYPE::m40>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<40, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m41), &TYPE::m41>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<41, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m42), &TYPE::m42>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<42, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m43), &TYPE::m43>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<43, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m44), &TYPE::m44>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<44, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m45), &TYPE::m45>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<45, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m46), &TYPE::m46>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<46, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m47), &TYPE::m47>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<47, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m48), &TYPE::m48>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<48, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m49), &TYPE::m49>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<49, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m50), &TYPE::m50>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<50, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m51), &TYPE::m51>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<51, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m52), &TYPE::m52>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<52, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m53), &TYPE::m53>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<53, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m54), &TYPE::m54>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<54, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m55), &TYPE::m55>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<55, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m56), &TYPE::m56>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<56, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m57), &TYPE::m57>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<57, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m58), &TYPE::m58>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<58, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m59), &TYPE::m59>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<59, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m60), &TYPE::m60>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<60, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m61), &TYPE::m61>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<61, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m62), &TYPE::m62>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<62, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m63), &TYPE::m63>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<63, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m64), &TYPE::m64>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<64, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m65), &TYPE::m65>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<65, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m66), &TYPE::m66>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<66, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m67), &TYPE::m67>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<67, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m68), &TYPE::m68>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<68, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m69), &TYPE::m69>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<69, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m70), &TYPE::m70>{})\
                );                                                                                \
            }                                                                                     \
        };                                                                                        \
    }}                                                                                            \
/**/

#define BOOST_HANA_ADAPT_STRUCT_IMPL_72(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21, m22, m23, m24, m25, m26, m27, m28, m29, m30, m31, m32, m33, m34, m35, m36, m37, m38, m39, m40, m41, m42, m43, m44, m45, m46, m47, m48, m49, m50, m51, m52, m53, m54, m55, m56, m57, m58, m59, m60, m61, m62, m63, m64, m65, m66, m67, m68, m69, m70, m71)    \
    namespace boost { namespace hana {                                                            \
        template <>                                                                               \
        struct accessors_impl<TYPE> {                                                             \
            static constexpr auto apply() {                                                       \
                struct member_names {                                                             \
                  static constexpr auto get() {                                                   \
                      return ::boost::hana::make_tuple(                                           \
                          BOOST_HANA_PP_STRINGIZE(m1), BOOST_HANA_PP_STRINGIZE(m2), BOOST_HANA_PP_STRINGIZE(m3), BOOST_HANA_PP_STRINGIZE(m4), BOOST_HANA_PP_STRINGIZE(m5), BOOST_HANA_PP_STRINGIZE(m6), BOOST_HANA_PP_STRINGIZE(m7), BOOST_HANA_PP_STRINGIZE(m8), BOOST_HANA_PP_STRINGIZE(m9), BOOST_HANA_PP_STRINGIZE(m10), BOOST_HANA_PP_STRINGIZE(m11), BOOST_HANA_PP_STRINGIZE(m12), BOOST_HANA_PP_STRINGIZE(m13), BOOST_HANA_PP_STRINGIZE(m14), BOOST_HANA_PP_STRINGIZE(m15), BOOST_HANA_PP_STRINGIZE(m16), BOOST_HANA_PP_STRINGIZE(m17), BOOST_HANA_PP_STRINGIZE(m18), BOOST_HANA_PP_STRINGIZE(m19), BOOST_HANA_PP_STRINGIZE(m20), BOOST_HANA_PP_STRINGIZE(m21), BOOST_HANA_PP_STRINGIZE(m22), BOOST_HANA_PP_STRINGIZE(m23), BOOST_HANA_PP_STRINGIZE(m24), BOOST_HANA_PP_STRINGIZE(m25), BOOST_HANA_PP_STRINGIZE(m26), BOOST_HANA_PP_STRINGIZE(m27), BOOST_HANA_PP_STRINGIZE(m28), BOOST_HANA_PP_STRINGIZE(m29), BOOST_HANA_PP_STRINGIZE(m30), BOOST_HANA_PP_STRINGIZE(m31), BOOST_HANA_PP_STRINGIZE(m32), BOOST_HANA_PP_STRINGIZE(m33), BOOST_HANA_PP_STRINGIZE(m34), BOOST_HANA_PP_STRINGIZE(m35), BOOST_HANA_PP_STRINGIZE(m36), BOOST_HANA_PP_STRINGIZE(m37), BOOST_HANA_PP_STRINGIZE(m38), BOOST_HANA_PP_STRINGIZE(m39), BOOST_HANA_PP_STRINGIZE(m40), BOOST_HANA_PP_STRINGIZE(m41), BOOST_HANA_PP_STRINGIZE(m42), BOOST_HANA_PP_STRINGIZE(m43), BOOST_HANA_PP_STRINGIZE(m44), BOOST_HANA_PP_STRINGIZE(m45), BOOST_HANA_PP_STRINGIZE(m46), BOOST_HANA_PP_STRINGIZE(m47), BOOST_HANA_PP_STRINGIZE(m48), BOOST_HANA_PP_STRINGIZE(m49), BOOST_HANA_PP_STRINGIZE(m50), BOOST_HANA_PP_STRINGIZE(m51), BOOST_HANA_PP_STRINGIZE(m52), BOOST_HANA_PP_STRINGIZE(m53), BOOST_HANA_PP_STRINGIZE(m54), BOOST_HANA_PP_STRINGIZE(m55), BOOST_HANA_PP_STRINGIZE(m56), BOOST_HANA_PP_STRINGIZE(m57), BOOST_HANA_PP_STRINGIZE(m58), BOOST_HANA_PP_STRINGIZE(m59), BOOST_HANA_PP_STRINGIZE(m60), BOOST_HANA_PP_STRINGIZE(m61), BOOST_HANA_PP_STRINGIZE(m62), BOOST_HANA_PP_STRINGIZE(m63), BOOST_HANA_PP_STRINGIZE(m64), BOOST_HANA_PP_STRINGIZE(m65), BOOST_HANA_PP_STRINGIZE(m66), BOOST_HANA_PP_STRINGIZE(m67), BOOST_HANA_PP_STRINGIZE(m68), BOOST_HANA_PP_STRINGIZE(m69), BOOST_HANA_PP_STRINGIZE(m70), BOOST_HANA_PP_STRINGIZE(m71)   \
                      );                                                                          \
                  }                                                                               \
                };                                                                                \
                return ::boost::hana::make_tuple(                                                 \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m1), &TYPE::m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m2), &TYPE::m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m3), &TYPE::m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m4), &TYPE::m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m5), &TYPE::m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m6), &TYPE::m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m7), &TYPE::m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m8), &TYPE::m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m9), &TYPE::m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m10), &TYPE::m10>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m11), &TYPE::m11>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m12), &TYPE::m12>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m13), &TYPE::m13>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m14), &TYPE::m14>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m15), &TYPE::m15>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m16), &TYPE::m16>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m17), &TYPE::m17>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m18), &TYPE::m18>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<18, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m19), &TYPE::m19>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<19, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m20), &TYPE::m20>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<20, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m21), &TYPE::m21>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<21, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m22), &TYPE::m22>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<22, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m23), &TYPE::m23>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<23, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m24), &TYPE::m24>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<24, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m25), &TYPE::m25>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<25, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m26), &TYPE::m26>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<26, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m27), &TYPE::m27>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<27, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m28), &TYPE::m28>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<28, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m29), &TYPE::m29>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<29, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m30), &TYPE::m30>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<30, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m31), &TYPE::m31>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<31, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m32), &TYPE::m32>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<32, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m33), &TYPE::m33>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<33, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m34), &TYPE::m34>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<34, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m35), &TYPE::m35>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<35, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m36), &TYPE::m36>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<36, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m37), &TYPE::m37>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<37, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m38), &TYPE::m38>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<38, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m39), &TYPE::m39>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<39, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m40), &TYPE::m40>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<40, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m41), &TYPE::m41>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<41, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m42), &TYPE::m42>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<42, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m43), &TYPE::m43>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<43, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m44), &TYPE::m44>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<44, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m45), &TYPE::m45>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<45, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m46), &TYPE::m46>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<46, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m47), &TYPE::m47>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<47, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m48), &TYPE::m48>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<48, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m49), &TYPE::m49>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<49, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m50), &TYPE::m50>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<50, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m51), &TYPE::m51>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<51, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m52), &TYPE::m52>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<52, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m53), &TYPE::m53>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<53, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m54), &TYPE::m54>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<54, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m55), &TYPE::m55>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<55, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m56), &TYPE::m56>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<56, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m57), &TYPE::m57>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<57, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m58), &TYPE::m58>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<58, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m59), &TYPE::m59>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<59, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m60), &TYPE::m60>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<60, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m61), &TYPE::m61>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<61, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m62), &TYPE::m62>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<62, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m63), &TYPE::m63>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<63, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m64), &TYPE::m64>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<64, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m65), &TYPE::m65>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<65, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m66), &TYPE::m66>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<66, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m67), &TYPE::m67>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<67, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m68), &TYPE::m68>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<68, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m69), &TYPE::m69>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<69, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m70), &TYPE::m70>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<70, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m71), &TYPE::m71>{})\
                );                                                                                \
            }                                                                                     \
        };                                                                                        \
    }}                                                                                            \
/**/

#define BOOST_HANA_ADAPT_STRUCT_IMPL_73(TYPE , m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12, m13, m14, m15, m16, m17, m18, m19, m20, m21, m22, m23, m24, m25, m26, m27, m28, m29, m30, m31, m32, m33, m34, m35, m36, m37, m38, m39, m40, m41, m42, m43, m44, m45, m46, m47, m48, m49, m50, m51, m52, m53, m54, m55, m56, m57, m58, m59, m60, m61, m62, m63, m64, m65, m66, m67, m68, m69, m70, m71, m72)    \
    namespace boost { namespace hana {                                                            \
        template <>                                                                               \
        struct accessors_impl<TYPE> {                                                             \
            static constexpr auto apply() {                                                       \
                struct member_names {                                                             \
                  static constexpr auto get() {                                                   \
                      return ::boost::hana::make_tuple(                                           \
                          BOOST_HANA_PP_STRINGIZE(m1), BOOST_HANA_PP_STRINGIZE(m2), BOOST_HANA_PP_STRINGIZE(m3), BOOST_HANA_PP_STRINGIZE(m4), BOOST_HANA_PP_STRINGIZE(m5), BOOST_HANA_PP_STRINGIZE(m6), BOOST_HANA_PP_STRINGIZE(m7), BOOST_HANA_PP_STRINGIZE(m8), BOOST_HANA_PP_STRINGIZE(m9), BOOST_HANA_PP_STRINGIZE(m10), BOOST_HANA_PP_STRINGIZE(m11), BOOST_HANA_PP_STRINGIZE(m12), BOOST_HANA_PP_STRINGIZE(m13), BOOST_HANA_PP_STRINGIZE(m14), BOOST_HANA_PP_STRINGIZE(m15), BOOST_HANA_PP_STRINGIZE(m16), BOOST_HANA_PP_STRINGIZE(m17), BOOST_HANA_PP_STRINGIZE(m18), BOOST_HANA_PP_STRINGIZE(m19), BOOST_HANA_PP_STRINGIZE(m20), BOOST_HANA_PP_STRINGIZE(m21), BOOST_HANA_PP_STRINGIZE(m22), BOOST_HANA_PP_STRINGIZE(m23), BOOST_HANA_PP_STRINGIZE(m24), BOOST_HANA_PP_STRINGIZE(m25), BOOST_HANA_PP_STRINGIZE(m26), BOOST_HANA_PP_STRINGIZE(m27), BOOST_HANA_PP_STRINGIZE(m28), BOOST_HANA_PP_STRINGIZE(m29), BOOST_HANA_PP_STRINGIZE(m30), BOOST_HANA_PP_STRINGIZE(m31), BOOST_HANA_PP_STRINGIZE(m32), BOOST_HANA_PP_STRINGIZE(m33), BOOST_HANA_PP_STRINGIZE(m34), BOOST_HANA_PP_STRINGIZE(m35), BOOST_HANA_PP_STRINGIZE(m36), BOOST_HANA_PP_STRINGIZE(m37), BOOST_HANA_PP_STRINGIZE(m38), BOOST_HANA_PP_STRINGIZE(m39), BOOST_HANA_PP_STRINGIZE(m40), BOOST_HANA_PP_STRINGIZE(m41), BOOST_HANA_PP_STRINGIZE(m42), BOOST_HANA_PP_STRINGIZE(m43), BOOST_HANA_PP_STRINGIZE(m44), BOOST_HANA_PP_STRINGIZE(m45), BOOST_HANA_PP_STRINGIZE(m46), BOOST_HANA_PP_STRINGIZE(m47), BOOST_HANA_PP_STRINGIZE(m48), BOOST_HANA_PP_STRINGIZE(m49), BOOST_HANA_PP_STRINGIZE(m50), BOOST_HANA_PP_STRINGIZE(m51), BOOST_HANA_PP_STRINGIZE(m52), BOOST_HANA_PP_STRINGIZE(m53), BOOST_HANA_PP_STRINGIZE(m54), BOOST_HANA_PP_STRINGIZE(m55), BOOST_HANA_PP_STRINGIZE(m56), BOOST_HANA_PP_STRINGIZE(m57), BOOST_HANA_PP_STRINGIZE(m58), BOOST_HANA_PP_STRINGIZE(m59), BOOST_HANA_PP_STRINGIZE(m60), BOOST_HANA_PP_STRINGIZE(m61), BOOST_HANA_PP_STRINGIZE(m62), BOOST_HANA_PP_STRINGIZE(m63), BOOST_HANA_PP_STRINGIZE(m64), BOOST_HANA_PP_STRINGIZE(m65), BOOST_HANA_PP_STRINGIZE(m66), BOOST_HANA_PP_STRINGIZE(m67), BOOST_HANA_PP_STRINGIZE(m68), BOOST_HANA_PP_STRINGIZE(m69), BOOST_HANA_PP_STRINGIZE(m70), BOOST_HANA_PP_STRINGIZE(m71), BOOST_HANA_PP_STRINGIZE(m72)   \
                      );                                                                          \
                  }                                                                               \
                };                                                                                \
                return ::boost::hana::make_tuple(                                                 \
                    ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<0, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m1), &TYPE::m1>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<1, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m2), &TYPE::m2>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<2, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m3), &TYPE::m3>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<3, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m4), &TYPE::m4>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<4, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m5), &TYPE::m5>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<5, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m6), &TYPE::m6>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<6, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m7), &TYPE::m7>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<7, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m8), &TYPE::m8>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<8, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m9), &TYPE::m9>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<9, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m10), &TYPE::m10>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<10, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m11), &TYPE::m11>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<11, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m12), &TYPE::m12>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<12, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m13), &TYPE::m13>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<13, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m14), &TYPE::m14>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<14, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m15), &TYPE::m15>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<15, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m16), &TYPE::m16>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<16, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m17), &TYPE::m17>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<17, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m18), &TYPE::m18>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<18, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m19), &TYPE::m19>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<19, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m20), &TYPE::m20>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<20, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m21), &TYPE::m21>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<21, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m22), &TYPE::m22>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<22, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m23), &TYPE::m23>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<23, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m24), &TYPE::m24>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<24, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m25), &TYPE::m25>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<25, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m26), &TYPE::m26>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<26, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m27), &TYPE::m27>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<27, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m28), &TYPE::m28>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<28, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m29), &TYPE::m29>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<29, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m30), &TYPE::m30>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<30, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m31), &TYPE::m31>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<31, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m32), &TYPE::m32>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<32, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m33), &TYPE::m33>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<33, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m34), &TYPE::m34>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<34, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m35), &TYPE::m35>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<35, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m36), &TYPE::m36>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<36, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m37), &TYPE::m37>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<37, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m38), &TYPE::m38>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<38, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m39), &TYPE::m39>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<39, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m40), &TYPE::m40>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<40, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m41), &TYPE::m41>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<41, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m42), &TYPE::m42>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<42, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m43), &TYPE::m43>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<43, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m44), &TYPE::m44>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<44, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m45), &TYPE::m45>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<45, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m46), &TYPE::m46>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<46, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m47), &TYPE::m47>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<47, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m48), &TYPE::m48>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<48, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m49), &TYPE::m49>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<49, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m50), &TYPE::m50>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<50, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m51), &TYPE::m51>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<51, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m52), &TYPE::m52>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<52, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m53), &TYPE::m53>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<53, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m54), &TYPE::m54>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<54, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m55), &TYPE::m55>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<55, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m56), &TYPE::m56>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<56, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m57), &TYPE::m57>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<57, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m58), &TYPE::m58>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<58, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m59), &TYPE::m59>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<59, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m60), &TYPE::m60>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<60, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m61), &TYPE::m61>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<61, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m62), &TYPE::m62>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<62, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m63), &TYPE::m63>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<63, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m64), &TYPE::m64>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<64, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m65), &TYPE::m65>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<65, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m66), &TYPE::m66>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<66, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m67), &TYPE::m67>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<67, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m68), &TYPE::m68>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<68, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m69), &TYPE::m69>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<69, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m70), &TYPE::m70>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<70, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m71), &TYPE::m71>{}), ::boost::hana::make_pair(::boost::hana::struct_detail::prepare_member_name<71, member_names>(), ::boost::hana::struct_detail::member_ptr<decltype(&TYPE::m72), &TYPE::m72>{})\
                );                                                                                \
            }                       