#---------------------------------------------------------------------------
# Name:        wx/__init__.py
# Author:      Robin Dunn
#
# Created:     3-Nov-2010
# Copyright:   (c) 2010-2020 by Total Control Software
# License:     wxWindows License
#---------------------------------------------------------------------------

import os
import platform

# Set GDK_BACKEND=x11 on linux, as the conda-forge wxwidgets build
# is compiled to use GLX, which would cause a segmentation fault
# when running under Wayland.
if platform.system() == 'Linux':
    os.environ['GDK_BACKEND'] = 'x11'

# Load the main version string into the package namespace
import wx.__version__
__version__ = wx.__version__.VERSION_STRING


# Import all items from the core wxPython module so they appear in the wx
# package namespace.
from wx.core import *


# Clean up the package namespace
del core
del wx
del os
del platform
